/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https_jetty;

import java.security.SecureRandom;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.transport.https.SSLUtils;
import org.mortbay.jetty.security.SslSocketConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFJettySslSocketConnector
extends SslSocketConnector {
    private static final Logger LOG = LogUtils.getL7dLogger(CXFJettySslSocketConnector.class);
    protected KeyManager[] keyManagers;
    protected TrustManager[] trustManagers;
    protected SecureRandom secureRandom;
    protected List<String> cipherSuites;
    protected FiltersType cipherSuitesFilter;

    protected void setCipherSuites(List<String> cs) {
        this.cipherSuites = cs;
    }

    protected void setCipherSuitesFilter(FiltersType filter) {
        this.cipherSuitesFilter = filter;
    }

    protected void setKeyManagers(KeyManager[] kmgrs) {
        this.keyManagers = kmgrs;
    }

    protected void setTrustManagers(TrustManager[] tmgrs) {
        this.trustManagers = tmgrs;
    }

    protected void setSecureRandom(SecureRandom random) {
        this.secureRandom = random;
    }

    protected void setClientAuthentication(ClientAuthentication clientAuth) {
        if (clientAuth != null) {
            if (clientAuth.isSetWant()) {
                this.setWantClientAuth(clientAuth.isWant());
            }
            if (clientAuth.isSetRequired()) {
                this.setNeedClientAuth(clientAuth.isRequired());
            }
        }
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        String proto = this.getProtocol() == null ? "TLS" : this.getProtocol();
        SSLContext context = this.getProvider() == null ? SSLContext.getInstance(proto) : SSLContext.getInstance(proto, this.getProvider());
        context.init(this.keyManagers, this.trustManagers, this.secureRandom);
        SSLServerSocketFactory con = context.getServerSocketFactory();
        String[] cs = SSLUtils.getCiphersuites(this.cipherSuites, SSLUtils.getServerSupportedCipherSuites(context), this.cipherSuitesFilter, LOG, true);
        this.setExcludeCipherSuites(cs);
        return con;
    }
}

