/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class UnknownAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/UnknownAttribute.java,v 1.14 2008/02/21 04:45:05 dclunie Exp $";

    public UnknownAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public UnknownAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public UnknownAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.valueLength = l;
        this.valueMultiplicity = 1;
        try {
            dicomInputStream.skipInsistently(l);
        }
        catch (IOException iOException) {
            throw new DicomException("Failed to skip value (length " + l + " dec) in UN attribute " + this.getTag());
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
    }

    public String toString(DicomDictionary dicomDictionary) {
        return super.toString(dicomDictionary) + " " + this.getVR() + " ";
    }

    public void removeValues() {
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public byte[] getVR() {
        return ValueRepresentation.UN;
    }
}

