/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.network.Association;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PDataPDU;
import com.pixelmed.network.PresentationDataValue;
import com.pixelmed.network.ReceivedDataHandler;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.HexDump;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class CompositeResponseHandler
extends ReceivedDataHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/CompositeResponseHandler.java,v 1.11 2005/10/16 19:54:20 dclunie Exp $";
    protected byte[] commandReceived = null;
    protected byte[] dataReceived = null;
    protected boolean success = false;
    protected boolean allowData;

    CompositeResponseHandler(int n) {
        super(n);
        this.done = false;
        this.allowData = false;
    }

    public static AttributeList getAttributeListFromCommandOrData(byte[] byArray, String string, int n) throws DicomNetworkException, DicomException, IOException {
        if (n > 1) {
            System.err.println(HexDump.dump(byArray));
        }
        AttributeList attributeList = new AttributeList();
        attributeList.read(new DicomInputStream(new ByteArrayInputStream(byArray), string, false));
        if (n > 1) {
            System.err.print(attributeList);
        }
        return attributeList;
    }

    private AttributeList getAttributeListFromCommandOrData(byte[] byArray, String string) throws DicomNetworkException, DicomException, IOException {
        return CompositeResponseHandler.getAttributeListFromCommandOrData(byArray, string, this.debugLevel);
    }

    public static String dumpAttributeListFromCommandOrData(byte[] byArray, String string) throws DicomNetworkException, DicomException, IOException {
        String string2 = null;
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(new DicomInputStream(new ByteArrayInputStream(byArray), string, false));
            string2 = attributeList.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            string2 = null;
        }
        return string2;
    }

    public void sendPDataIndication(PDataPDU pDataPDU, Association association) throws DicomNetworkException, DicomException, IOException {
        if (this.debugLevel > 0) {
            System.err.println("CompositeResponseHandler:");
        }
        if (this.debugLevel > 0) {
            super.dumpPDVList(pDataPDU.getPDVList());
        }
        LinkedList linkedList = pDataPDU.getPDVList();
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            AttributeList attributeList;
            PresentationDataValue presentationDataValue = (PresentationDataValue)listIterator.next();
            if (presentationDataValue.isCommand()) {
                this.commandReceived = ByteArray.concatenate(this.commandReceived, presentationDataValue.getValue());
                if (!presentationDataValue.isLastFragment()) continue;
                if (this.debugLevel > 0) {
                    System.err.println("CompositeResponseHandler: last fragment of command seen");
                }
                attributeList = this.getAttributeListFromCommandOrData(this.commandReceived, "1.2.840.10008.1.2");
                this.commandReceived = null;
                this.evaluateStatusAndSetSuccess(attributeList);
                continue;
            }
            if (this.allowData) {
                this.dataReceived = ByteArray.concatenate(this.dataReceived, presentationDataValue.getValue());
                if (!presentationDataValue.isLastFragment()) continue;
                if (this.debugLevel > 0) {
                    System.err.println("CompositeResponseHandler: last fragment of data seen");
                }
                attributeList = this.getAttributeListFromCommandOrData(this.dataReceived, association.getTransferSyntaxForPresentationContextID(presentationDataValue.getPresentationContextID()));
                this.makeUseOfDataSet(attributeList);
                this.dataReceived = null;
                continue;
            }
            throw new DicomNetworkException("Unexpected data fragment in response PDU");
        }
    }

    protected abstract void evaluateStatusAndSetSuccess(AttributeList var1);

    protected void makeUseOfDataSet(AttributeList attributeList) {
    }

    public boolean wasSuccessful() {
        return this.success;
    }
}

