/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class DescendantIterator
extends LocPathIterator {
    private transient Node m_startContext;
    private boolean m_orSelf;
    private boolean m_fromRoot;

    public DescendantIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        super(compiler, opPos, analysis, false);
        int[] ops = compiler.getOpMap();
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        int stepType = ops[firstStepPos];
        if (stepType == 42) {
            this.m_orSelf = true;
        }
        if (stepType == 48) {
            this.m_orSelf = true;
            firstStepPos += 8;
        } else if (stepType == 50) {
            this.m_fromRoot = true;
            this.m_orSelf = true;
            firstStepPos += 8;
        } else {
            this.m_orSelf = false;
        }
        int whatToShow = compiler.getWhatToShow(firstStepPos);
        if ((whatToShow & 0x43) == 0 || whatToShow == -1) {
            this.initNodeTest(whatToShow);
        } else {
            this.initNodeTest(whatToShow, compiler.getStepNS(firstStepPos), compiler.getStepLocalName(firstStepPos));
        }
        this.initPredicateInfo(compiler, firstStepPos);
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        DescendantIterator clone = (DescendantIterator)super.cloneWithReset();
        clone.resetProximityPositions();
        return clone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node nextNode() throws DOMException {
        Node node;
        int savedStart;
        VariableStack vars;
        Node pos;
        boolean getSelf;
        if (this.m_cachedNodes != null && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            Node next = this.m_cachedNodes.nextNode();
            this.setCurrentPos(this.m_cachedNodes.getCurrentPos());
            return next;
        }
        if (this.m_foundLast) {
            return null;
        }
        if (this.m_lastFetched == null) {
            getSelf = this.m_orSelf;
            pos = getSelf && this.m_fromRoot ? (this.m_context.getNodeType() == 9 ? this.m_context : this.m_context.getOwnerDocument()) : this.m_context;
            this.m_startContext = pos;
            this.resetProximityPositions();
        } else {
            pos = this.m_lastFetched;
            getSelf = false;
        }
        if (this.m_varStackPos != -1) {
            vars = this.m_execContext.getVarStack();
            savedStart = vars.getSearchStart();
            vars.setSearchStart(this.m_varStackPos);
            vars.pushContextPosition(this.m_varStackContext);
        } else {
            vars = null;
            savedStart = 0;
        }
        try {
            Node top = this.m_startContext;
            Node next = null;
            while (pos != null) {
                if (getSelf) {
                    this.m_lastFetched = pos;
                    if (this.acceptNode(pos) == 1) {
                        next = pos;
                        break;
                    }
                } else {
                    getSelf = true;
                }
                Node nextNode = pos.getFirstChild();
                while (nextNode == null) {
                    if (top.equals(pos)) break;
                    nextNode = pos.getNextSibling();
                    if (nextNode != null || (pos = pos.getParentNode()) != null && !top.equals(pos)) continue;
                    nextNode = null;
                    break;
                }
                pos = nextNode;
            }
            this.m_lastFetched = next;
            if (next != null) {
                if (this.m_cachedNodes != null) {
                    this.m_cachedNodes.addElement(next);
                }
                ++this.m_next;
                Node node2 = next;
                Object var7_11 = null;
                if (this.m_varStackPos == -1) return node2;
                vars.setSearchStart(savedStart);
                vars.popContextPosition();
                return node2;
            }
            this.m_foundLast = true;
            this.m_startContext = null;
            node = null;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (this.m_varStackPos == -1) throw throwable;
            vars.setSearchStart(savedStart);
            vars.popContextPosition();
            throw throwable;
        }
        Object var7_12 = null;
        if (this.m_varStackPos == -1) return node;
        vars.setSearchStart(savedStart);
        vars.popContextPosition();
        return node;
    }
}

