/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_boolean
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private boolean[] items = new boolean[this.max_size];

    public Vector_boolean() {
    }

    protected int incrementSize(int n) {
        n = n < 8000 ? (n *= 4) : (n < 16000 ? (n *= 2) : (n += 2000));
        return n;
    }

    public Vector_boolean(int n) {
        this.max_size = n;
        this.items = new boolean[this.max_size];
    }

    public final boolean[] get() {
        return this.items;
    }

    public final void setElementAt(boolean bl, int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        this.items[n] = bl;
    }

    public final int size() {
        return this.items.length;
    }

    public final void addElement(boolean bl) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = bl;
        ++this.current_item;
    }

    public final void set(boolean[] blArray) {
        this.items = blArray;
    }

    public final void removeElementAt(int n) {
        if (n >= 0) {
            System.arraycopy(this.items, n + 1, this.items, n, this.max_size - 2 - n);
            this.items[this.max_size - 1] = false;
        } else {
            this.items[0] = false;
        }
        --this.current_item;
    }

    public final void clear() {
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = false;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = false;
            }
        }
        this.current_item = 0;
    }

    public final boolean elementAt(int n) {
        if (n >= this.max_size) {
            return false;
        }
        return this.items[n];
    }

    public final void insertElementAt(boolean bl, int n) {
        this.current_item = this.items.length;
        this.checkSize(this.current_item + 1);
        for (int i = this.current_item; i > n; --i) {
            this.items[i + 1] = this.items[i];
        }
        this.items[n] = bl;
        ++this.current_item;
    }

    private final void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            boolean[] blArray = this.items;
            this.items = new boolean[this.max_size];
            System.arraycopy(blArray, 0, this.items, 0, n2);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        boolean[] blArray = new boolean[this.current_item];
        System.arraycopy(this.items, 0, blArray, 0, this.current_item);
        this.items = blArray;
        this.max_size = this.current_item;
    }

    public void setSize(int n) {
        this.current_item = n;
    }
}

