/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util.CharConvBuilder;

import java.io.IOException;
import java.util.Vector;
import oracle.gss.util.CharConvBuilder.MappingSetter;

abstract class LCMapSetter
extends MappingSetter {
    static final int ENTRYWIDTH = 18;
    static final int MAXCHARVALUE = 65535;
    static final int LCWIDTH = 16;
    static final int LCSHIFT = 16;
    static final int LCMASK = 65535;
    static final int INVALIDLC = 65535;
    int m_l1KeyWidth;
    int m_l1BlockSize;
    int m_ucsReplacement;
    char[] m_leadingCode;
    int m_lcCount;
    Vector[] m_mapStores;

    LCMapSetter(int n, int n2, int n3) {
        super(n);
        this.m_l1KeyWidth = n2;
        this.m_l1BlockSize = 1 << n2;
        this.m_ucsReplacement = n3;
        this.m_leadingCode = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
        this.m_mapStores = new Vector[this.m_leadingCode.length];
        this.m_lcCount = 0;
    }

    void buildMapping() {
        int n;
        int n2;
        int n3;
        char c;
        char c2;
        char[] cArray;
        int n4;
        Vector vector;
        int n5;
        int n6 = this.m_l1KeyWidth;
        int n7 = 16 - n6;
        int n8 = (1 << n6) - 1;
        int n9 = (1 << n7) - 1;
        int n10 = this.m_l1BlockSize * this.m_lcCount;
        char[] cArray2 = new char[n10];
        char[][] cArray3 = new char[n10][2];
        int n11 = 0;
        while (n11 < n10) {
            cArray2[n11] = '\u0000';
            cArray3[n11][0] = (char)n9;
            cArray3[n11][1] = '\u0000';
            ++n11;
        }
        int n12 = this.m_ucsReplacement;
        int n13 = 0;
        while (n13 < this.m_lcCount) {
            n5 = this.m_l1BlockSize * n13;
            vector = this.m_mapStores[n13];
            n4 = vector.size();
            n11 = 0;
            while (n11 < n4) {
                cArray = (char[])vector.elementAt(n11);
                c2 = cArray[1];
                if (c2 != n12) {
                    c = cArray[0];
                    n3 = (c >> n7 & n8) + n5;
                    cArray2[n3] = '\u0001';
                    n2 = c & n9;
                    if (n2 < cArray3[n3][0]) {
                        cArray3[n3][0] = (char)n2;
                    }
                    if (n2 > cArray3[n3][1]) {
                        cArray3[n3][1] = (char)n2;
                    }
                }
                ++n11;
            }
            ++n13;
        }
        int n14 = n = n9 + 1;
        int n15 = 0;
        n11 = 0;
        while (n11 < n10) {
            if (cArray2[n11] != '\u0000') {
                int n16 = cArray3[n11][0];
                cArray2[n11] = (char)(n14 - (n15 < n16 ? n15 : n16));
                n14 = cArray2[n11] + n;
                n15 = n - cArray3[n11][1] - 1;
            }
            ++n11;
        }
        char[] cArray4 = new char[n14];
        n11 = 0;
        while (n11 < n14) {
            cArray4[n11] = (char)n12;
            ++n11;
        }
        n13 = 0;
        while (n13 < this.m_lcCount) {
            n5 = this.m_l1BlockSize * n13;
            vector = this.m_mapStores[n13];
            n4 = vector.size();
            n11 = 0;
            while (n11 < n4) {
                cArray = (char[])vector.elementAt(n11);
                c2 = cArray[1];
                if (c2 != n12) {
                    c = cArray[0];
                    n3 = (c >> n7 & n8) + n5;
                    n2 = c & n9;
                    int n17 = cArray2[n3] + n2;
                    cArray4[n17] = c2;
                }
                ++n11;
            }
            ++n13;
        }
        this.setArray2(cArray4);
        this.setArray(cArray2);
        this.setLCTable();
    }

    void finish() {
        this.buildMapping();
        super.finish();
    }

    boolean set(int n, int n2) throws IOException {
        Vector<char[]> vector;
        int n3 = n >> 16 & 0xFFFF;
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.m_lcCount) {
            if (n3 == this.m_leadingCode[n5]) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        if (n4 == -1) {
            if (n5 < this.m_leadingCode.length) {
                this.m_leadingCode[n5] = (char)n3;
                n4 = n5;
                this.m_lcCount = n5 + 1;
            } else {
                this.printErrorMsg("***** Error: too many leading codes: " + MappingSetter.intToHex8(n3));
                return false;
            }
        }
        if ((vector = this.m_mapStores[n5]) == null) {
            this.m_mapStores[n5] = vector = new Vector<char[]>();
        }
        char[] cArray = new char[]{(char)n, (char)n2};
        vector.addElement(cArray);
        return true;
    }

    abstract void setArray(char[] var1);

    abstract void setArray2(char[] var1);

    abstract void setLCTable();
}

