/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeSINT32;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OracleTypeCOLLECTION
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -7279638692691669378L;
    public static final int TYPE_PLSQL_INDEX_TABLE = 1;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int TYPE_VARRAY = 3;
    int m_userCode = 0;
    long m_maxSize = 0L;
    OracleType m_elemType = null;

    public OracleTypeCOLLECTION(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeCOLLECTION(OracleTypeADT oracleTypeADT, int n, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n, (Connection)oracleConnection);
    }

    public synchronized Datum _unlinearize(byte[] byArray, long l, Datum datum, long l2, int n, int n2, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        if ((byArray[0] & 0x80) > 0) {
            PickleContext pickleContext = new PickleContext(byArray, l);
            return this.unpickle81(pickleContext, (ARRAY)datum, l2, n, 1, n2, map);
        }
        UnpickleContext unpickleContext = new UnpickleContext(byArray, (int)l, null, null, this.big_endian);
        return this.unpickle80(unpickleContext, (ARRAY)datum, l2, n, 1, n2, map);
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        if (this.m_descriptor == null) {
            this.m_descriptor = !this.m_hasName && this.getFullName(false) == null ? new ArrayDescriptor(this, (Connection)this.m_conn) : ArrayDescriptor.createDescriptor(this.m_fullName, this.m_conn);
        }
        return (ArrayDescriptor)this.m_descriptor;
    }

    private long getAccessLength(long l, long l2, int n) throws SQLException {
        if (l2 > l) {
            return 0L;
        }
        if (n < 0) {
            return l - l2 + 1L;
        }
        return Math.min(l - l2 + 1L, (long)n);
    }

    public OracleType getAttrTypeAt(int n) throws SQLException {
        return null;
    }

    public String getAttributeName(int n) throws SQLException {
        DBError.throwSqlException(1);
        return null;
    }

    public String getAttributeName(int n, boolean bl) throws SQLException {
        return this.getAttributeName(n);
    }

    public String getAttributeType(int n) throws SQLException {
        if (n != 1) {
            DBError.throwSqlException(68);
        }
        if (!this.m_hasName) {
            this.getFullName();
        }
        if (this.m_attrTypeNames == null) {
            this.initCollElemTypeName();
        }
        return this.m_attrTypeNames[0];
    }

    public String getAttributeType(int n, boolean bl) throws SQLException {
        if (bl) {
            return this.getAttributeType(n);
        }
        if (n != 1) {
            DBError.throwSqlException(68);
        }
        if (this.m_hasName && this.m_attrTypeNames != null) {
            return this.m_attrTypeNames[0];
        }
        return null;
    }

    public OracleType getElementType() throws SQLException {
        return this.m_elemType;
    }

    public long getMaxLength() throws SQLException {
        return this.m_maxSize;
    }

    public int getNumAttrs() throws SQLException {
        return 0;
    }

    public int getTypeCode() {
        return 2003;
    }

    public int getUserCode() throws SQLException {
        return this.m_userCode;
    }

    private synchronized void initCollElemTypeName() throws SQLException {
        Statement statement = this.m_conn.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE TYPE_NAME='" + this.m_typeName + "' AND OWNER='" + this.m_schemaName + "'");
        if (resultSet.next()) {
            if (this.m_attrTypeNames == null) {
                this.m_attrTypeNames = new String[1];
            }
            this.m_attrTypeNames[0] = String.valueOf(resultSet.getString(2)) + "." + resultSet.getString(1);
        } else {
            DBError.throwSqlException(1);
        }
        resultSet.close();
        statement.close();
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public synchronized boolean isInlineImage(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return false;
        }
        if ((byArray[0] & 0x80) > 0) {
            if (PickleContext.isCollectionImage_pctx(byArray[0])) {
                return true;
            }
            if (PickleContext.isDegenerateImage_pctx(byArray[0])) {
                return false;
            }
            DBError.throwSqlException(1, "Image is not a collection image");
            return false;
        }
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            return false;
        }
        return (byArray[10] & 1) == 1;
    }

    public boolean isObjectType() {
        return false;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        long l = streamInfo.readLong();
        this.m_maxSize = streamInfo.readLong();
        this.m_userCode = streamInfo.readByte();
        streamInfo.addSimplePatch(l, this);
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        ARRAY aRRAY = (ARRAY)datum;
        boolean bl = aRRAY.hasDataSeg();
        int n = 0;
        int n2 = pickleContext.offset() + 2;
        if (bl) {
            Datum[] datumArray = aRRAY.getOracleArray();
            if (this.m_userCode == 3 && (long)datumArray.length > this.m_maxSize) {
                DBError.check_error(71, null);
            }
            n += pickleContext.writeCollImageHeader_pctx(datumArray.length);
            int n3 = 0;
            while (n3 < datumArray.length) {
                n = datumArray[n3] == null ? (n += pickleContext.writeEltNull_pctx()) : (n += this.m_elemType.pickle81(pickleContext, datumArray[n3]));
                ++n3;
            }
        } else {
            n += pickleContext.writeCollImageHeader_pctx(aRRAY.getLocator());
        }
        pickleContext.patchImageLen_pctx(n2, n);
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeCOLLECTION::readObject");
        }
        this.m_userCode = objectInputStream.readInt();
        this.m_maxSize = objectInputStream.readLong();
        this.m_elemType = (OracleType)objectInputStream.readObject();
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.m_conn = oracleConnection;
        this.m_elemType.setConnection(oracleConnection);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof ARRAY) {
                return (ARRAY)object;
            }
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            return new ARRAY(arrayDescriptor, this.m_conn, object);
        }
        return null;
    }

    public synchronized Datum unlinearize(byte[] byArray, long l, Datum datum, int n, Map map) throws SQLException {
        return this.unlinearize(byArray, l, datum, 1L, -1, n, map);
    }

    public Datum unlinearize(byte[] byArray, long l, Datum datum, long l2, int n, int n2, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getConnection();
        Datum datum2 = null;
        if (oracleConnection == null) {
            datum2 = this._unlinearize(byArray, l, datum, l2, n, n2, map);
        } else {
            OracleConnection oracleConnection2 = oracleConnection;
            synchronized (oracleConnection2) {
                datum2 = this._unlinearize(byArray, l, datum, l2, n, n2, map);
            }
        }
        return datum2;
    }

    protected ARRAY unpickle80(UnpickleContext unpickleContext, ARRAY aRRAY, int n, int n2, Map map) throws SQLException {
        return this.unpickle80(unpickleContext, aRRAY, 1L, -1, n, n2, map);
    }

    protected ARRAY unpickle80(UnpickleContext unpickleContext, ARRAY aRRAY, long l, int n, int n2, int n3, Map map) throws SQLException {
        boolean bl;
        long l2;
        ARRAY aRRAY2 = aRRAY;
        if (n2 == 3) {
            if (aRRAY2 == null) {
                ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
                aRRAY2 = new ARRAY(arrayDescriptor, null, this.m_conn);
            }
            aRRAY2.setImage(unpickleContext.image(), unpickleContext.absolute_offset(), 0L);
        }
        if ((l2 = unpickleContext.read_long()) == 0L) {
            return null;
        }
        if (n2 == 9) {
            unpickleContext.skip_bytes((int)l2);
            return aRRAY2;
        }
        if (n2 == 3) {
            aRRAY2.setImageLength(l2 + 4L);
            unpickleContext.skip_bytes((int)l2);
            return aRRAY2;
        }
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            aRRAY2 = new ARRAY(arrayDescriptor, null, this.m_conn);
        }
        unpickleContext.skip_bytes(2);
        long l3 = unpickleContext.read_long();
        byte by = unpickleContext.read_byte();
        aRRAY2.setLocator(unpickleContext.read_bytes((int)l3 - 1));
        boolean bl2 = bl = (by & 1) == 1;
        if (bl) {
            long l4 = unpickleContext.read_long() + (long)unpickleContext.offset();
            UnpickleContext unpickleContext2 = new UnpickleContext(unpickleContext.image(), unpickleContext.absolute_offset(), null, null, this.big_endian);
            aRRAY2 = l == 1L && n == -1 ? (ARRAY)this.unpickle80rec(unpickleContext2, aRRAY2, n3, map) : (ARRAY)this.unpickle80rec(unpickleContext2, aRRAY2, l, n, n3, map);
            unpickleContext.skip_to(l4);
        }
        return aRRAY2;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        return this.unpickle80rec(unpickleContext, null, n2, map);
    }

    private Object unpickle80rec(UnpickleContext unpickleContext, ARRAY aRRAY, int n, Map map) throws SQLException {
        ARRAY aRRAY2 = aRRAY;
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            aRRAY2 = new ARRAY(arrayDescriptor, null, this.m_conn);
        }
        int n2 = (int)unpickleContext.read_long();
        aRRAY2.setLength(n2);
        if (n == 0) {
            return aRRAY2;
        }
        byte by = unpickleContext.read_byte();
        if (by != 0 && by != 2) {
            DBError.throwSqlException(23, "collection flag = " + by);
        }
        int n3 = by == 0 ? 2 : 3;
        this.unpickle80rec_elems(unpickleContext, aRRAY2, 1, n2, n, map, n3);
        return aRRAY2;
    }

    private Object unpickle80rec(UnpickleContext unpickleContext, ARRAY aRRAY, long l, int n, int n2, Map map) throws SQLException {
        boolean bl;
        ARRAY aRRAY2 = aRRAY;
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            aRRAY2 = new ARRAY(arrayDescriptor, null, this.m_conn);
        }
        long l2 = unpickleContext.read_long();
        aRRAY2.setLength((int)l2);
        byte by = unpickleContext.read_byte();
        if (by != 0 && by != 2) {
            DBError.throwSqlException(23, "collection flag = " + by);
        }
        int n3 = by == 0 ? 2 : 3;
        int n4 = (int)this.getAccessLength(l2, l, n);
        boolean bl2 = bl = ArrayDescriptor.getCacheStyle(aRRAY2) == 1;
        if (l > 1L && n4 > 0) {
            if (this.m_elemType instanceof OracleTypeNUMBER || this.m_elemType instanceof OracleTypeFLOAT || this.m_elemType instanceof OracleTypeSINT32) {
                switch (n3) {
                    case 2: {
                        unpickleContext.skip_bytes(23 * ((int)l - 1));
                        break;
                    }
                    case 3: {
                        unpickleContext.skip_bytes(22 * ((int)l - 1));
                        break;
                    }
                    default: {
                        DBError.throwSqlException(1);
                        break;
                    }
                }
            } else {
                long l3 = aRRAY2.getLastIndex();
                if (l3 < l) {
                    if (l3 > 0L) {
                        unpickleContext.skip_to(aRRAY2.getLastOffset());
                    } else {
                        l3 = 1L;
                    }
                    if (bl) {
                        long l4 = l3;
                        while (l4 < l) {
                            aRRAY2.setIndexOffset(l4, unpickleContext.offset());
                            this.m_elemType.unpickle80rec(unpickleContext, n3, 9, null);
                            ++l4;
                        }
                    } else {
                        long l5 = l3;
                        while (l5 < l) {
                            this.m_elemType.unpickle80rec(unpickleContext, n3, 9, null);
                            ++l5;
                        }
                    }
                } else if (l3 > l) {
                    long l6 = aRRAY2.getOffset(l);
                    if (l6 != -1L) {
                        unpickleContext.skip_to(l6);
                    } else if (bl) {
                        long l7 = 1L;
                        while (l7 < l) {
                            aRRAY2.setIndexOffset(l7, unpickleContext.offset());
                            this.m_elemType.unpickle80rec(unpickleContext, n3, 9, null);
                            ++l7;
                        }
                    } else {
                        int n5 = 1;
                        while ((long)n5 < l) {
                            this.m_elemType.unpickle80rec(unpickleContext, n3, 9, null);
                            ++n5;
                        }
                    }
                } else {
                    unpickleContext.skip_to(aRRAY2.getLastOffset());
                }
                aRRAY2.setLastIndexOffset(l, unpickleContext.offset());
            }
        }
        this.unpickle80rec_elems(unpickleContext, aRRAY2, (int)l, n4, n2, map, n3);
        return aRRAY2;
    }

    private Object unpickle80rec_elems(UnpickleContext unpickleContext, ARRAY aRRAY, int n, int n2, int n3, Map map, int n4) throws SQLException {
        boolean bl = ArrayDescriptor.getCacheStyle(aRRAY) == 1;
        switch (n3) {
            case 1: {
                Datum[] datumArray = new Datum[n2];
                if (bl) {
                    int n5 = 0;
                    while (n5 < n2) {
                        aRRAY.setIndexOffset(n + n5, unpickleContext.offset());
                        datumArray[n5] = (Datum)this.m_elemType.unpickle80rec(unpickleContext, n4, n3, map);
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < n2) {
                        datumArray[n6] = (Datum)this.m_elemType.unpickle80rec(unpickleContext, n4, n3, map);
                        ++n6;
                    }
                }
                aRRAY.setDatumArray(datumArray);
                break;
            }
            case 2: {
                Object[] objectArray = ArrayDescriptor.makeJavaArray(n2, this.m_elemType.getTypeCode());
                if (bl) {
                    int n7 = 0;
                    while (n7 < n2) {
                        aRRAY.setIndexOffset(n + n7, unpickleContext.offset());
                        objectArray[n7] = this.m_elemType.unpickle80rec(unpickleContext, n4, n3, map);
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < n2) {
                        objectArray[n8] = this.m_elemType.unpickle80rec(unpickleContext, n4, n3, map);
                        ++n8;
                    }
                }
                aRRAY.setObjArray(objectArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.m_elemType instanceof OracleTypeNUMBER || this.m_elemType instanceof OracleTypeFLOAT) {
                    aRRAY.setObjArray(OracleTypeNUMBER.unpickle80_nativeArray(unpickleContext, 1L, n2, n3, n4));
                    break;
                }
                DBError.throwSqlException(23);
                break;
            }
            default: {
                DBError.throwSqlException(1);
            }
        }
        aRRAY.setLastIndexOffset(n + n2, unpickleContext.offset());
        return aRRAY;
    }

    ARRAY unpickle81(PickleContext pickleContext, ARRAY aRRAY, int n, int n2, Map map) throws SQLException {
        return this.unpickle81(pickleContext, aRRAY, 1L, -1, n, n2, map);
    }

    ARRAY unpickle81(PickleContext pickleContext, ARRAY aRRAY, long l, int n, int n2, int n3, Map map) throws SQLException {
        ARRAY aRRAY2 = aRRAY;
        if (aRRAY2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            aRRAY2 = new ARRAY(arrayDescriptor, null, this.m_conn);
        }
        if (this.unpickle81_imgHeader(pickleContext, aRRAY2, n2, n3)) {
            if (l == 1L && n == -1) {
                this.unpickle81_imgBody(pickleContext, aRRAY2, n3, map);
            } else {
                this.unpickle81_imgBody(pickleContext, aRRAY2, l, n, n3, map);
            }
        }
        return aRRAY2;
    }

    void unpickle81_imgBody(PickleContext pickleContext, ARRAY aRRAY, int n, Map map) throws SQLException {
        pickleContext.readByte_pctx();
        int n2 = pickleContext.readLength_pctx();
        aRRAY.setLength(n2);
        if (n == 0) {
            return;
        }
        this.unpickle81_imgBody_elems(pickleContext, aRRAY, 1, n2, n, map);
    }

    void unpickle81_imgBody(PickleContext pickleContext, ARRAY aRRAY, long l, int n, int n2, Map map) throws SQLException {
        boolean bl;
        pickleContext.readByte_pctx();
        int n3 = pickleContext.readLength_pctx();
        aRRAY.setLength(n3);
        if (n2 == 0) {
            return;
        }
        int n4 = (int)this.getAccessLength(n3, l, n);
        boolean bl2 = bl = ArrayDescriptor.getCacheStyle(aRRAY) == 1;
        if (l > 1L && n4 > 0) {
            long l2 = aRRAY.getLastIndex();
            if (l2 < l) {
                if (l2 > 0L) {
                    pickleContext.skip_to(aRRAY.getLastOffset());
                } else {
                    l2 = 1L;
                }
                if (bl) {
                    long l3 = l2;
                    while (l3 < l) {
                        aRRAY.setIndexOffset(l3, pickleContext.offset());
                        this.m_elemType.unpickle81rec(pickleContext, 9, null);
                        ++l3;
                    }
                } else {
                    long l4 = l2;
                    while (l4 < l) {
                        this.m_elemType.unpickle81rec(pickleContext, 9, null);
                        ++l4;
                    }
                }
            } else if (l2 > l) {
                long l5 = aRRAY.getOffset(l);
                if (l5 != -1L) {
                    pickleContext.skip_to(l5);
                } else if (bl) {
                    int n5 = 1;
                    while ((long)n5 < l) {
                        aRRAY.setIndexOffset(n5, pickleContext.offset());
                        this.m_elemType.unpickle81rec(pickleContext, 9, null);
                        ++n5;
                    }
                } else {
                    int n6 = 1;
                    while ((long)n6 < l) {
                        this.m_elemType.unpickle81rec(pickleContext, 9, null);
                        ++n6;
                    }
                }
            } else {
                pickleContext.skip_to(aRRAY.getLastOffset());
            }
            aRRAY.setLastIndexOffset(l, pickleContext.offset());
        }
        this.unpickle81_imgBody_elems(pickleContext, aRRAY, (int)l, n4, n2, map);
    }

    private void unpickle81_imgBody_elems(PickleContext pickleContext, ARRAY aRRAY, int n, int n2, int n3, Map map) throws SQLException {
        boolean bl = ArrayDescriptor.getCacheStyle(aRRAY) == 1;
        switch (n3) {
            case 1: {
                Datum[] datumArray = new Datum[n2];
                if (bl) {
                    int n4 = 0;
                    while (n4 < n2) {
                        aRRAY.setIndexOffset(n + n4, pickleContext.offset());
                        datumArray[n4] = (Datum)this.m_elemType.unpickle81rec(pickleContext, n3, map);
                        ++n4;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < n2) {
                        datumArray[n5] = (Datum)this.m_elemType.unpickle81rec(pickleContext, n3, map);
                        ++n5;
                    }
                }
                aRRAY.setDatumArray(datumArray);
                break;
            }
            case 2: {
                Object[] objectArray = ArrayDescriptor.makeJavaArray(n2, this.m_elemType.getTypeCode());
                if (bl) {
                    int n6 = 0;
                    while (n6 < n2) {
                        aRRAY.setIndexOffset(n + n6, pickleContext.offset());
                        objectArray[n6] = this.m_elemType.unpickle81rec(pickleContext, n3, map);
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (n7 < n2) {
                        objectArray[n7] = this.m_elemType.unpickle81rec(pickleContext, n3, map);
                        ++n7;
                    }
                }
                aRRAY.setObjArray(objectArray);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.m_elemType instanceof OracleTypeNUMBER || this.m_elemType instanceof OracleTypeFLOAT) {
                    aRRAY.setObjArray(OracleTypeNUMBER.unpickle81_nativeArray(pickleContext, 1L, n2, n3));
                    break;
                }
                DBError.throwSqlException(23, "This feature is limited to numeric collection");
                break;
            }
            default: {
                DBError.throwSqlException(68, "Invalid conversion type " + this.m_elemType);
            }
        }
        aRRAY.setLastIndexOffset(n + n2, pickleContext.offset());
    }

    boolean unpickle81_imgHeader(PickleContext pickleContext, ARRAY aRRAY, int n, int n2) throws SQLException {
        byte by;
        boolean bl = true;
        if (n == 3) {
            aRRAY.setImage(pickleContext.image(), pickleContext.absolute_offset(), 0L);
        }
        if (!PickleContext.is81format_pctx(by = pickleContext.readByte_pctx())) {
            DBError.throwSqlException(1, "Image is not in 8.1 format");
        }
        if (!PickleContext.hasPrefix_pctx(by)) {
            DBError.throwSqlException(1, "Image has no prefix segment");
        }
        if (PickleContext.isCollectionImage_pctx(by)) {
            bl = true;
        } else if (PickleContext.isDegenerateImage_pctx(by)) {
            bl = false;
        } else {
            DBError.throwSqlException(1, "Image is not a collection image");
        }
        pickleContext.readByte_pctx();
        if (n == 9) {
            pickleContext.skip_bytes(pickleContext.readLength_pctx(true) - 2);
            return false;
        }
        if (n == 3) {
            long l = pickleContext.readLength_pctx();
            aRRAY.setImageLength(l);
            pickleContext.skip_to(aRRAY.getImageOffset() + l);
            return false;
        }
        pickleContext.skipLength_pctx();
        int n3 = pickleContext.readLength_pctx();
        byte by2 = pickleContext.readByte_pctx();
        aRRAY.setLocator(pickleContext.readDataValue_pctx(n3 - 1));
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeCOLLECTION::writeObject");
        }
        objectOutputStream.writeInt(this.m_userCode);
        objectOutputStream.writeLong(this.m_maxSize);
        objectOutputStream.writeObject(this.m_elemType);
    }
}

