/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.lang.PackageProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;

public class Tag {
    private static final String NAME = "Tag";
    private static final boolean IN = true;
    private static final boolean OUT = false;
    private static final boolean DEBUG = false;
    private static final int debuglevel = 0;
    private static final PrintWriter err = null;
    private static final boolean TRACE = PackageProperties.isTraceable("Tag");
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 64;
    public static final int CONTEXT = 128;
    public static final int PRIVATE = 192;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int SEQUENCE = 16;
    public static final int SEQUENCE_OF = 48;
    public static final int SET = 17;
    public static final int SET_OF = 49;
    public static final int PRINT_STRING = 19;
    public static final int T61_STRING = 20;
    public static final int IA5_STRING = 22;
    public static final int UTC_TIME = 23;
    public static final int UTF8_STRING = 12;
    int clazz;
    int value;
    boolean explicit;
    boolean constructed;

    private static void debug(String s) {
        err.println(">>> Tag: " + s);
    }

    private static void trace(boolean in, String s) {
        if (TRACE) {
            err.println((in ? "==> " : "<== ") + NAME + "." + s);
        }
    }

    private static void trace(String s) {
        if (TRACE) {
            err.println("<=> Tag." + s);
        }
    }

    Tag(int clazz, int value, boolean explicit, boolean constructed) {
        this.clazz = clazz;
        this.value = value;
        this.explicit = explicit;
        this.constructed = constructed;
    }

    Tag(int clazz, int value, boolean explicit) {
        this(clazz, value, explicit, false);
    }

    Tag(int value, boolean explicit) {
        this(0, value, explicit);
    }

    public int getClazz() {
        return this.clazz;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Tag getExpectedTag(int expectedClass, int expectedValue, InputStream in) throws IOException {
        int tagValue;
        int tagClass;
        ByteArrayOutputStream recovery;
        Tag result;
        block14: {
            Tag tag;
            block13: {
                Tag tag2;
                block12: {
                    result = null;
                    recovery = new ByteArrayOutputStream();
                    tagClass = -1;
                    tagValue = -1;
                    try {
                        int c = in.read();
                        if (c < 0) {
                            tag2 = null;
                            Object var13_9 = null;
                            break block12;
                        }
                        recovery.write(c &= 0xFF);
                        tagClass = c & 0xC0;
                        boolean tagConstructed = (c & 0x20) != 0;
                        tagValue = c & 0x1F;
                        if (tagValue == 31) {
                            tagValue = 0;
                            c = in.read();
                            if (c < 0) {
                                tag = null;
                                break block13;
                            }
                            c &= 0xFF;
                            do {
                                tagValue += c & 0x80;
                                c = in.read();
                                if (c < 0) {
                                    Tag tag3 = null;
                                    Object var13_11 = null;
                                    if (!Tag.eval(tagClass, expectedClass, tagValue, expectedValue)) {
                                        result = null;
                                        byte[] recovered = recovery.toByteArray();
                                        PushbackInputStream pbis = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, 2048);
                                        pbis.unread(recovered);
                                        in = pbis;
                                    }
                                    recovery = null;
                                    return tag3;
                                }
                                recovery.write(c &= 0xFF);
                            } while ((c & 0x80) != 0);
                        }
                        result = new Tag(tagClass, tagValue, true, tagConstructed);
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        if (!Tag.eval(tagClass, expectedClass, tagValue, expectedValue)) {
                            result = null;
                            byte[] recovered = recovery.toByteArray();
                            PushbackInputStream pbis = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, 2048);
                            pbis.unread(recovered);
                            in = pbis;
                        }
                        recovery = null;
                        throw throwable;
                    }
                }
                if (!Tag.eval(tagClass, expectedClass, tagValue, expectedValue)) {
                    result = null;
                    byte[] recovered = recovery.toByteArray();
                    PushbackInputStream pbis = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, 2048);
                    pbis.unread(recovered);
                    in = pbis;
                }
                recovery = null;
                return tag2;
            }
            Object var13_10 = null;
            if (!Tag.eval(tagClass, expectedClass, tagValue, expectedValue)) {
                result = null;
                byte[] recovered = recovery.toByteArray();
                PushbackInputStream pbis = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, 2048);
                pbis.unread(recovered);
                in = pbis;
            }
            recovery = null;
            return tag;
        }
        Object var13_12 = null;
        if (!Tag.eval(tagClass, expectedClass, tagValue, expectedValue)) {
            result = null;
            byte[] recovered = recovery.toByteArray();
            PushbackInputStream pbis = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, 2048);
            pbis.unread(recovered);
            in = pbis;
        }
        recovery = null;
        return result;
    }

    public static Tag getExpectedTag(int expectedValue, InputStream in) throws IOException {
        return Tag.getExpectedTag(0, expectedValue, in);
    }

    public static Tag getExpectedTag(Tag tag, InputStream in) throws IOException {
        return Tag.getExpectedTag(tag.getClazz(), tag.getValue(), in);
    }

    public static byte[] getTag(InputStream in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int c = in.read();
        if (c == -1) {
            return null;
        }
        bos.write(c &= 0xFF);
        if ((c & 0x1F) == 31) {
            do {
                c = in.read() & 0xFF;
                bos.write(c);
            } while ((c & 0x80) != 0);
        }
        return bos.toByteArray();
    }

    public static Tag decode(InputStream in) throws IOException {
        int c = in.read() & 0xFF;
        int tagClass = c & 0xC0;
        boolean tagConstructed = (c & 0x20) != 0;
        int tagNumber = c & 0x1F;
        if (tagNumber == 31) {
            tagNumber = 0;
            c = in.read() & 0xFF;
            do {
                tagNumber += c & 0x80;
            } while (((c = in.read() & 0xFF) & 0x80) != 0);
        }
        Tag result = new Tag(tagClass, tagNumber, true, tagConstructed);
        return result;
    }

    public static Tag peek(InputStream in) throws IOException {
        in.mark(Integer.MAX_VALUE);
        Tag result = null;
        try {
            result = Tag.decode(in);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            in.reset();
            throw throwable;
        }
        in.reset();
        return result;
    }

    private static boolean eval(int tagClass, int expectedClass, int tagValue, int expectedValue) {
        if (tagClass != expectedClass) {
            return false;
        }
        if (tagClass != 0) {
            return tagValue == expectedValue;
        }
        if (expectedValue == 19 || expectedValue == 22 || tagValue == 20) {
            return tagValue == 19 || tagValue == 22 || tagValue == 20;
        }
        return tagValue == expectedValue;
    }

    public String toString() {
        String result = "<Tag class=\"";
        switch (this.clazz) {
            case 0: {
                result = result + "UNIVERSAL (0)";
                break;
            }
            case 64: {
                result = result + "APPLICATION (64)";
                break;
            }
            case 128: {
                result = result + "CONTEXT (128)";
                break;
            }
            case 192: {
                result = result + "PRIVATE (192)";
                break;
            }
            default: {
                result = result + "" + this.clazz;
            }
        }
        result = result + "\" value=\"";
        if (this.clazz == 128) {
            result = result + "" + this.value;
        } else {
            switch (this.value) {
                case 1: {
                    result = result + "BOOLEAN (1)";
                    break;
                }
                case 2: {
                    result = result + "INTEGER (2)";
                    break;
                }
                case 3: {
                    result = result + "BIT STRING (3)";
                    break;
                }
                case 4: {
                    result = result + "OCTET STRING (4)";
                    break;
                }
                case 5: {
                    result = result + "NULL (5)";
                    break;
                }
                case 6: {
                    result = result + "OBJECT_IDENTIFIER (6)";
                    break;
                }
                case 16: {
                    result = result + "SEQUENCE (16)";
                    break;
                }
                case 17: {
                    result = result + "SET (17)";
                    break;
                }
                case 19: {
                    result = result + "PrintableString (19)";
                    break;
                }
                case 20: {
                    result = result + "T61String (20)";
                    break;
                }
                case 22: {
                    result = result + "IA5String (22)";
                    break;
                }
                case 23: {
                    result = result + "UTCTime (23)";
                    break;
                }
                default: {
                    result = result + "" + this.value;
                }
            }
        }
        result = result + "\" explicit=\"" + (this.explicit ? "yes" : "no");
        result = result + "\" constructed=\"" + (this.constructed ? "yes" : "no") + "\" />";
        return result;
    }
}

