/*
 * Decompiled with CFR 0.152.
 */
package dbutils;

import dbutils.GenUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ColumnTypeChanger {
    boolean TEST = false;

    public void changeColumnType(Connection con, String schema, String tableName, String columnName, String columnType) throws SQLException {
        List colInfos = this.getColumnInfos(con, tableName);
        boolean foundColumn = false;
        StringBuffer buf = new StringBuffer(1000);
        buf.append("create table t_backup (");
        Iterator iter = colInfos.iterator();
        while (iter.hasNext()) {
            ColumnInfo ci = (ColumnInfo)iter.next();
            if (columnName.equalsIgnoreCase(ci.name)) {
                foundColumn = true;
            }
            buf.append(ci.name).append(" ").append(ci.dataType);
            if (ci.dataType.equalsIgnoreCase("float") || ci.dataType.equalsIgnoreCase("float")) {
                buf.append('(').append(ci.precision).append(',').append(ci.scale).append(")");
            } else if (ci.dataType.equalsIgnoreCase("varchar2") || ci.dataType.equalsIgnoreCase("char")) {
                buf.append('(').append(ci.dataLength).append(')');
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        if (!foundColumn) {
            System.err.println("The column " + columnName + " is not found in " + tableName);
            return;
        }
        System.out.println(buf.toString());
        String createTableSQL = buf.toString();
        buf = new StringBuffer(1000);
        buf.append("insert into t_backup select ");
        Iterator iter2 = colInfos.iterator();
        while (iter2.hasNext()) {
            ColumnInfo ci = (ColumnInfo)iter2.next();
            buf.append(ci.name);
            if (!iter2.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(" from ").append(tableName);
        System.out.println(buf.toString());
        Map fkMap = this.getForeignKeys(con, schema.toUpperCase(), tableName.toUpperCase());
        this.writeForeignKeys(fkMap, System.getProperty("user.home") + File.separator + tableName + "fk.sql");
        Iterator iter3 = fkMap.values().iterator();
        while (iter3.hasNext()) {
            ForeignKey fk = (ForeignKey)iter3.next();
            String sql = fk.toDropForeignKey();
            this.executeSQL(con, sql);
        }
        if (this.TEST) {
            return;
        }
        boolean autoCommit = con.getAutoCommit();
        con.setAutoCommit(false);
        try {
            try {
                this.executeSQL(con, createTableSQL);
                this.executeSQL(con, buf.toString());
                this.executeSQL(con, "delete from " + tableName);
                this.executeSQL(con, "alter table " + tableName + " modify ( " + columnName + " " + columnType + ")");
                this.copyRows(con, tableName, colInfos);
                if (!this.areAllRowsSame(con, tableName)) {
                    throw new SQLException("Table data differ from the backup data! The t_backup is not dropped!");
                }
                this.executeSQL(con, "drop table t_backup");
                con.commit();
            }
            catch (SQLException x) {
                con.rollback();
                throw x;
            }
            Object var17_18 = null;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            con.setAutoCommit(true);
            throw throwable;
        }
        con.setAutoCommit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeForeignKeys(Map fkMap, String filename) {
        BufferedWriter out = null;
        String newFilename = GenUtils.getUniqueFile(filename);
        File f = new File(filename);
        f.renameTo(new File(newFilename));
        out = new BufferedWriter(new FileWriter(filename));
        Iterator iter = fkMap.values().iterator();
        while (iter.hasNext()) {
            ForeignKey fk = (ForeignKey)iter.next();
            String sql = fk.toForeignKey();
            out.write(sql);
            out.newLine();
        }
        out.newLine();
        Iterator iter2 = fkMap.values().iterator();
        while (iter2.hasNext()) {
            ForeignKey fk = (ForeignKey)iter2.next();
            String sql = fk.toDropForeignKey();
            out.write(sql);
            out.newLine();
        }
        Object var11_11 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception x2) {}
        return;
        {
            catch (Exception x) {
                x.printStackTrace();
                Object var11_12 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception x2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception x2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean areAllRowsSame(Connection con, String tableName) throws SQLException {
        List backupRows = this.getAllRows(con, "t_backup");
        List rows = this.getAllRows(con, tableName);
        if (backupRows.size() != rows.size()) {
            return false;
        }
        Iterator it = rows.iterator();
        Iterator iter = backupRows.iterator();
        while (iter.hasNext()) {
            Object[] backupRow = (Object[])iter.next();
            Object[] row = (Object[])it.next();
            int i = 0;
            while (i < backupRow.length) {
                if (!backupRow[i].toString().equals(row[i].toString())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List getAllRows(Connection con, String tableName) throws SQLException {
        LinkedList<Object[]> rows = new LinkedList<Object[]>();
        Statement st = null;
        try {
            st = con.createStatement();
            StringBuffer buf = new StringBuffer(128);
            buf.append("select * from ").append(tableName);
            ResultSet rs = st.executeQuery(buf.toString());
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                Object[] row = new Object[rsmd.getColumnCount()];
                int i = 0;
                while (i < rsmd.getColumnCount()) {
                    row[i] = rs.getObject(i + 1);
                    ++i;
                }
                rows.add(row);
            }
            Object var11_10 = null;
            if (st == null) return rows;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (st == null) throw throwable;
            try {
                st.close();
                throw throwable;
            }
            catch (Exception x) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            st.close();
            return rows;
        }
        catch (Exception x) {}
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void copyRows(Connection con, String tableName, List colInfos) throws SQLException {
        buf = new StringBuffer(1000);
        buf.append("select ");
        iter = colInfos.iterator();
        while (iter.hasNext()) {
            ci = (ColumnInfo)iter.next();
            buf.append(ci.name);
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(" from t_backup");
        query = buf.toString();
        buf = new StringBuffer(1000);
        buf.append("insert into ").append(tableName).append(" (");
        iter = colInfos.iterator();
        while (iter.hasNext()) {
            ci = (ColumnInfo)iter.next();
            buf.append(ci.name);
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(") values(");
        iter = colInfos.iterator();
        while (iter.hasNext()) {
            ci = (ColumnInfo)iter.next();
            buf.append('?');
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        insertSql = buf.toString();
        System.out.println("query=" + query);
        System.out.println("insertSql =" + insertSql);
        rows = new LinkedList<Object[]>();
        st = null;
        rs = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery(query);
            while (rs.next()) {
                row = new Object[colInfos.size()];
                i = 0;
                while (i < row.length) {
                    row[i] = rs.getObject(i + 1);
                    ++i;
                }
                rows.add(row);
            }
            var16_16 = null;
            ** if (st == null) goto lbl-1000
        }
        catch (Throwable var15_21) {
            var16_17 = null;
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            throw var15_21;
        }
lbl-1000:
        // 1 sources

        {
            try {
                st.close();
            }
            catch (Exception x) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        pst = null;
        try {
            pst = con.prepareStatement(insertSql);
            iter = rows.iterator();
            while (iter.hasNext()) {
                row = (Object[])iter.next();
                pst.clearParameters();
                i = 0;
                while (i < row.length) {
                    if (row[i] != null) {
                        pst.setObject(i + 1, row[i]);
                    } else {
                        pst.setNull(i + 1, 12);
                    }
                    ++i;
                }
                pst.execute();
            }
            var19_23 = null;
            ** if (pst == null) goto lbl-1000
        }
        catch (Throwable var18_27) {
            var19_24 = null;
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            throw var18_27;
        }
lbl-1000:
        // 1 sources

        {
            try {
                pst.close();
            }
            catch (Exception x) {}
        }
lbl-1000:
        // 2 sources

        {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSQL(Connection con, String sql) throws SQLException {
        Statement st = null;
        try {
            st = con.createStatement();
            st.execute(sql);
            Object var5_4 = null;
            if (st == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (st == null) throw throwable;
            try {
                st.close();
                throw throwable;
            }
            catch (Exception x) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            st.close();
            return;
        }
        catch (Exception x) {}
    }

    public Map getForeignKeys(Connection con, String schema, String tableName) throws SQLException {
        ForeignKey fk;
        short keySeq;
        String fkName;
        String pkName;
        short deleteRule;
        String fkColumn;
        String fkTable;
        String pkTable;
        String pkColumn;
        DatabaseMetaData md = con.getMetaData();
        ResultSet rs = md.getExportedKeys(null, schema, tableName);
        LinkedHashMap<String, ForeignKey> fkMap = new LinkedHashMap<String, ForeignKey>();
        while (rs.next()) {
            pkColumn = rs.getObject(4).toString();
            pkTable = rs.getObject(3).toString();
            fkTable = rs.getObject(7).toString();
            fkColumn = rs.getObject(8).toString();
            deleteRule = rs.getShort(11);
            pkName = rs.getString(13);
            fkName = rs.getString(12);
            keySeq = rs.getShort(9);
            fk = (ForeignKey)fkMap.get(pkTable + fkTable);
            if (fk == null) {
                fk = new ForeignKey(fkName, pkName, pkTable, fkTable, 10, deleteRule);
                fkMap.put(pkTable + fkTable, fk);
            }
            fk.addFkColumn(fkColumn, keySeq - 1);
            fk.addPkColumn(pkColumn, keySeq - 1);
        }
        System.out.println("imported keys");
        rs = md.getImportedKeys(null, schema, tableName);
        while (rs.next()) {
            pkColumn = rs.getObject(4).toString();
            pkTable = rs.getObject(3).toString();
            fkTable = rs.getObject(7).toString();
            fkColumn = rs.getObject(8).toString();
            deleteRule = rs.getShort(11);
            pkName = rs.getString(13);
            fkName = rs.getString(12);
            keySeq = rs.getShort(9);
            fk = (ForeignKey)fkMap.get(pkTable + fkTable);
            if (fk == null) {
                fk = new ForeignKey(fkName, pkName, pkTable, fkTable, 10, deleteRule);
                fkMap.put(pkTable + fkTable, fk);
            }
            fk.addFkColumn(fkColumn, keySeq - 1);
            fk.addPkColumn(pkColumn, keySeq - 1);
        }
        Iterator iter = fkMap.values().iterator();
        while (iter.hasNext()) {
            ForeignKey fk2 = (ForeignKey)iter.next();
            System.out.println(fk2.toForeignKey());
        }
        return fkMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getColumnInfos(Connection con, String tableName) throws SQLException {
        String sql = "select  column_name, data_type, data_length, nullable,data_precision, data_scale from user_tab_cols where table_name='";
        sql = sql + tableName.toUpperCase() + "'";
        LinkedList<ColumnInfo> colInfos = new LinkedList<ColumnInfo>();
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery(sql);
            while (rs.next()) {
                ColumnInfo ci = new ColumnInfo();
                ci.name = rs.getString(1);
                ci.dataType = rs.getString(2);
                ci.dataLength = rs.getInt(3);
                ci.nullable = rs.getString(4).equalsIgnoreCase("y");
                ci.precision = rs.getInt(5);
                ci.scale = rs.getInt(6);
                colInfos.add(ci);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception x) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception x) {}
            }
        }
        return colInfos;
    }

    public void changeColumnTypes(Connection con, String schema, Properties props) throws SQLException {
        int idx = 1;
        boolean finished = false;
        while (!finished) {
            String columnTypePropName;
            String colType;
            String columNamePropName;
            String columnName;
            String tableNamePropName = "table" + idx + ".name";
            String tableName = props.getProperty(tableNamePropName);
            if (tableName == null || (columnName = props.getProperty(columNamePropName = "table" + idx + ".column")) == null || (colType = props.getProperty(columnTypePropName = "table" + idx + ".columntype")) == null) break;
            System.out.println("changing column " + columnName + " for table " + tableName + "...");
            this.changeColumnType(con, schema.toUpperCase(), tableName, columnName, colType);
            ++idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        Connection con = null;
        Properties props = GenUtils.loadProperties("dbutils.properties");
        String dbURL = props.getProperty("dburl");
        String user = props.getProperty("user");
        String pwd = props.getProperty("pwd");
        Class.forName("oracle.jdbc.driver.OracleDriver");
        con = DriverManager.getConnection(dbURL, user, pwd);
        ColumnTypeChanger ct = new ColumnTypeChanger();
        ct.changeColumnTypes(con, user, props);
        Object var8_8 = null;
        if (con == null) return;
        try {
            con.close();
            return;
        }
        catch (Exception x2) {}
        return;
        {
            catch (Exception x) {
                x.printStackTrace();
                Object var8_9 = null;
                if (con == null) return;
                try {
                    con.close();
                    return;
                }
                catch (Exception x2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (con == null) throw throwable;
            try {
                con.close();
                throw throwable;
            }
            catch (Exception x2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    class ForeignKey {
        String name;
        String pkName;
        String pkTable;
        String fkTable;
        String[] pkColumns;
        String[] fkColumns;
        int deleteRule;
        String updateRule;
        int colCount = 0;

        public ForeignKey(String fkName, String pkName, String pkTable, String fkTable, int maxCols, int deleteRule) {
            this.name = fkName;
            this.pkName = pkName;
            this.pkTable = pkTable;
            this.fkTable = fkTable;
            this.pkColumns = new String[maxCols];
            this.fkColumns = new String[maxCols];
            this.deleteRule = deleteRule;
        }

        public void addPkColumn(String colName, int idx) {
            this.pkColumns[idx] = colName;
        }

        public void addFkColumn(String colName, int idx) {
            this.fkColumns[idx] = colName;
        }

        public int getColumnCount() {
            int i = 0;
            while (i < this.fkColumns.length) {
                if (this.fkColumns[i] == null) {
                    return i;
                }
                ++i;
            }
            return this.fkColumns.length;
        }

        public String toForeignKey() {
            this.colCount = this.getColumnCount();
            StringBuffer buf = new StringBuffer(256);
            buf.append("alter table ").append(this.fkTable).append(" add constraint ").append(this.name);
            buf.append(" foreign key (");
            int i = 0;
            while (i < this.colCount) {
                buf.append(this.fkColumns[i]);
                if (i + 1 < this.colCount) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(") references ").append(this.pkTable).append('(');
            int i2 = 0;
            while (i2 < this.colCount) {
                buf.append(this.pkColumns[i2]);
                if (i2 + 1 < this.colCount) {
                    buf.append(',');
                }
                ++i2;
            }
            buf.append(")");
            return buf.toString();
        }

        public String toDropForeignKey() {
            StringBuffer buf = new StringBuffer(256);
            buf.append("alter table ").append(this.fkTable).append(" drop constraint ").append(this.name);
            return buf.toString();
        }
    }

    class ColumnInfo {
        String name;
        String dataType;
        int dataLength;
        boolean nullable;
        int precision;
        int scale;

        ColumnInfo() {
        }
    }
}

