/*
 * Decompiled with CFR 0.152.
 */
package dbutils;

import dbutils.DBTable;
import dbutils.GenUtils;
import dbutils.SchemaExtractor;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Properties;
import oracle.sql.CLOB;
import oracle.sql.TIMESTAMP;

public class DBExporter {
    protected Connection con;
    private String usr;
    private String pwd;
    private String dbURL;

    public DBExporter(String propertiesFile) throws Exception {
        Properties props = GenUtils.loadProperties(propertiesFile);
        this.usr = props.getProperty("user");
        this.pwd = props.getProperty("pwd");
        this.dbURL = props.getProperty("dburl");
        this.con = this.connect(this.dbURL, this.usr, this.pwd);
        System.out.println("connected to " + this.dbURL);
    }

    /*
     * WARNING - void declaration
     */
    public static String readCLOB(CLOB clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(128);
        Reader r = clob.characterStreamValue();
        try {
            int c;
            while ((c = r.read()) != -1) {
                void var3_3;
                buf.append((char)var3_3);
            }
        }
        catch (IOException iox) {
            throw new SQLException(iox.getMessage());
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractTables() throws Exception {
        SchemaExtractor se = null;
        try {
            se = new SchemaExtractor(this.con);
            se.loadDBTables(this.usr.toUpperCase());
            Iterator iter = se.getTables();
            while (iter.hasNext()) {
                DBTable table = (DBTable)iter.next();
                if (!table.getName().toLowerCase().startsWith("nc_")) continue;
                System.out.println("-- processing table " + table.getName());
                System.out.println("-- ");
                this.extractData(table);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    protected Connection connect(String dbURL, String usr, String pwd) throws Exception {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        return DriverManager.getConnection(dbURL, usr, pwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void extractData(DBTable table) throws SQLException {
        StringBuffer buf = new StringBuffer(512);
        buf.append("select * from ").append(table.getName());
        Statement st = null;
        try {
            st = this.con.createStatement();
            System.err.println(buf.toString());
            ResultSet rs = st.executeQuery(buf.toString());
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            while (rs.next()) {
                StringBuffer ibuf = new StringBuffer(512);
                ibuf.append("insert into ").append(table.getName()).append(" (");
                int i = 1;
                while (i <= colCount) {
                    ibuf.append(rsmd.getColumnLabel(i));
                    if (i != colCount) {
                        ibuf.append(',');
                    }
                    ++i;
                }
                ibuf.append(") values(");
                int i2 = 1;
                while (i2 <= colCount) {
                    Object colValue = rs.getObject(i2);
                    if (colValue == null) {
                        ibuf.append("NULL");
                    } else if (colValue instanceof CLOB) {
                        ibuf.append("'").append(DBExporter.readCLOB((CLOB)colValue)).append("'");
                    } else {
                        switch (rsmd.getColumnType(i2)) {
                            case 1: 
                            case 12: 
                            case 91: 
                            case 93: {
                                ibuf.append("'").append(colValue).append("'");
                                break;
                            }
                            default: {
                                if (colValue instanceof TIMESTAMP) {
                                    TIMESTAMP tstamp = (TIMESTAMP)colValue;
                                    ibuf.append("'").append(tstamp.timestampValue()).append("'");
                                    break;
                                }
                                ibuf.append(colValue);
                            }
                        }
                    }
                    if (i2 != colCount) {
                        ibuf.append(',');
                    }
                    ++i2;
                }
                ibuf.append(");");
                System.out.println(ibuf.toString());
            }
            Object var13_12 = null;
            if (st == null) return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (st == null) throw throwable;
            try {
                st.close();
                throw throwable;
            }
            catch (Exception x) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            st.close();
            return;
        }
        catch (Exception x) {}
    }

    public void shutdown() {
        block2: {
            if (this.con == null) break block2;
            try {
                this.con.close();
            }
            catch (Exception x) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        DBExporter dbe = null;
        try {
            try {
                dbe = new DBExporter("dbutils.properties");
                dbe.extractTables();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Object var4_3 = null;
                if (dbe != null) {
                    dbe.shutdown();
                }
            }
            Object var4_2 = null;
            if (dbe != null) {
                dbe.shutdown();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (dbe != null) {
                dbe.shutdown();
            }
            throw throwable;
        }
    }
}

