/*
 * Decompiled with CFR 0.152.
 */
package dbutils;

import dbutils.DBTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

public class DBMetaDataInfo {
    private Hashtable tables = new Hashtable();
    private static DBMetaDataInfo instance;

    private DBMetaDataInfo(Connection con, String schema) throws SQLException {
        this.loadDBSchema(con, schema);
    }

    public Hashtable getTables() {
        return this.tables;
    }

    public Collection getAllTableNames() {
        TreeSet tableNames = new TreeSet(this.tables.keySet());
        return tableNames;
    }

    public void loadDBSchema(Connection con, String schema) throws SQLException {
        DatabaseMetaData md = con.getMetaData();
        ResultSet rs = null;
        String[] tableTypes = new String[]{"TABLE"};
        rs = md.getTables("", schema, "%", tableTypes);
        while (rs.next()) {
            String tableName = rs.getString(3);
            DBTable table = new DBTable(con, tableName, schema);
            this.tables.put(tableName, table);
            System.out.println(">> " + tableName);
        }
    }

    private void showDBInfo(Connection con) throws SQLException {
        DatabaseMetaData md = con.getMetaData();
        ResultSet rs = md.getCatalogs();
        System.out.println(" Catalogs\n==============");
        while (rs.next()) {
            System.out.println(rs.getObject(1));
        }
        rs.close();
        rs = md.getSchemas();
        System.out.println(" Schemas\n==============");
        while (rs.next()) {
            System.out.println(rs.getObject(1));
        }
        rs.close();
    }

    public static synchronized DBMetaDataInfo getInstance(Connection con, String schema) throws SQLException {
        if (instance == null) {
            instance = new DBMetaDataInfo(con, schema);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        Connection con = null;
        String driverName = "oracle.jdbc.driver.OracleDriver";
        String url = "jdbc:oracle:thin:@fmri-gpop:1521:orcl1";
        String user = "bozyurt";
        String password = "bozyurt";
        Class.forName(driverName);
        con = DriverManager.getConnection(url, user, password);
        DBMetaDataInfo mdi = DBMetaDataInfo.getInstance(con, "ORCL1");
        Collection col = mdi.getAllTableNames();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            System.out.println(">> " + it.next());
        }
        Object var10_10 = null;
        if (con == null) return;
        try {
            con.close();
            return;
        }
        catch (Exception x2) {}
        return;
        {
            catch (Exception x) {
                x.printStackTrace();
                Object var10_11 = null;
                if (con == null) return;
                try {
                    con.close();
                    return;
                }
                catch (Exception x2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (con == null) throw throwable;
            try {
                con.close();
                throw throwable;
            }
            catch (Exception x2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

