/*
 * Decompiled with CFR 0.152.
 */
package dbutils;

import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DBTable {
    private String name;
    private List columns = new LinkedList();
    private boolean sorted = false;
    private static final SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yy");

    public DBTable(Connection con, String tableName, String schema) throws SQLException {
        this.extractTableInfo(con, tableName, schema);
        this.name = tableName;
    }

    public String getName() {
        return this.name;
    }

    public void extractTableInfo(Connection con, String tableName, String schema) throws SQLException {
        DatabaseMetaData md = con.getMetaData();
        ResultSet rs = md.getColumns("", schema, tableName, "%");
        while (rs.next()) {
            String nullYN = rs.getString(18);
            DBColumn col = new DBColumn(rs.getString(4), rs.getString(6), rs.getInt(7), rs.getInt(9), rs.getInt(17), nullYN.equals("NO"));
            this.columns.add(col);
        }
        rs.close();
        this.getPrimaryKeys(con, tableName, schema);
    }

    public String[] getColumnNames() {
        String[] colNames = new String[this.columns.size()];
        Iterator it = this.columns.iterator();
        int count = 0;
        while (it.hasNext()) {
            DBColumn col = (DBColumn)it.next();
            colNames[count++] = col.name;
        }
        return colNames;
    }

    private void getPrimaryKeys(Connection con, String tableName, String schema) throws SQLException {
        DatabaseMetaData md = con.getMetaData();
        ResultSet rs = md.getPrimaryKeys("", schema, tableName);
        block0: while (rs.next()) {
            String pkName = rs.getString(4);
            Iterator it = this.columns.iterator();
            while (it.hasNext()) {
                DBColumn col = (DBColumn)it.next();
                if (!col.name.equals(pkName)) continue;
                col.primaryKey = true;
                col.primaryKeyOrder = rs.getInt(5);
                continue block0;
            }
        }
        rs.close();
    }

    public String getPrimaryKeyDDL() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("ALTER TABLE ").append(this.name).append(" ADD (PRIMARY KEY (");
        Iterator it = this.columns.iterator();
        int[] idxs = this.getPrimaryKeyIndices();
        if (idxs == null) {
            return null;
        }
        int i = 0;
        while (i < idxs.length) {
            DBColumn col = (DBColumn)this.columns.get(idxs[i]);
            buf.append(col.name);
            if (i < idxs.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        buf.append(") );\n");
        return buf.toString();
    }

    public List getPrimaryKeyColumns() {
        int[] idxs = this.getPrimaryKeyIndices();
        if (idxs == null) {
            return null;
        }
        LinkedList<DBColumn> pkCols = new LinkedList<DBColumn>();
        int i = 0;
        while (i < idxs.length) {
            DBColumn col = (DBColumn)this.columns.get(idxs[i]);
            pkCols.add(col);
            ++i;
        }
        return pkCols;
    }

    private int[] getPrimaryKeyIndices() {
        ArrayList<Integer> idxs = new ArrayList<Integer>(10);
        Iterator it = this.columns.iterator();
        boolean flag = false;
        while (it.hasNext()) {
            DBColumn col = (DBColumn)it.next();
            if (!col.primaryKey) continue;
            flag = true;
            idxs.add(new Integer(col.primaryKeyOrder - 1));
        }
        if (idxs.isEmpty()) {
            return null;
        }
        int[] is = new int[idxs.size()];
        it = idxs.iterator();
        int i = 0;
        while (it.hasNext()) {
            is[i++] = (Integer)it.next();
        }
        return is;
    }

    public List getColumns() {
        return this.columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractData(Connection con, int noRows, Writer w) {
        ResultSet rs = null;
        Statement st = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery("SELECT * from " + this.name);
            int count = 0;
            while (rs.next()) {
                if (noRows > 0 && ++count > noRows) {
                    break;
                }
                ResultSetMetaData rsmd = rs.getMetaData();
                int colCount = rsmd.getColumnCount();
                StringBuffer buf = new StringBuffer(256);
                buf.append("INSERT INTO ").append(this.name).append(" VALUES(");
                int i = 0;
                while (i < colCount) {
                    Object o = rs.getObject(i + 1);
                    if (o == null) {
                        buf.append("NULL");
                    } else if (o instanceof String) {
                        buf.append("'").append(DBTable.escapeQuotes(o.toString())).append("'");
                    } else if (o instanceof Timestamp) {
                        Timestamp ts = (Timestamp)o;
                        buf.append('\'').append(df.format(new Date(ts.getTime()))).append('\'');
                    } else {
                        buf.append('\'').append(o.toString()).append('\'');
                    }
                    if (i < colCount - 1) {
                        buf.append(",");
                    }
                    ++i;
                }
                buf.append(");\n");
                w.write(buf.toString());
                w.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception x) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception x) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNoRows(Connection con) {
        ResultSet rs = null;
        Statement st = null;
        int rowCount = 0;
        try {
            st = con.createStatement();
            rs = st.executeQuery("SELECT COUNT(*) from " + this.name);
            boolean count = false;
            if (rs.next()) {
                rowCount = rs.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception x) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception x) {}
            }
        }
        return rowCount;
    }

    public static String escapeQuotes(String s) {
        StringBuffer buf = new StringBuffer(s.length() + 1);
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (c[i] == '\'') {
                buf.append("''");
            } else {
                buf.append(c[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    public void show() {
        StringBuffer buf = new StringBuffer(512);
        buf.append("TABLE=").append(this.name).append("\n\t");
        Iterator it = this.columns.iterator();
        while (it.hasNext()) {
            DBColumn col = (DBColumn)it.next();
            buf.append(col.toDDL());
            buf.append("\n\t");
        }
        buf.append("\n");
        System.out.println(buf.toString());
    }

    public void prepare() {
        this.sortColumns();
    }

    public void showDDL() {
        StringBuffer buf = new StringBuffer(512);
        buf.append("CREATE TABLE ").append(this.name).append(" (\n\t");
        this.sortColumns();
        Iterator it = this.columns.iterator();
        while (it.hasNext()) {
            DBColumn col = (DBColumn)it.next();
            buf.append(col.toDDL());
            if (!it.hasNext()) continue;
            buf.append(",\n\t");
        }
        buf.append(");\n");
        System.out.println(buf.toString());
    }

    private void sortColumns() {
        if (this.sorted) {
            return;
        }
        Object[] colArr = new Object[this.columns.size()];
        Iterator it = this.columns.iterator();
        int i = 0;
        while (it.hasNext()) {
            colArr[i++] = it.next();
        }
        Arrays.sort(colArr, new ColumnComparator());
        this.columns.clear();
        i = 0;
        while (i < colArr.length) {
            this.columns.add(colArr[i]);
            ++i;
        }
        this.sorted = true;
    }

    private class ColumnComparator
    implements Comparator {
        private ColumnComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((DBColumn)o1).order - ((DBColumn)o2).order;
        }
    }

    public static class DBColumn {
        String name;
        String type;
        int width;
        int fracDigit;
        boolean notNullable;
        int order;
        boolean primaryKey = false;
        int primaryKeyOrder;

        public DBColumn(String name, String type, int width, int fracDigit, int order, boolean notNullable) {
            this.name = name;
            this.type = type;
            this.width = width;
            this.fracDigit = fracDigit;
            this.order = order;
            this.notNullable = notNullable;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int getWidth() {
            return this.width;
        }

        public int getFracDigit() {
            return this.fracDigit;
        }

        public boolean getNotNullable() {
            return this.notNullable;
        }

        public int getOrder() {
            return this.order;
        }

        public void setPrimaryKey(boolean value) {
            this.primaryKey = value;
        }

        public void setPrimaryKeyOrder(int value) {
            this.primaryKeyOrder = value;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(128);
            buf.append("[name=").append(this.name).append(",type=").append(this.type);
            buf.append(",width=").append(this.width).append(",frac-dig=").append(this.fracDigit).append(",order=").append(this.order);
            buf.append(",notNullable=").append(this.notNullable).append("]");
            return buf.toString();
        }

        public String toDDL() {
            StringBuffer buf = new StringBuffer(128);
            buf.append(this.name).append("   ").append(this.type);
            if (this.width > 0 && !this.type.equals("DATE")) {
                buf.append("(").append(this.width);
                if (this.fracDigit > 0) {
                    buf.append(",").append(this.fracDigit);
                }
                buf.append(")  ");
            } else {
                buf.append("  ");
            }
            if (this.notNullable) {
                buf.append("NOT NULL");
            }
            return buf.toString();
        }
    }
}

