/*
 * Decompiled with CFR 0.152.
 */
package dbutils;

import dbutils.DBTable;
import dbutils.GenUtils;
import dbutils.SchemaExtractor;
import dbutils.Tokenizer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class InsertStatementFixer {
    Tokenizer tokenizer;
    Map tableClobMap = new HashMap();
    String usr;
    String pwd;
    String dbURL;
    Connection con;
    String currentTablename;

    public InsertStatementFixer(String filename, String propertiesFile) throws Exception {
        this.tokenizer = new Tokenizer(filename);
        Properties props = GenUtils.loadProperties(propertiesFile);
        this.usr = props.getProperty("user");
        this.pwd = props.getProperty("pwd");
        this.dbURL = props.getProperty("dburl");
        this.con = this.connect(this.dbURL, this.usr, this.pwd);
        System.out.println("connected to " + this.dbURL);
    }

    protected Connection connect(String dbURL, String usr, String pwd) throws Exception {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        return DriverManager.getConnection(dbURL, usr, pwd);
    }

    public void shutdown() {
        block3: {
            if (this.tokenizer != null) {
                this.tokenizer.shutdown();
            }
            if (this.con == null) break block3;
            try {
                this.con.close();
            }
            catch (Exception x) {}
        }
    }

    public void parse() throws Exception {
        int tc = -1;
        tc = this.tokenizer.getNextToken();
        while (tc != 100) {
            if (tc == 2) {
                this.parseInsertStatement(tc);
            }
            tc = this.tokenizer.getNextToken();
        }
    }

    public void parseInsertStatement(int tc) throws IOException {
        while (tc != 2) {
            tc = this.tokenizer.getNextToken();
        }
        tc = this.tokenizer.getNextToken();
        tc = this.tokenizer.getNextToken();
        String tableName = this.tokenizer.getStringValue();
        Map colMap = (Map)this.tableClobMap.get(tableName.toLowerCase());
        if (this.currentTablename == null || !this.currentTablename.equals(tableName)) {
            System.out.println("-- " + tableName);
            System.out.println("-- ");
            this.currentTablename = tableName;
        }
        tc = this.tokenizer.getNextToken();
        String[] columnList = null;
        Object[] values = null;
        if (tc == 6) {
            columnList = this.parseColumnList();
        }
        if ((tc = this.tokenizer.getNextToken()) == 4) {
            tc = this.tokenizer.getNextToken();
            values = this.parseValuesList();
        }
        tc = this.tokenizer.getNextToken();
        StringBuffer buf = new StringBuffer(256);
        buf.append("INSERT INTO ").append(tableName).append(" (");
        int i = 0;
        while (i < columnList.length) {
            buf.append(columnList[i]);
            if (i + 1 < columnList.length) {
                buf.append(',');
            }
            ++i;
        }
        buf.append(") VALUES(");
        int i2 = 0;
        while (i2 < values.length) {
            if (colMap != null && colMap.get(columnList[i2]) != null) {
                if (values[i2].equals("NULL")) {
                    buf.append("EMPTY_CLOB()");
                } else {
                    buf.append(values[i2]);
                }
            } else {
                buf.append(values[i2]);
            }
            if (i2 + 1 < values.length) {
                buf.append(',');
            }
            ++i2;
        }
        buf.append(");");
        System.out.println(buf.toString());
    }

    protected int indexOf(String val, String[] list) {
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(val)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected String[] parseColumnList() throws IOException {
        int tc = -1;
        LinkedList<String> colNames = new LinkedList<String>();
        tc = this.tokenizer.getNextToken();
        while (tc != -1 && tc != 7) {
            if (tc == 10) {
                colNames.add(this.tokenizer.getStringValue());
            }
            tc = this.tokenizer.getNextToken();
        }
        String[] columnList = new String[colNames.size()];
        colNames.toArray(columnList);
        return columnList;
    }

    protected Object[] parseValuesList() throws IOException {
        int tc = -1;
        LinkedList<Object> values = new LinkedList<Object>();
        tc = this.tokenizer.getNextToken();
        while (tc != -1 && tc != 7) {
            if (tc == 10) {
                values.add(this.tokenizer.getStringValue());
            } else if (tc == 1) {
                values.add("'" + this.tokenizer.getStringValue() + "'");
            } else if (tc == 6) {
                tc = this.tokenizer.getNextToken();
                values.add("TIMESTAMP '" + this.tokenizer.getStringValue() + "'");
            } else if (tc == 11) {
                values.add(this.tokenizer.getNumber());
            }
            tc = this.tokenizer.getNextToken();
        }
        return values.toArray();
    }

    public void getCLOBColumnInfos() throws Exception {
        DBTable table;
        SchemaExtractor se = null;
        se = new SchemaExtractor(this.con);
        se.loadDBTables(this.usr.toUpperCase());
        Iterator iter = se.getTables();
        while (iter.hasNext()) {
            table = (DBTable)iter.next();
            if (table.getName().toLowerCase().startsWith("nc_")) continue;
            iter.remove();
        }
        iter = se.getTables();
        while (iter.hasNext()) {
            table = (DBTable)iter.next();
            Iterator it = table.getColumns().iterator();
            while (it.hasNext()) {
                DBTable.DBColumn column = (DBTable.DBColumn)it.next();
                if (!column.getType().equalsIgnoreCase("clob")) continue;
                HashMap<String, String> colMap = (HashMap<String, String>)this.tableClobMap.get(table.getName().toLowerCase());
                if (colMap == null) {
                    colMap = new HashMap<String, String>(3);
                    this.tableClobMap.put(table.getName().toLowerCase(), colMap);
                }
                colMap.put(column.getName(), column.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        InsertStatementFixer isf = null;
        String filename = "c:/cygwin/home/bozyurt/bin/mbirn_db.sql";
        try {
            try {
                isf = new InsertStatementFixer(filename, "dbutils.properties");
                isf.getCLOBColumnInfos();
                isf.parse();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Object var5_4 = null;
                if (isf != null) {
                    isf.shutdown();
                }
            }
            Object var5_3 = null;
            if (isf != null) {
                isf.shutdown();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (isf != null) {
                isf.shutdown();
            }
            throw throwable;
        }
    }
}

