/*
 * Decompiled with CFR 0.152.
 */
package dbutils;

import dbutils.DBTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.sql.TIMESTAMP;

public class SchemaExtractor {
    private String usr;
    private Connection con = null;
    private Map tableMap = new HashMap();
    private List views;
    private static final String value = "";
    private static Map sql2javaMap = new HashMap();

    public SchemaExtractor(String dbURL, String usr, String pwd) throws Exception {
        this.con = this.connect(dbURL, usr, pwd);
    }

    public SchemaExtractor(Connection con) throws Exception {
        this.con = con;
    }

    protected Connection connect(String dbURL, String usr, String pwd) throws Exception {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        return DriverManager.getConnection(dbURL, usr, pwd);
    }

    public void shutdown() {
        block2: {
            if (this.con == null) break block2;
            try {
                this.con.close();
            }
            catch (Exception x) {}
        }
    }

    public void loadDBTables(String schema) throws SQLException {
        this.loadDBTables(schema, false);
    }

    public void loadDBTables(String schema, boolean loadViewsAlso) throws SQLException {
        DatabaseMetaData md = this.con.getMetaData();
        ResultSet rs = null;
        String[] tableTypes = new String[]{"TABLE"};
        if (loadViewsAlso) {
            tableTypes = new String[]{"TABLE", "VIEW"};
        }
        rs = md.getTables(value, schema, "%", tableTypes);
        while (rs.next()) {
            String tableName = rs.getString(3);
            DBTable table = new DBTable(this.con, tableName, schema);
            this.tableMap.put(tableName, table);
            table.prepare();
        }
    }

    public DBTable getTable(String tableName) {
        return (DBTable)this.tableMap.get(tableName);
    }

    public Iterator getTables() {
        return this.tableMap.values().iterator();
    }

    public static String getConversionType(DBTable.DBColumn column) {
        if (column.getType().equalsIgnoreCase("number") && column.getWidth() == 1) {
            return "bigdecimal2bool";
        }
        if (column.getType().equalsIgnoreCase("char") && column.getWidth() == 1) {
            return "string2bool";
        }
        if (column.getType().equalsIgnoreCase("clob")) {
            return "clob2string";
        }
        return value;
    }

    public static String toJavaType(DBTable.DBColumn column) {
        String javaType = (String)sql2javaMap.get(column.getType().toLowerCase());
        if (javaType != null) {
            return javaType;
        }
        if (column.getType().toLowerCase().startsWith("timestamp")) {
            return "java.sql.Timestamp";
        }
        if (column.getType().toLowerCase().startsWith("date")) {
            return "java.util.Date";
        }
        if (column.getType().equalsIgnoreCase("number")) {
            if (column.getFracDigit() > 0) {
                return "Double";
            }
            if (column.getWidth() == 1) {
                return "Boolean";
            }
            return "java.math.BigDecimal";
        }
        if (column.getType().equalsIgnoreCase("char")) {
            return column.getWidth() == 1 ? "Boolean" : "String";
        }
        throw new RuntimeException("Not a supported SQL type: " + column.getType() + ", " + column.getName());
    }

    public static void testTimeStamp() throws SQLException {
        TIMESTAMP ots = new TIMESTAMP(new Date(System.currentTimeMillis()));
        Timestamp jts = ots.timestampValue();
        System.out.println("java timestamp " + jts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SchemaExtractor se = null;
        try {
            try {
                se = new SchemaExtractor("jdbc:oracle:thin:@fmri-gpop:1521:orcl1", "ucsd_fmri", value);
            }
            catch (Exception x) {
                x.printStackTrace();
                Object var4_3 = null;
                if (se != null) {
                    se.shutdown();
                }
            }
            Object var4_2 = null;
            if (se != null) {
                se.shutdown();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (se != null) {
                se.shutdown();
            }
            throw throwable;
        }
    }

    static {
        sql2javaMap.put("varchar2", "String");
        sql2javaMap.put("date", "java.util.Date");
        sql2javaMap.put("clob", "String");
        sql2javaMap.put("float", "Double");
    }
}

