/*
 * Decompiled with CFR 0.152.
 */
package dbutils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;

public class Tokenizer {
    StreamTokenizer stok;
    Map keywordMap = new HashMap();
    BufferedReader in = null;
    public static final int STRING = 1;
    public static final int INSERT = 2;
    public static final int INTO = 3;
    public static final int VALUES = 4;
    public static final int NULL_TOK = 5;
    public static final int TIMESTAMP = 6;
    public static final int LEFT_PAR = 6;
    public static final int RIGHT_PAR = 7;
    public static final int SEMICOL = 8;
    public static final int COMMA = 9;
    public static final int WORD = 10;
    public static final int NUMBER = 11;
    public static final int EOF = 100;

    public Tokenizer(String filename) throws IOException {
        this.in = new BufferedReader(new FileReader(filename));
        this.stok = new StreamTokenizer(this.in);
        this.stok.resetSyntax();
        this.stok.parseNumbers();
        this.stok.eolIsSignificant(true);
        this.stok.quoteChar(39);
        this.stok.wordChars(97, 122);
        this.stok.wordChars(65, 90);
        this.stok.wordChars(95, 95);
        this.stok.ordinaryChar(40);
        this.stok.ordinaryChar(41);
        this.stok.ordinaryChar(44);
        this.stok.ordinaryChar(59);
        this.stok.whitespaceChars(32, 32);
        this.stok.whitespaceChars(9, 9);
        this.keywordMap.put("insert", new Integer(2));
        this.keywordMap.put("into", new Integer(3));
        this.keywordMap.put("values", new Integer(4));
        this.keywordMap.put("timestamp", new Integer(6));
    }

    public void shutdown() {
        block2: {
            if (this.in == null) break block2;
            try {
                this.in.close();
            }
            catch (Exception x) {}
        }
    }

    protected int getKeywordCode(String word) {
        Integer code = (Integer)this.keywordMap.get(word.toLowerCase());
        return code != null ? code : -1;
    }

    public String getStringValue() {
        return this.stok.sval;
    }

    protected int getDelimiter(int c) {
        switch (c) {
            case 40: {
                return 6;
            }
            case 41: {
                return 7;
            }
            case 44: {
                return 9;
            }
            case 59: {
                return 8;
            }
        }
        return -1;
    }

    public Number getNumber() {
        Double num = new Double(this.stok.nval);
        double diff = this.stok.nval - (double)num.intValue();
        if (Math.abs(diff) < 1.0E-10) {
            return new Integer(num.intValue());
        }
        return num;
    }

    public int getNextToken() throws IOException {
        int ttype = this.stok.nextToken();
        int tc = -1;
        switch (ttype) {
            case -3: {
                tc = this.getKeywordCode(this.stok.sval);
                return tc == -1 ? 10 : tc;
            }
            case -2: {
                return 11;
            }
            case -1: {
                return 100;
            }
        }
        if (ttype == 39) {
            return 1;
        }
        tc = this.getDelimiter(ttype);
        return tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String filename = "c:/cygwin/home/bozyurt/test.sql";
        Tokenizer tokenizer = null;
        try {
            try {
                tokenizer = new Tokenizer(filename);
                int tc = -1;
                while ((tc = tokenizer.getNextToken()) != -1) {
                    switch (tc) {
                        case 10: {
                            System.out.println("word: " + tokenizer.getStringValue());
                            break;
                        }
                        case 1: {
                            System.out.println("string: " + tokenizer.getStringValue());
                            break;
                        }
                        case 11: {
                            System.out.println("number: " + tokenizer.getNumber());
                        }
                    }
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                Object var5_6 = null;
                if (tokenizer != null) {
                    tokenizer.shutdown();
                }
            }
            Object var5_5 = null;
            if (tokenizer != null) {
                tokenizer.shutdown();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (tokenizer != null) {
                tokenizer.shutdown();
            }
            throw throwable;
        }
    }
}

