/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.OutputStream;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.displaytag.Messages;
import org.displaytag.exception.BaseNestableJspTagException;
import org.displaytag.exception.SeverityEnum;
import org.displaytag.export.BinaryExportView;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;

public class PdfView
implements BinaryExportView {
    private TableModel model;
    private boolean exportFull;
    private boolean header;
    private boolean decorated;
    private Table tablePDF;
    private Font smallFont;
    static /* synthetic */ Class class$org$displaytag$export$PdfView;

    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = tableModel;
        this.exportFull = exportFullList;
        this.header = includeHeader;
        this.decorated = decorateValues;
    }

    protected void initTable() throws BadElementException {
        this.tablePDF = new Table(this.model.getNumberOfColumns());
        this.tablePDF.setDefaultVerticalAlignment(4);
        this.tablePDF.setCellsFitPage(true);
        this.tablePDF.setWidth(100.0f);
        this.tablePDF.setPadding(2.0f);
        this.tablePDF.setSpacing(0.0f);
        this.smallFont = FontFactory.getFont((String)"Helvetica", (float)7.0f, (int)0, (Color)new Color(0, 0, 0));
    }

    public String getMimeType() {
        return "application/pdf";
    }

    protected void generatePDFTable() throws JspException, BadElementException {
        if (this.header) {
            this.generateHeaders();
        }
        this.tablePDF.endHeaders();
        this.generateRows();
    }

    public void doExport(OutputStream out) throws JspException {
        try {
            this.initTable();
            Document document = new Document(PageSize.A4.rotate(), 60.0f, 60.0f, 40.0f, 40.0f);
            document.addCreationDate();
            HeaderFooter footer = new HeaderFooter(new Phrase("", this.smallFont), true);
            footer.setBorder(0);
            footer.setAlignment(1);
            PdfWriter.getInstance((Document)document, (OutputStream)out);
            this.generatePDFTable();
            document.open();
            document.setFooter(footer);
            document.add((Element)this.tablePDF);
            document.close();
        }
        catch (Exception e) {
            throw new PdfGenerationException(e);
        }
    }

    protected void generateHeaders() throws BadElementException {
        Iterator iterator = this.model.getHeaderCellList().iterator();
        while (iterator.hasNext()) {
            HeaderCell headerCell = (HeaderCell)iterator.next();
            String columnHeader = headerCell.getTitle();
            if (columnHeader == null) {
                columnHeader = StringUtils.capitalize((String)headerCell.getBeanPropertyName());
            }
            Cell hdrCell = this.getCell(columnHeader);
            hdrCell.setGrayFill(0.9f);
            hdrCell.setHeader(true);
            this.tablePDF.addCell(hdrCell);
        }
    }

    protected void generateRows() throws JspException, BadElementException {
        RowIterator rowIterator = this.model.getRowIterator(this.exportFull);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            ColumnIterator columnIterator = row.getColumnIterator(this.model.getHeaderCellList());
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                Object value = column.getValue(this.decorated);
                Cell cell = this.getCell(ObjectUtils.toString((Object)value));
                this.tablePDF.addCell(cell);
            }
        }
    }

    private Cell getCell(String value) throws BadElementException {
        Cell cell = new Cell((Element)new Chunk(StringUtils.trimToEmpty((String)value), this.smallFont));
        cell.setVerticalAlignment(4);
        cell.setLeading(8.0f);
        return cell;
    }

    static class PdfGenerationException
    extends BaseNestableJspTagException {
        private static final long serialVersionUID = 899149338534L;

        public PdfGenerationException(Throwable cause) {
            super(class$org$displaytag$export$PdfView == null ? (class$org$displaytag$export$PdfView = PdfView.class$("org.displaytag.export.PdfView")) : class$org$displaytag$export$PdfView, Messages.getString("PdfView.errorexporting"), cause);
        }

        public SeverityEnum getSeverity() {
            return SeverityEnum.ERROR;
        }
    }
}

