/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Context;
import com.opensymphony.xwork2.inject.Factory;
import com.opensymphony.xwork2.inject.Scope;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.ObjectTypeDeterminer;
import com.opensymphony.xwork2.util.XWorkConverter;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.velocity.VelocityManager;

public class BeanSelectionProvider
implements ConfigurationProvider {
    public static final String DEFAULT_BEAN_NAME = "struts";
    private static final Log LOG = LogFactory.getLog(BeanSelectionProvider.class);

    public void destroy() {
    }

    public void loadPackages() throws ConfigurationException {
    }

    public void init(Configuration configuration) throws ConfigurationException {
    }

    public boolean needsReload() {
        return false;
    }

    public void register(ContainerBuilder builder, LocatableProperties props) {
        this.alias(ObjectFactory.class, "struts.objectFactory", builder, (Properties)props);
        this.alias(XWorkConverter.class, "struts.xworkConverter", builder, (Properties)props);
        this.alias(TextProvider.class, "struts.xworkTextProvider", builder, (Properties)props);
        this.alias(ActionProxyFactory.class, "struts.actionProxyFactory", builder, (Properties)props);
        this.alias(ObjectTypeDeterminer.class, "struts.objectTypeDeterminer", builder, (Properties)props);
        this.alias(ActionMapper.class, "struts.mapper.class", builder, (Properties)props);
        this.alias(MultiPartRequest.class, "struts.multipart.parser", builder, (Properties)props, Scope.DEFAULT);
        this.alias(FreemarkerManager.class, "struts.freemarker.manager.classname", builder, (Properties)props);
        this.alias(VelocityManager.class, "struts.velocity.manager.classname", builder, (Properties)props);
        if ("true".equalsIgnoreCase(props.getProperty("struts.devMode"))) {
            props.setProperty("struts.i18n.reload", "true");
            props.setProperty("struts.configuration.xml.reload", "true");
            props.setProperty("struts.freemarker.templatesCache", "false");
            props.setProperty("devMode", "true");
        } else {
            props.setProperty("devMode", "false");
        }
        LocalizedTextUtil.addDefaultResourceBundle((String)"org/apache/struts2/struts-messages");
        String bundles = props.getProperty("struts.custom.i18n.resources");
        if (bundles != null && bundles.length() > 0) {
            StringTokenizer customBundles = new StringTokenizer(props.getProperty("struts.custom.i18n.resources"), ", ");
            while (customBundles.hasMoreTokens()) {
                String name = customBundles.nextToken();
                try {
                    LOG.info((Object)("Loading global messages from " + name));
                    LocalizedTextUtil.addDefaultResourceBundle((String)name);
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not find messages file " + name + ".properties. Skipping"));
                }
            }
        }
    }

    void alias(Class type, String key, ContainerBuilder builder, Properties props) {
        this.alias(type, key, builder, props, Scope.SINGLETON);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void alias(Class type, String key, ContainerBuilder builder, Properties props, Scope scope) {
        if (!builder.contains(type)) {
            String foundName = props.getProperty(key, DEFAULT_BEAN_NAME);
            if (builder.contains(type, foundName)) {
                if (LOG.isDebugEnabled()) {
                    LOG.info((Object)("Choosing bean (" + foundName + ") for " + type));
                }
                builder.alias(type, foundName, "default");
                return;
            } else {
                try {
                    Class cls = ClassLoaderUtil.loadClass((String)foundName, this.getClass());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Choosing bean (" + cls + ") for " + type));
                    }
                    builder.factory(type, cls, scope);
                    return;
                }
                catch (ClassNotFoundException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Choosing bean (" + foundName + ") for " + type + " to be loaded from the ObjectFactory"));
                    }
                    if (DEFAULT_BEAN_NAME.equals(foundName)) return;
                    if (ObjectFactory.class == type) throw new ConfigurationException("Cannot locate the chosen ObjectFactory implementation: " + foundName);
                    builder.factory(type, (Factory)new ObjectFactoryDelegateFactory(foundName, type), scope);
                    return;
                }
            }
        } else {
            LOG.warn((Object)("Unable to alias bean type " + type + ", default mapping already assigned."));
        }
    }

    class ObjectFactoryDelegateFactory
    implements Factory {
        String name;
        Class type;

        ObjectFactoryDelegateFactory(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        public Object create(Context context) throws Exception {
            ObjectFactory objFactory = (ObjectFactory)context.getContainer().getInstance(ObjectFactory.class);
            try {
                return objFactory.buildBean(this.name, null, true);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Unable to load bean " + this.type.getName() + " (" + this.name + ")");
            }
        }
    }
}

