/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.vo.ConfParams;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ConfParamsDAO
implements clinical.server.dao.ConfParamsDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection con, ConfParams bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_CONF_PARAMS ");
            buf.append(" (NAME,VALUE,TYPE,DESCRIPTION,PARAM_GROUP_ID,OWNER,MOD_TIME,MOD_USER) ");
            buf.append("VALUES ");
            buf.append('(');
            for (int i = 0; i < 8; ++i) {
                buf.append('?');
                if (i >= 7) continue;
                buf.append(',');
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getName(), 12);
            ps.setObject(2, bean.getValue(), 12);
            ps.setObject(3, bean.getType(), 12);
            ps.setObject(4, bean.getDescription(), 12);
            ps.setObject(5, bean.getParamGroupId(), 2);
            ps.setObject(6, bean.getOwner(), 2);
            ps.setTimestamp(7, bean.getModTime() == null ? null : new Timestamp(bean.getModTime().getTime()));
            ps.setObject(8, bean.getModUser(), 2);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception x) {}
            }
        }
    }

    protected String prepareColList(ConfParams bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("NAME");
        buf.append(',');
        buf.append("VALUE");
        buf.append(',');
        buf.append("TYPE");
        buf.append(',');
        buf.append("DESCRIPTION");
        buf.append(',');
        buf.append("PARAM_GROUP_ID");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MOD_TIME");
        buf.append(',');
        buf.append("MOD_USER");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(ConfParams bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getName() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("NAME=?");
            qi.values.add(bean.getName());
            valueSet = true;
        }
        if (bean.getValue() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("VALUE=?");
            qi.values.add(bean.getValue());
            valueSet = true;
        }
        if (bean.getType() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TYPE=?");
            qi.values.add(bean.getType());
            valueSet = true;
        }
        if (bean.getDescription() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DESCRIPTION=?");
            qi.values.add(bean.getDescription());
            valueSet = true;
        }
        if (bean.getParamGroupId() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("PARAM_GROUP_ID=?");
            qi.values.add(bean.getParamGroupId());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModTime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MOD_TIME=?");
            qi.values.add(new Timestamp(bean.getModTime().getTime()));
            valueSet = true;
        }
        if (bean.getModUser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MOD_USER=?");
            qi.values.add(bean.getModUser());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(ConfParams bean, ConfParams criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_CONF_PARAMS SET ");
        if (bean.getName() != null || bean.isNull("name")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("NAME=? ");
            uqi.setValues.add(bean.getName());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("name"), uqi);
            valueSet = true;
        }
        if (bean.getValue() != null || bean.isNull("value")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("VALUE=? ");
            uqi.setValues.add(bean.getValue());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("value"), uqi);
            valueSet = true;
        }
        if (bean.getType() != null || bean.isNull("type")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TYPE=? ");
            uqi.setValues.add(bean.getType());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("type"), uqi);
            valueSet = true;
        }
        if (bean.getDescription() != null || bean.isNull("description")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DESCRIPTION=? ");
            uqi.setValues.add(bean.getDescription());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("description"), uqi);
            valueSet = true;
        }
        if (bean.getParamGroupId() != null || bean.isNull("paramGroupId")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("PARAM_GROUP_ID=? ");
            uqi.setValues.add(bean.getParamGroupId());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("paramGroupId"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModTime() != null || bean.isNull("modTime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MOD_TIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModTime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modTime"), uqi);
            valueSet = true;
        }
        if (bean.getModUser() != null || bean.isNull("modUser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MOD_USER=? ");
            uqi.setValues.add(bean.getModUser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("modUser"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = uqi.query + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    public ConfParams createObject(ResultSet rs) throws SQLException {
        ConfParams obj = new ConfParams();
        obj.setName((String)rs.getObject(1));
        obj.setValue((String)rs.getObject(2));
        obj.setType((String)rs.getObject(3));
        obj.setDescription((String)rs.getObject(4));
        obj.setParamGroupId((BigDecimal)rs.getObject(5));
        obj.setOwner((BigDecimal)rs.getObject(6));
        if (rs.getTimestamp(7) != null) {
            obj.setModTime(new Date(rs.getTimestamp(7).getTime()));
        }
        obj.setModUser((BigDecimal)rs.getObject(8));
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConfParams> find(Connection con, ConfParams criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<ConfParams> results = new LinkedList<ConfParams>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_CONF_PARAMS ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ConfParams item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Connection con, ConfParams bean, ConfParams criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Connection con, ConfParams criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_CONF_PARAMS ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }
}

