/*
 * Decompiled with CFR 0.152.
 */
package clinical.utils;

import clinical.utils.Assertion;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class FileUtils {
    protected FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String sourceFile, String destFile) throws FileNotFoundException, IOException {
        BufferedInputStream bin = null;
        FilterOutputStream bout = null;
        try {
            bin = new BufferedInputStream(new FileInputStream(sourceFile));
            bout = new BufferedOutputStream(new FileOutputStream(destFile));
            byte[] buffer = new byte[4096];
            int readBytes = 0;
            while ((readBytes = bin.read(buffer)) != -1) {
                ((BufferedOutputStream)bout).write(buffer, 0, readBytes);
            }
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception x) {}
            }
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (Exception x) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyContent(String sourceFile, OutputStream destOut) throws FileNotFoundException, IOException {
        BufferedInputStream bin = null;
        try {
            bin = new BufferedInputStream(new FileInputStream(sourceFile));
            byte[] buffer = new byte[4096];
            int readBytes = 0;
            while ((readBytes = bin.read(buffer)) != -1) {
                destOut.write(buffer, 0, readBytes);
            }
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadTextFile(String filename) throws IOException {
        BufferedReader in = null;
        StringBuffer buf = new StringBuffer(4096);
        try {
            in = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = in.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            String string = buf.toString();
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception x) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save2File(String content, String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            out.write(content);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Element loadXML(String xmlFile) throws Exception {
        SAXBuilder builder = new SAXBuilder(false);
        Document doc = builder.build(xmlFile);
        return doc.getRootElement();
    }

    public static Element loadXML(Reader reader) throws Exception {
        SAXBuilder builder = new SAXBuilder(false);
        Document doc = builder.build(reader);
        return doc.getRootElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveXML(Element rootElem, String xmlFile) throws Exception {
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(xmlFile));
            xout.output(rootElem, (Writer)out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception x) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveXML(Element rootElem, OutputStream outStream) throws IOException {
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        try {
            xout.output(rootElem, outStream);
        }
        finally {
            FileUtils.close(outStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveXML(Element rootElem, Writer out) throws IOException {
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        try {
            xout.output(rootElem, out);
        }
        finally {
            FileUtils.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveXML(Document doc, Writer out) throws IOException {
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        try {
            xout.output(doc, out);
        }
        finally {
            FileUtils.close(out);
        }
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Writer out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void findLeafPaths(File parent, List<File> dirList) {
        if (parent.isFile()) {
            parent.delete();
        } else if (parent.exists()) {
            File[] files = parent.listFiles();
            if (files == null || files.length == 0) {
                dirList.add(parent);
            } else {
                for (int i = 0; i < files.length; ++i) {
                    FileUtils.findLeafPaths(files[i], dirList);
                }
            }
        }
    }

    public static void deleteRecursively(File dir) {
        if (dir.isFile()) {
            dir.delete();
        } else if (dir.exists()) {
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        FileUtils.deleteRecursively(files[i]);
                        continue;
                    }
                    files[i].delete();
                }
            }
            dir.delete();
        }
    }

    public static void deleteSubdirs(String rootDir, String path) {
        File f = new File(path);
        ArrayList<File> dirList = new ArrayList<File>();
        if (f.isDirectory()) {
            FileUtils.findLeafPaths(f, dirList);
        }
        for (File dir : dirList) {
            do {
                if (!dir.isDirectory()) continue;
                dir.delete();
            } while (!(dir = dir.getParentFile()).getPath().equals(rootDir));
        }
    }

    public static String getRelativePath(String rootDir, String path) {
        int idx = path.indexOf(rootDir);
        assert (idx == 0);
        String relPath = path.substring(rootDir.length());
        relPath = relPath.replaceFirst("^\\/+", "");
        return relPath;
    }

    public static String getTopDir(String rootDir, File path) {
        String relPath = FileUtils.getRelativePath(rootDir, path.getAbsolutePath());
        int idx = relPath.indexOf("/");
        if (idx == -1) {
            return null;
        }
        return relPath.substring(0, idx);
    }

    public static boolean buildLocalPath(String rootDir, String relativePath) {
        File parent = new File(rootDir);
        Assertion.assertTrue(parent.isDirectory());
        File f = new File(parent, relativePath);
        f.getParentFile().mkdirs();
        return f.getParentFile().isDirectory();
    }

    public static String createFullPath(String rootDir, String relativePath) {
        StringBuffer buf = new StringBuffer();
        buf.append(rootDir);
        if (rootDir.endsWith("/")) {
            if (relativePath.startsWith("/")) {
                buf.append(relativePath.substring(1));
            } else {
                buf.append(relativePath);
            }
        } else if (relativePath.startsWith("/")) {
            buf.append(relativePath);
        } else {
            buf.append('/').append(relativePath);
        }
        return buf.toString();
    }

    public static List<File> getAllFilesUnderDir(String rootPath) {
        ArrayList<File> paths = new ArrayList<File>();
        File dir = new File(rootPath);
        FileUtils.prepBranch(dir, paths);
        return paths;
    }

    protected static void prepBranch(File parentDir, List<File> paths) {
        if (parentDir == null) {
            return;
        }
        File[] files = parentDir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                paths.add(files[i]);
                continue;
            }
            FileUtils.prepBranch(files[i], paths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Object o, String filename) throws IOException {
        assert (o != null);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 4096));
            out.writeObject(o);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(String filename) throws IOException, ClassNotFoundException {
        assert (filename != null && new File(filename).isFile());
        ObjectInputStream in = null;
        try {
            Object o;
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filename), 4096));
            Object object = o = in.readObject();
            return object;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception x) {}
            }
        }
    }

    public static long getTotalSizeUnderDir(String relPath, String localRootDir) {
        File f = new File(localRootDir, relPath);
        List<File> allFilesUnderDir = FileUtils.getAllFilesUnderDir(f.getAbsolutePath());
        long totSize = 0L;
        for (File file : allFilesUnderDir) {
            if (!file.isFile()) continue;
            totSize += file.length();
        }
        return totSize;
    }
}

