/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.common.query;

import clinical.web.common.query.QueryUtils;
import clinical.web.common.query.SearchCriteria;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.query.SearchPredicateList;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TSQLQueryBuilder {
    protected Class<?> voClass;
    protected SearchPredicateList spList;
    protected BeanInfo bi;
    protected SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yy");
    private static Log log = LogFactory.getLog(TSQLQueryBuilder.class);

    public TSQLQueryBuilder(Class<?> valueObjectClass, SearchPredicateList spList) throws Exception {
        this.voClass = valueObjectClass;
        this.spList = spList;
        this.bi = Introspector.getBeanInfo(this.voClass, Object.class);
    }

    public TSQLQueryBuilder(Class<?> valueObjectClass, SearchCriteria sc) throws Exception {
        this.voClass = valueObjectClass;
        this.spList = sc.getSpList();
        this.bi = Introspector.getBeanInfo(this.voClass, Object.class);
    }

    public static String getBaseClassName(String fullClassName) {
        int idx = fullClassName.lastIndexOf(46);
        if (idx != -1) {
            return fullClassName.substring(idx + 1);
        }
        return fullClassName;
    }

    public String buildQuery() throws Exception {
        StringBuffer query = new StringBuffer(256);
        HashMap<String, PropertyDescriptor> propMap = new HashMap<String, PropertyDescriptor>(19);
        PropertyDescriptor[] pds = this.bi.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)pds[i].getName());
            }
            propMap.put(pds[i].getName().toLowerCase(), pds[i]);
        }
        String beanName = TSQLQueryBuilder.getBaseClassName(this.voClass.getName());
        String alias = String.valueOf(Character.toLowerCase(beanName.charAt(0)));
        query.append("select ").append(alias).append(".* ");
        query.append(" from ").append(beanName).append(" as ").append(alias).append(' ');
        boolean first = true;
        for (SearchPredicateList.SearchPredicateInfo spi : this.spList) {
            String attr = (String)spi.getSearchPredicate().getAttribute();
            if (propMap.get(attr.toLowerCase()) == null) continue;
            if (first) {
                query.append("where ");
            } else if (spi.getLogicOp() == 1) {
                query.append(" and ");
            } else if (spi.getLogicOp() == 2) {
                query.append(" or ");
            }
            String colName = attr;
            if (log.isDebugEnabled()) {
                log.debug((Object)(">>colName=" + colName + "attr=" + attr));
            }
            query.append(this.buildPredicate(spi.getSearchPredicate(), alias));
            first = false;
        }
        return query.toString();
    }

    protected String buildPredicate(SearchPredicate sp, String alias) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ");
        buf.append(alias).append('.').append(sp.getAttribute());
        int op = sp.getOperator();
        if (sp.getValue() == null || sp.getValue().toString().trim().equals("*")) {
            buf.append(" is not null ) ");
            return buf.toString();
        }
        buf.append(QueryUtils.getRelationalOperator((int)op));
        if (op == 7) {
            SearchPredicate.Range range = (SearchPredicate.Range)sp.getValue();
            buf.append(range.getLowBound()).append(" and ").append(range.getUppBound());
        } else if (op == 100) {
            buf.append("'").append(sp.getValue()).append("%' ");
        } else if (op == 101) {
            buf.append("'%").append(sp.getValue()).append("' ");
        } else if (sp.getType() == 1001) {
            buf.append("'").append(sp.getValue()).append("' ");
        } else if (sp.getType() == 1004) {
            this.preparePredicateDateValue(sp, buf);
        } else {
            buf.append(sp.getValue()).append(' ');
        }
        buf.append(") ");
        return buf.toString();
    }

    protected void preparePredicateDateValue(SearchPredicate sp, StringBuffer buf) {
        Date date = (Date)sp.getValue();
        buf.append(this.df.format(date)).append(' ');
    }
}

