/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationInfo
extends AbstractPropertiesHolder {
    private static final Logger LOG = LogUtils.getL7dLogger(OperationInfo.class);
    InterfaceInfo intf;
    QName opName;
    String inName;
    MessageInfo inputMessage;
    String outName;
    MessageInfo outputMessage;
    Map<QName, FaultInfo> faults;
    OperationInfo unwrappedOperation;
    List<String> parameterOrdering;

    public OperationInfo() {
    }

    OperationInfo(InterfaceInfo it, QName n) {
        this.intf = it;
        this.setName(n);
    }

    OperationInfo(OperationInfo op) {
        this.intf = op.getInterface();
        this.setName(op.getName());
    }

    public QName getName() {
        return this.opName;
    }

    public final void setName(QName name) {
        if (name == null) {
            throw new NullPointerException("Operation Name cannot be null.");
        }
        this.opName = name;
    }

    public InterfaceInfo getInterface() {
        return this.intf;
    }

    public MessageInfo createMessage(QName nm) {
        return new MessageInfo(this, nm);
    }

    public MessageInfo getOutput() {
        return this.outputMessage;
    }

    public String getOutputName() {
        return this.outName;
    }

    public void setOutput(String nm, MessageInfo out) {
        this.outName = nm;
        this.outputMessage = out;
    }

    public boolean hasOutput() {
        return this.outputMessage != null;
    }

    public MessageInfo getInput() {
        return this.inputMessage;
    }

    public String getInputName() {
        return this.inName;
    }

    public void setInput(String nm, MessageInfo in) {
        this.inName = nm;
        this.inputMessage = in;
    }

    public boolean hasInput() {
        return this.inputMessage != null;
    }

    public boolean isOneWay() {
        return this.inputMessage != null && this.outputMessage == null;
    }

    public boolean isUnwrappedCapable() {
        return this.unwrappedOperation != null;
    }

    public OperationInfo getUnwrappedOperation() {
        return this.unwrappedOperation;
    }

    public void setUnwrappedOperation(OperationInfo op) {
        this.unwrappedOperation = op;
    }

    public boolean isUnwrapped() {
        return false;
    }

    public FaultInfo addFault(QName name, QName message) {
        if (name == null) {
            throw new NullPointerException(new Message("FAULT.NAME.NOT.NULL", LOG, new Object[0]).toString());
        }
        if (this.faults != null && this.faults.containsKey(name)) {
            throw new IllegalArgumentException(new Message("DUPLICATED.FAULT.NAME", LOG, name).toString());
        }
        FaultInfo fault = new FaultInfo(name, message, this);
        this.addFault(fault);
        return fault;
    }

    public synchronized void addFault(FaultInfo fault) {
        if (this.faults == null) {
            this.faults = new ConcurrentHashMap<QName, FaultInfo>(4);
        }
        this.faults.put(fault.getFaultName(), fault);
    }

    public void removeFault(QName name) {
        if (this.faults != null) {
            this.faults.remove(name);
        }
    }

    public FaultInfo getFault(QName name) {
        if (this.faults != null) {
            return this.faults.get(name);
        }
        return null;
    }

    public boolean hasFaults() {
        return this.faults != null && this.faults.size() > 0;
    }

    public Collection<FaultInfo> getFaults() {
        if (this.faults == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.faults.values());
    }

    public void setParameterOrdering(List<String> o) {
        this.parameterOrdering = o;
    }

    public List<String> getParameterOrdering() {
        return this.parameterOrdering;
    }

    public String toString() {
        return "[OperationInfo: " + this.opName + "]";
    }
}

