/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.sql.Connection;
import java.sql.DriverManager;
import org.dbunit.AbstractDatabaseTester;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDatabaseTester
extends AbstractDatabaseTester {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$JdbcDatabaseTester == null ? (class$org$dbunit$JdbcDatabaseTester = JdbcDatabaseTester.class$("org.dbunit.JdbcDatabaseTester")) : class$org$dbunit$JdbcDatabaseTester));
    private String connectionUrl;
    private String driverClass;
    private boolean initialized = false;
    private String password;
    private String username;
    static /* synthetic */ Class class$org$dbunit$JdbcDatabaseTester;

    public JdbcDatabaseTester(String driverClass, String connectionUrl) {
        this(driverClass, connectionUrl, null, null);
    }

    public JdbcDatabaseTester(String driverClass, String connectionUrl, String username, String password) {
        this.driverClass = driverClass;
        this.connectionUrl = connectionUrl;
        this.username = username;
        this.password = password;
    }

    public IDatabaseConnection getConnection() throws Exception {
        logger.debug("getConnection() - start");
        if (!this.initialized) {
            this.initialize();
        }
        this.assertNotNullNorEmpty("connectionUrl", this.connectionUrl);
        Connection conn = null;
        conn = this.username == null && this.password == null ? DriverManager.getConnection(this.connectionUrl) : DriverManager.getConnection(this.connectionUrl, this.username, this.password);
        if (this.getSchema() != null) {
            return new DatabaseConnection(conn, this.getSchema());
        }
        return new DatabaseConnection(conn);
    }

    public void setPassword(String password) {
        logger.debug("setPassword(password=" + password + ") - start");
        this.password = password;
    }

    public void setUsername(String username) {
        logger.debug("setUsername(username=" + username + ") - start");
        this.username = username;
    }

    protected void initialize() throws Exception {
        logger.debug("initialize() - start");
        this.assertNotNullNorEmpty("driverClass", this.driverClass);
        Class.forName(this.driverClass);
        this.initialized = true;
    }

    protected void setConnectionUrl(String connectionUrl) {
        logger.debug("setConnectionUrl(connectionUrl=" + connectionUrl + ") - start");
        this.connectionUrl = connectionUrl;
    }

    protected void setDriverClass(String driverClass) {
        logger.debug("setDriverClass(driverClass=" + driverClass + ") - start");
        this.driverClass = driverClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

