/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ForwardOnlyTable;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardOnlyDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$ForwardOnlyDataSet == null ? (class$org$dbunit$dataset$ForwardOnlyDataSet = ForwardOnlyDataSet.class$("org.dbunit.dataset.ForwardOnlyDataSet")) : class$org$dbunit$dataset$ForwardOnlyDataSet));
    private final IDataSet _dataSet;
    private int _iteratorCount;
    static /* synthetic */ Class class$org$dbunit$dataset$ForwardOnlyDataSet;
    static /* synthetic */ Class class$org$dbunit$dataset$ForwardOnlyDataSet$ForwardOnlyIterator;

    public ForwardOnlyDataSet(IDataSet dataSet) {
        this._dataSet = dataSet;
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed=" + reversed + ") - start");
        if (reversed) {
            throw new UnsupportedOperationException("Reverse iterator not supported!");
        }
        if (this._iteratorCount > 0) {
            throw new UnsupportedOperationException("Only one iterator allowed!");
        }
        return new ForwardOnlyIterator(this._dataSet.iterator());
    }

    public String[] getTableNames() throws DataSetException {
        logger.debug("getTableNames() - start");
        throw new UnsupportedOperationException();
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName=" + tableName + ") - start");
        throw new UnsupportedOperationException();
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName=" + tableName + ") - start");
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ForwardOnlyIterator
    implements ITableIterator {
        private final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$ForwardOnlyDataSet$ForwardOnlyIterator == null ? (class$org$dbunit$dataset$ForwardOnlyDataSet$ForwardOnlyIterator = ForwardOnlyDataSet.class$("org.dbunit.dataset.ForwardOnlyDataSet$ForwardOnlyIterator")) : class$org$dbunit$dataset$ForwardOnlyDataSet$ForwardOnlyIterator));
        private final ITableIterator _iterator;

        public ForwardOnlyIterator(ITableIterator iterator) {
            this._iterator = iterator;
            ForwardOnlyDataSet.this._iteratorCount++;
        }

        public boolean next() throws DataSetException {
            this.logger.debug("next() - start");
            return this._iterator.next();
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            this.logger.debug("getTableMetaData() - start");
            return this._iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            this.logger.debug("getTable() - start");
            return new ForwardOnlyTable(this._iterator.getTable());
        }
    }
}

