/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperation
extends DatabaseOperation {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$operation$AbstractOperation == null ? (class$org$dbunit$operation$AbstractOperation = AbstractOperation.class$("org.dbunit.operation.AbstractOperation")) : class$org$dbunit$operation$AbstractOperation));
    static /* synthetic */ Class class$org$dbunit$operation$AbstractOperation;

    protected String getQualifiedName(String prefix, String name, IDatabaseConnection connection) {
        logger.debug("getQualifiedName(prefix=" + prefix + ", name=" + name + ", connection=" + connection + ") - start");
        String escapePattern = (String)connection.getConfig().getProperty("http://www.dbunit.org/properties/escapePattern");
        return DataSetUtils.getQualifiedName(prefix, name, escapePattern);
    }

    static ITableMetaData getOperationMetaData(IDatabaseConnection connection, ITableMetaData metaData) throws DatabaseUnitException, SQLException {
        logger.debug("getOperationMetaData(connection=" + connection + ", metaData=" + metaData + ") - start");
        IDataSet databaseDataSet = connection.createDataSet();
        String tableName = metaData.getTableName();
        ITableMetaData databaseMetaData = databaseDataSet.getTableMetaData(tableName);
        Column[] databaseColumns = databaseMetaData.getColumns();
        Column[] columns = metaData.getColumns();
        ArrayList<Column> columnList = new ArrayList<Column>();
        for (int j = 0; j < columns.length; ++j) {
            String columnName = columns[j].getColumnName();
            Column column = DataSetUtils.getColumn(columnName, databaseColumns);
            if (column == null) {
                throw new NoSuchColumnException(tableName + "." + columnName);
            }
            columnList.add(column);
        }
        return new DefaultTableMetaData(databaseMetaData.getTableName(), columnList.toArray(new Column[0]), databaseMetaData.getPrimaryKeys());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

