/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.geometry;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class GeometryOfSlice {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/geometry/GeometryOfSlice.java,v 1.13 2005/10/25 17:57:15 dclunie Exp $";
    protected double[] rowArray;
    protected Vector3d row;
    protected double[] columnArray;
    protected Vector3d column;
    protected Point3d tlhc;
    protected double[] tlhcArray;
    protected Tuple3d voxelSpacing;
    protected double[] voxelSpacingArray;
    protected double sliceThickness;
    protected Tuple3d dimensions;
    protected Vector3d normal;
    protected double[] normalArray;

    protected final void makeNormal() {
        this.normal = new Vector3d();
        this.normal.cross(this.row, this.column);
        this.normal.normalize();
        this.normalArray = new double[3];
        this.normal.get(this.normalArray);
        this.normalArray[2] = this.normalArray[2] * -1.0;
        this.normal = new Vector3d(this.normalArray);
    }

    public GeometryOfSlice() {
    }

    public GeometryOfSlice(Vector3d vector3d, Vector3d vector3d2, Point3d point3d, Tuple3d tuple3d, double d, Tuple3d tuple3d2) {
        this.row = vector3d;
        this.rowArray = new double[3];
        vector3d.get(this.rowArray);
        this.column = vector3d2;
        this.columnArray = new double[3];
        vector3d2.get(this.columnArray);
        this.tlhc = point3d;
        this.tlhcArray = new double[3];
        point3d.get(this.tlhcArray);
        this.voxelSpacing = tuple3d;
        this.voxelSpacingArray = new double[3];
        tuple3d.get(this.voxelSpacingArray);
        this.sliceThickness = d;
        this.dimensions = tuple3d2;
        this.makeNormal();
    }

    public GeometryOfSlice(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double[] dArray5) {
        this.rowArray = dArray;
        this.row = new Vector3d(dArray);
        this.columnArray = dArray2;
        this.column = new Vector3d(dArray2);
        this.tlhcArray = dArray3;
        this.tlhc = new Point3d(dArray3);
        this.voxelSpacingArray = dArray4;
        this.voxelSpacing = new Vector3d(dArray4);
        this.sliceThickness = d;
        this.dimensions = new Vector3d(dArray5);
        this.makeNormal();
    }

    public final Vector3d getRow() {
        return this.row;
    }

    public final double[] getRowArray() {
        return this.rowArray;
    }

    public final Vector3d getColumn() {
        return this.column;
    }

    public final double[] getColumnArray() {
        return this.columnArray;
    }

    public final Vector3d getNormal() {
        return this.normal;
    }

    public final double[] getNormalArray() {
        return this.normalArray;
    }

    public final Point3d getTLHC() {
        return this.tlhc;
    }

    public final double[] getTLHCArray() {
        return this.tlhcArray;
    }

    public final Tuple3d getVoxelSpacing() {
        return this.voxelSpacing;
    }

    public final double[] getVoxelSpacingArray() {
        return this.voxelSpacingArray;
    }

    public final double getSliceThickness() {
        return this.sliceThickness;
    }

    public final Tuple3d getDimensions() {
        return this.dimensions;
    }

    final void setVoxelSpacingBetweenSlices(double d) {
        this.voxelSpacingArray[2] = d;
        this.voxelSpacing.set(this.voxelSpacingArray);
    }

    public final double[] lookupImageCoordinate(int n, int n2) {
        double[] dArray = new double[3];
        this.lookupImageCoordinate(dArray, n, n2);
        return dArray;
    }

    public final void lookupImageCoordinate(double[] dArray, int n, int n2) {
        dArray[0] = this.tlhcArray[0] + (double)n2 * this.columnArray[0] * this.voxelSpacingArray[0] + (double)n * this.rowArray[0] * this.voxelSpacingArray[1];
        dArray[1] = this.tlhcArray[1] + (double)n2 * this.columnArray[1] * this.voxelSpacingArray[0] + (double)n * this.rowArray[1] * this.voxelSpacingArray[1];
        dArray[2] = this.tlhcArray[2] + (double)n2 * this.columnArray[2] * this.voxelSpacingArray[0] + (double)n * this.rowArray[2] * this.voxelSpacingArray[1];
    }

    public final double[] lookupImageCoordinate(double[] dArray) {
        double[] dArray2 = new double[2];
        this.lookupImageCoordinate(dArray2, dArray);
        return dArray2;
    }

    public final void lookupImageCoordinate(double[] dArray, double[] dArray2) {
        double d = ((dArray2[1] - this.tlhcArray[1]) * (this.columnArray[0] * this.voxelSpacingArray[0]) - (dArray2[0] - this.tlhcArray[0]) * (this.columnArray[1] * this.voxelSpacingArray[0])) / (this.rowArray[1] * this.voxelSpacingArray[1] * this.columnArray[0] * this.voxelSpacingArray[0] - this.rowArray[0] * this.voxelSpacingArray[1] * this.columnArray[1] * this.voxelSpacingArray[0]);
        double d2 = (dArray2[1] - this.tlhcArray[1] - d * this.rowArray[1] * this.voxelSpacingArray[1]) / (this.columnArray[1] * this.voxelSpacingArray[0]);
        dArray[0] = d;
        dArray[1] = d2;
    }

    public final double getDistanceAlongNormalFromOrigin() {
        Vector3d vector3d = new Vector3d((Tuple3d)this.tlhc);
        double d = this.normal.dot(vector3d);
        return d;
    }

    public static final boolean areSlicesParallel(GeometryOfSlice geometryOfSlice, GeometryOfSlice geometryOfSlice2) {
        boolean bl = false;
        if (geometryOfSlice != null && geometryOfSlice2 != null) {
            double[] dArray = geometryOfSlice.getNormalArray();
            double[] dArray2 = geometryOfSlice2.getNormalArray();
            if (dArray != null && dArray2 != null) {
                bl = Math.abs(dArray[0] - dArray2[0]) < 0.001 && Math.abs(dArray[1] - dArray2[1]) < 0.001 && Math.abs(dArray[2] - dArray2[2]) < 0.001;
            }
        }
        return bl;
    }

    public final String toString() {
        double[] dArray = new double[3];
        this.dimensions.get(dArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Row (");
        stringBuffer.append(this.rowArray[0]);
        stringBuffer.append(",");
        stringBuffer.append(this.rowArray[1]);
        stringBuffer.append(",");
        stringBuffer.append(this.rowArray[2]);
        stringBuffer.append(") Column (");
        stringBuffer.append(this.columnArray[0]);
        stringBuffer.append(",");
        stringBuffer.append(this.columnArray[1]);
        stringBuffer.append(",");
        stringBuffer.append(this.columnArray[2]);
        stringBuffer.append(") Normal (");
        stringBuffer.append(this.normalArray[0]);
        stringBuffer.append(",");
        stringBuffer.append(this.normalArray[1]);
        stringBuffer.append(",");
        stringBuffer.append(this.normalArray[2]);
        stringBuffer.append(") TLHC (");
        stringBuffer.append(this.tlhcArray[0]);
        stringBuffer.append(",");
        stringBuffer.append(this.tlhcArray[1]);
        stringBuffer.append(",");
        stringBuffer.append(this.tlhcArray[2]);
        stringBuffer.append(") Spacing (");
        stringBuffer.append(this.voxelSpacingArray[0]);
        stringBuffer.append(",");
        stringBuffer.append(this.voxelSpacingArray[1]);
        stringBuffer.append(",");
        stringBuffer.append(this.voxelSpacingArray[2]);
        stringBuffer.append(") Thickness (");
        stringBuffer.append(this.sliceThickness);
        stringBuffer.append(") Dimensions (");
        stringBuffer.append(dArray[0]);
        stringBuffer.append(",");
        stringBuffer.append(dArray[1]);
        stringBuffer.append(",");
        stringBuffer.append(dArray[2]);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static final String getOrientation(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dArray != null && dArray.length == 3) {
            char c = dArray[0] < 0.0 ? (char)'R' : 'L';
            char c2 = dArray[1] < 0.0 ? (char)'A' : 'P';
            char c3 = dArray[2] < 0.0 ? (char)'F' : 'H';
            double d = Math.abs(dArray[0]);
            double d2 = Math.abs(dArray[1]);
            double d3 = Math.abs(dArray[2]);
            for (int i = 0; i < 3; ++i) {
                if (d > 1.0E-4 && d > d2 && d > d3) {
                    stringBuffer.append(c);
                    d = 0.0;
                    continue;
                }
                if (d2 > 1.0E-4 && d2 > d && d2 > d3) {
                    stringBuffer.append(c2);
                    d2 = 0.0;
                    continue;
                }
                if (!(d3 > 1.0E-4) || !(d3 > d) || !(d3 > d2)) continue;
                stringBuffer.append(c3);
                d3 = 0.0;
            }
        }
        return stringBuffer.toString();
    }

    public final String getRowOrientation() {
        return GeometryOfSlice.getOrientation(this.rowArray);
    }

    public final String getColumnOrientation() {
        return GeometryOfSlice.getOrientation(this.columnArray);
    }
}

