/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.database.DatabaseApplicationProperties;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCP;
import com.pixelmed.query.QueryResponseGeneratorFactory;
import com.pixelmed.query.RetrieveResponseGeneratorFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import java.util.TreeMap;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class StorageSOPClassSCPDispatcher
implements Runnable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/StorageSOPClassSCPDispatcher.java,v 1.33 2007/12/19 22:34:31 dclunie Exp $";
    private int port;
    private String calledAETitle;
    private int ourMaximumLengthReceived;
    private int socketReceiveBufferSize;
    private int socketSendBufferSize;
    private File savedImagesFolder;
    protected StoredFilePathStrategy storedFilePathStrategy;
    private ReceivedObjectHandler receivedObjectHandler;
    private QueryResponseGeneratorFactory queryResponseGeneratorFactory;
    private RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory;
    private NetworkApplicationInformation networkApplicationInformation;
    private boolean secureTransport;
    private int debugLevel;

    public StorageSOPClassSCPDispatcher(int n, String string, File file, ReceivedObjectHandler receivedObjectHandler, int n2) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.socketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.socketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = StoredFilePathStrategy.getDefaultStrategy();
        this.receivedObjectHandler = receivedObjectHandler;
        this.queryResponseGeneratorFactory = null;
        this.retrieveResponseGeneratorFactory = null;
        this.networkApplicationInformation = null;
        this.debugLevel = n2;
        this.secureTransport = false;
    }

    public StorageSOPClassSCPDispatcher(int n, String string, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, int n2) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.socketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.socketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler;
        this.queryResponseGeneratorFactory = null;
        this.retrieveResponseGeneratorFactory = null;
        this.networkApplicationInformation = null;
        this.debugLevel = n2;
        this.secureTransport = false;
    }

    public StorageSOPClassSCPDispatcher(int n, String string, int n2, int n3, int n4, File file, ReceivedObjectHandler receivedObjectHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, boolean bl, int n5) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = n2;
        this.socketReceiveBufferSize = n3;
        this.socketSendBufferSize = n4;
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = StoredFilePathStrategy.getDefaultStrategy();
        this.receivedObjectHandler = receivedObjectHandler == null ? new DefaultReceivedObjectHandler() : receivedObjectHandler;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.networkApplicationInformation = networkApplicationInformation;
        this.debugLevel = n5;
        this.secureTransport = bl;
    }

    public StorageSOPClassSCPDispatcher(int n, String string, int n2, int n3, int n4, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, boolean bl, int n5) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = n2;
        this.socketReceiveBufferSize = n3;
        this.socketSendBufferSize = n4;
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler == null ? new DefaultReceivedObjectHandler() : receivedObjectHandler;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.networkApplicationInformation = networkApplicationInformation;
        this.debugLevel = n5;
        this.secureTransport = bl;
    }

    public StorageSOPClassSCPDispatcher(int n, String string, File file, ReceivedObjectHandler receivedObjectHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, boolean bl, int n2) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.socketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.socketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = StoredFilePathStrategy.getDefaultStrategy();
        this.receivedObjectHandler = receivedObjectHandler == null ? new DefaultReceivedObjectHandler() : receivedObjectHandler;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.networkApplicationInformation = networkApplicationInformation;
        this.debugLevel = n2;
        this.secureTransport = bl;
    }

    public StorageSOPClassSCPDispatcher(int n, String string, File file, StoredFilePathStrategy storedFilePathStrategy, ReceivedObjectHandler receivedObjectHandler, QueryResponseGeneratorFactory queryResponseGeneratorFactory, RetrieveResponseGeneratorFactory retrieveResponseGeneratorFactory, NetworkApplicationInformation networkApplicationInformation, boolean bl, int n2) throws IOException {
        this.port = n;
        this.calledAETitle = string;
        this.ourMaximumLengthReceived = AssociationFactory.getDefaultMaximumLengthReceived();
        this.socketReceiveBufferSize = AssociationFactory.getDefaultReceiveBufferSize();
        this.socketSendBufferSize = AssociationFactory.getDefaultSendBufferSize();
        this.savedImagesFolder = file;
        this.storedFilePathStrategy = storedFilePathStrategy;
        this.receivedObjectHandler = receivedObjectHandler == null ? new DefaultReceivedObjectHandler() : receivedObjectHandler;
        this.queryResponseGeneratorFactory = queryResponseGeneratorFactory;
        this.retrieveResponseGeneratorFactory = retrieveResponseGeneratorFactory;
        this.networkApplicationInformation = networkApplicationInformation;
        this.debugLevel = n2;
        this.secureTransport = bl;
    }

    public void run() {
        try {
            Object object;
            Object object2;
            Object object3;
            if (this.debugLevel > 1) {
                System.err.println("StorageSOPClassSCPDispatcher.run(): Trying to bind to port " + this.port);
            }
            Object object4 = null;
            if (this.secureTransport) {
                String[] stringArray;
                object3 = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
                object2 = (SSLServerSocket)((ServerSocketFactory)object3).createServerSocket(this.port);
                object = Association.getCipherSuitesToEnable(((SSLServerSocket)object2).getSupportedCipherSuites());
                if (object != null) {
                    ((SSLServerSocket)object2).setEnabledCipherSuites((String[])object);
                }
                if ((stringArray = Association.getProtocolsToEnable(((SSLServerSocket)object2).getEnabledProtocols())) != null) {
                    ((SSLServerSocket)object2).setEnabledProtocols(stringArray);
                }
                object4 = object2;
            } else {
                object4 = new ServerSocket(this.port);
            }
            while (true) {
                object3 = ((ServerSocket)object4).accept();
                object2 = null;
                if (this.networkApplicationInformation != null) {
                    object2 = this.networkApplicationInformation.getApplicationEntityMap();
                }
                if (object2 == null) {
                    object2 = new ApplicationEntityMap();
                }
                if ((object = ((ServerSocket)object4).getInetAddress()) != null && ((TreeMap)object2).get(this.calledAETitle) == null) {
                    ((ApplicationEntityMap)object2).put(this.calledAETitle, new PresentationAddress(((InetAddress)object).getHostAddress(), this.port), "STUDYROOT", null);
                }
                if (this.debugLevel > 1) {
                    System.err.println("StorageSOPClassSCPDispatcher:run(): applicationEntityMap = " + object2);
                }
                try {
                    new Thread(new StorageSOPClassSCP((Socket)object3, this.calledAETitle, this.ourMaximumLengthReceived, this.socketReceiveBufferSize, this.socketSendBufferSize, this.savedImagesFolder, this.storedFilePathStrategy, this.receivedObjectHandler, this.queryResponseGeneratorFactory, this.retrieveResponseGeneratorFactory, (ApplicationEntityMap)object2, this.debugLevel)).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return;
        }
    }

    public static void main(String[] stringArray) {
        try {
            StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher = null;
            File file = null;
            if (stringArray.length == 0) {
                Object object;
                Properties properties = new Properties();
                try {
                    object = ".com.pixelmed.network.StorageSOPClassSCPDispatcher.properties";
                    properties.load(new FileInputStream(FileUtilities.makePathToFileInUsersHomeDirectory((String)object)));
                }
                catch (IOException iOException) {
                    properties.put("Dicom.ListeningPort", "11112");
                    properties.put("Dicom.CalledAETitle", "STORESCP");
                    properties.put("Dicom.CallingAETitle", "STORESCP");
                    properties.put("Dicom.PrimaryDeviceType", "ARCHIVE");
                    properties.put("Dicom.StorageSCPDebugLevel", "0");
                    properties.put("Network.DynamicConfigurationDebugLevel", "0");
                    properties.put("Application.SavedImagesFolderName", "tmp");
                }
                object = new NetworkApplicationProperties(properties);
                int n = ((NetworkApplicationProperties)object).getListeningPort();
                String string = ((NetworkApplicationProperties)object).getCalledAETitle();
                int n2 = ((NetworkApplicationProperties)object).getStorageSCPDebugLevel();
                NetworkApplicationInformationFederated networkApplicationInformationFederated = new NetworkApplicationInformationFederated();
                networkApplicationInformationFederated.startupAllKnownSourcesAndRegister((NetworkApplicationProperties)object);
                file = new DatabaseApplicationProperties(properties).getSavedImagesFolderCreatingItIfNecessary();
                System.err.println("StorageSOPClassSCPDispatcher.main(): listening on port " + n + " AE " + string + " storing into " + file + " debugging level " + n2);
                storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, string, file, null, null, null, null, false, n2);
            } else if (stringArray.length == 4) {
                String string = stringArray[2];
                if (string != null && string.length() > 0) {
                    file = new File(string);
                }
                storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(Integer.parseInt(stringArray[0]), stringArray[1], file, null, null, null, null, false, Integer.parseInt(stringArray[3]));
            } else if (stringArray.length == 5) {
                String string = stringArray[2];
                if (string != null && string.length() > 0) {
                    file = new File(string);
                }
                storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(Integer.parseInt(stringArray[0]), stringArray[1], file, null, null, null, null, stringArray[3].toUpperCase().equals("SECURE"), Integer.parseInt(stringArray[4]));
            } else if (stringArray.length == 8) {
                String string = stringArray[5];
                if (string != null && string.length() > 0) {
                    file = new File(string);
                }
                storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(Integer.parseInt(stringArray[0]), stringArray[1], Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), file, null, null, null, null, stringArray[6].toUpperCase().equals("SECURE"), Integer.parseInt(stringArray[7]));
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.network.StorageSOPClassSCPDispatcher port AET [ maxpdusize recbufsize sendbufsize ] folder [SECURE] debuglevel");
            }
            new Thread(storageSOPClassSCPDispatcher).start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    private class DefaultReceivedObjectHandler
    extends ReceivedObjectHandler {
        private DefaultReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            System.err.println("StorageSOPClassSCPDispatcher.DefaultReceivedObjectHandler.sendReceivedObjectIndication() fileName: " + string + " from " + string3 + " in " + string2);
        }
    }
}

