/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.FileInputStream;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class TestAppMultiFrameCompare
extends ApplicationFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/TestAppMultiFrameCompare.java,v 1.8 2007/12/19 22:44:15 dclunie Exp $";
    double[][] distancesAlongNormal = new double[2][];
    EventContext[] eventContextOfSingleImagePanel;
    private OurFrameSelectionChangeListener ourFrameSelectionChangeListener;

    TestAppMultiFrameCompare() {
    }

    private static final int findClosestPositionMatch(double d, double[] dArray) {
        double d2 = 9.99999999E8;
        int n = -1;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = Math.abs(d - dArray[i]);
            if (!(d3 < d2)) continue;
            d2 = d3;
            n = i;
        }
        System.err.println("findClosestPositionMatch: source " + d + " target " + dArray[n] + " difference " + d2);
        return n;
    }

    void addInterleavedFrameSelectionListeners() {
        new OurFrameSelectionChangeListener(this.eventContextOfSingleImagePanel[0], this.eventContextOfSingleImagePanel[1]);
        new OurFrameSelectionChangeListener(this.eventContextOfSingleImagePanel[1], this.eventContextOfSingleImagePanel[0]);
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        TestAppMultiFrameCompare testAppMultiFrameCompare = new TestAppMultiFrameCompare();
        int n2 = 1;
        int n3 = 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(n2, n3));
        jPanel.setBackground(Color.black);
        testAppMultiFrameCompare.eventContextOfSingleImagePanel = new EventContext[2];
        for (int i = 0; i < 2; ++i) {
            try {
                object = new DicomInputStream(new FileInputStream(stringArray[i]));
                AttributeList attributeList = new AttributeList();
                attributeList.read((DicomInputStream)object);
                SourceImage sourceImage = new SourceImage(attributeList);
                GeometryOfVolumeFromAttributeList geometryOfVolumeFromAttributeList = new GeometryOfVolumeFromAttributeList(attributeList);
                testAppMultiFrameCompare.distancesAlongNormal[i] = geometryOfVolumeFromAttributeList.getDistanceAlongNormalFromOrigin();
                testAppMultiFrameCompare.eventContextOfSingleImagePanel[i] = new EventContext(Integer.toString(i));
                SingleImagePanel singleImagePanel = new SingleImagePanel(sourceImage, testAppMultiFrameCompare.eventContextOfSingleImagePanel[i]);
                singleImagePanel.setPreferredSize(new Dimension(sourceImage.getWidth(), sourceImage.getHeight()));
                jPanel.add(singleImagePanel);
                continue;
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        }
        testAppMultiFrameCompare.addInterleavedFrameSelectionListeners();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        object = testAppMultiFrameCompare.getContentPane();
        ((Container)object).setLayout(new GridLayout(1, 1));
        ((Container)object).add(jScrollPane);
        testAppMultiFrameCompare.pack();
        int n4 = jScrollPane.getHeight() + 24;
        if (n4 > 1024) {
            n4 = 1024;
        }
        if ((n = jScrollPane.getWidth() + 24) > 1280) {
            n = 1280;
        }
        testAppMultiFrameCompare.setSize(n, n4);
        testAppMultiFrameCompare.setVisible(true);
    }

    class OurFrameSelectionChangeListener
    extends SelfRegisteringListener {
        private int whichSource;
        private int whichTarget;
        private EventContext targetEventContext;
        private int lastIndex;

        public OurFrameSelectionChangeListener(EventContext eventContext, EventContext eventContext2) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
            this.lastIndex = -1;
            if (eventContext == TestAppMultiFrameCompare.this.eventContextOfSingleImagePanel[0]) {
                this.whichSource = 0;
                this.whichTarget = 1;
            } else {
                this.whichSource = 1;
                this.whichTarget = 0;
            }
            this.targetEventContext = eventContext2;
        }

        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            int n = frameSelectionChangeEvent.getIndex();
            System.err.println("source slice index " + n);
            if (n != this.lastIndex) {
                this.lastIndex = n;
                double d = TestAppMultiFrameCompare.this.distancesAlongNormal[this.whichSource][n];
                System.err.println("source slice geometry distance cached " + d);
                int n2 = TestAppMultiFrameCompare.findClosestPositionMatch(d, TestAppMultiFrameCompare.this.distancesAlongNormal[this.whichTarget]);
                System.err.println("target slice match index " + n2);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(this.targetEventContext, n2));
            }
        }
    }
}

