/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CopyStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/CopyStream.java,v 1.8 2006/08/15 19:50:19 dclunie Exp $";
    private static final int readBufferSize = 32768;

    private CopyStream() {
    }

    public static void skipInsistently(InputStream inputStream, long l) throws IOException {
        long l2;
        for (long i = l; i > 0L; i -= l2) {
            l2 = inputStream.skip(i);
            if (l2 > 0L) continue;
            throw new IOException("skip failed with " + i + " bytes remaining to be skipped, wanted " + l);
        }
    }

    public static final void copyByteSwapped(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        assert (l % 2L == 0L);
        byte[] byArray = new byte[32768];
        while (l > 1L) {
            int n;
            int n2;
            int n3 = n2 = l > 32768L ? 32768 : (int)l;
            assert (n2 % 2 == 0);
            int n4 = 0;
            while (n2 > 0) {
                n = inputStream.read(byArray, n4, n2);
                n4 += n;
                n2 -= n;
            }
            if (n4 <= 0) continue;
            for (n = 0; n < n4 - 1; n += 2) {
                byte by = byArray[n];
                byArray[n] = byArray[n + 1];
                byArray[n + 1] = by;
            }
            outputStream.write(byArray, 0, n4);
            l -= (long)n4;
        }
        outputStream.flush();
    }

    public static final void copy(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[32768];
        while (l > 0L) {
            int n = l > 32768L ? 32768 : (int)l;
            int n2 = inputStream.read(byArray, 0, n);
            if (n2 <= 0) continue;
            outputStream.write(byArray, 0, n2);
            l -= (long)n2;
        }
        outputStream.flush();
    }

    public static final void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[32768];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static final void copy(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        CopyStream.copy(bufferedInputStream, bufferedOutputStream);
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    public static final void copy(String string, String string2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        CopyStream.copy(bufferedInputStream, bufferedOutputStream);
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }
}

