/*
 * Decompiled with CFR 0.152.
 */
package guilib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class AppFrame
extends JFrame {
    protected int width;
    protected int height;
    protected JComponent view;
    protected JLabel statusBar;
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu helpMenu;
    private static final long serialVersionUID = 352667154793350204L;

    public AppFrame() {
        this(300, 400, null);
    }

    public AppFrame(int width, int height) {
        this(width, height, null);
    }

    public AppFrame(int width, int height, FontUIResource fur) {
        super("");
        this.width = width;
        this.height = height;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AppFrame.this.onClose();
                System.exit(0);
            }
        });
        if (fur != null) {
            AppFrame.setUIFont(fur);
        }
        this.initFrame();
    }

    public void startup() {
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuBar.add(this.createHelpMenu());
        this.pack();
        this.setSize(this.width, this.height);
        this.setVisible(true);
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public JLabel getStatusBar() {
        return this.statusBar;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    protected void initFrame() {
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar = new JLabel("");
        this.statusBar.setMinimumSize(new Dimension(0, 15));
        this.statusBar.setMaximumSize(new Dimension(0, 15));
        this.statusBar.setPreferredSize(new Dimension(0, 15));
        statusPanel.add(this.statusBar);
        this.getContentPane().add((Component)statusPanel, "South");
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.createFileMenu());
    }

    public void addMenu(JMenu newMenu) {
        this.menuBar.add(newMenu);
    }

    protected JMenu createFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        JMenuItem item = new JMenuItem("Load", 76);
        this.fileMenu.add(item);
        item.addActionListener(new OpenAdapter());
        item = new JMenuItem("Save", 83);
        this.fileMenu.add(item);
        item.addActionListener(new SaveAdapter());
        item = new JMenuItem("Save As", 65);
        this.fileMenu.add(item);
        item.addActionListener(new SaveAsAdapter());
        this.fileMenu.addSeparator();
        item = new JMenuItem("Quit", 81);
        this.fileMenu.add(item);
        item.addActionListener(new CloseAdapter());
        return this.fileMenu;
    }

    protected JMenu createHelpMenu() {
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        JMenuItem item = new JMenuItem("About", 65);
        this.helpMenu.add(item);
        item.addActionListener(new AboutAdapter());
        return this.helpMenu;
    }

    public void addView(JComponent view) {
        this.view = view;
        this.getContentPane().add(this.view);
    }

    public void onClose() {
        this.dispose();
        System.exit(0);
    }

    public void onOpen() {
    }

    public void onSave() {
    }

    public void onSaveAs() {
    }

    public void onPrint() {
    }

    public void onAbout() {
        String message = this.getTitle() != null ? this.getTitle() : "Your application name here";
        JOptionPane.showMessageDialog(this, message, "About", -1);
    }

    public static void setUIFont(FontUIResource fur) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, fur);
        }
    }

    public static void main(String[] args) {
        AppFrame appFrame = new AppFrame(300, 400);
        appFrame.startup();
    }

    class AboutAdapter
    implements ActionListener {
        AboutAdapter() {
        }

        public void actionPerformed(ActionEvent e) {
            AppFrame.this.onAbout();
        }
    }

    class SaveAsAdapter
    implements ActionListener {
        SaveAsAdapter() {
        }

        public void actionPerformed(ActionEvent e) {
            AppFrame.this.onSaveAs();
        }
    }

    class SaveAdapter
    implements ActionListener {
        SaveAdapter() {
        }

        public void actionPerformed(ActionEvent e) {
            AppFrame.this.onSave();
        }
    }

    class CloseAdapter
    implements ActionListener {
        CloseAdapter() {
        }

        public void actionPerformed(ActionEvent e) {
            AppFrame.this.onClose();
        }
    }

    class OpenAdapter
    implements ActionListener {
        OpenAdapter() {
        }

        public void actionPerformed(ActionEvent e) {
            AppFrame.this.onOpen();
        }
    }
}

