/*
 * Decompiled with CFR 0.152.
 */
package guilib.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class GenUtils {
    protected GenUtils() {
    }

    public static String getUniqueFile(String filename) {
        File f = new File(filename);
        int count = 0;
        String newFilename = filename;
        while (f.exists()) {
            newFilename = filename + "." + ++count;
            f = new File(newFilename);
        }
        return newFilename;
    }

    public static void serialize(Object o, String filename) throws IOException {
        GenUtils.serialize(o, filename, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Object o, String filename, boolean doBackup) throws IOException {
        ObjectOutputStream out = null;
        try {
            File f;
            boolean ok;
            String newFilename;
            if (doBackup && !(newFilename = GenUtils.getUniqueFile(filename)).equals(filename) && !(ok = (f = new File(filename)).renameTo(new File(newFilename)))) {
                System.err.println("Cannot rename " + filename + " to " + newFilename + "!");
            }
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 4096));
            out.writeObject(o);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception x) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(String filename) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            Object o;
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filename), 4096));
            Object object = o = in.readObject();
            return object;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception x) {}
            }
        }
    }
}

