/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.collections.set.ListOrderedSet;
import org.dbunit.util.CollectionsHelper;
import org.dbunit.util.search.IEdge;
import org.dbunit.util.search.ISearchAlgorithm;
import org.dbunit.util.search.ISearchCallback;
import org.dbunit.util.search.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepthFirstSearch
implements ISearchAlgorithm {
    private Set scannedNodes;
    private Set reverseScannedNodes;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set result;
    private Set nodesFrom;
    private ISearchCallback callback;
    private boolean searching = false;

    public Set search(Object[] nodesFrom, ISearchCallback callback) throws SearchException {
        this.logger.debug("search(nodesFrom=" + nodesFrom + ", callback=" + callback + ") - start");
        return this.search(CollectionsHelper.objectsToSet(nodesFrom), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set search(Set nodesFrom, ISearchCallback callback) throws SearchException {
        boolean nodesFromChanged;
        boolean resultChanged;
        boolean sizesDontMatch;
        this.logger.debug("search(nodesFrom=" + nodesFrom + ", callback=" + callback + ") - start");
        DepthFirstSearch depthFirstSearch = this;
        synchronized (depthFirstSearch) {
            if (this.searching) {
                throw new IllegalStateException("already searching/searched");
            }
            this.searching = true;
        }
        this.result = new ListOrderedSet();
        this.callback = callback;
        this.nodesFrom = new ListOrderedSet();
        int sizeNodesFromBefore = 0;
        int sizeResultBefore = 0;
        boolean keepSearching = true;
        this.scannedNodes = new HashSet();
        this.reverseScannedNodes = new HashSet();
        this.scannedNodes = new HashSet();
        do {
            Object node;
            Iterator iterator = nodesFrom.iterator();
            while (iterator.hasNext()) {
                node = iterator.next();
                this.reverseSearch(node);
            }
            iterator = this.nodesFrom.iterator();
            while (iterator.hasNext()) {
                node = iterator.next();
                this.search(node);
            }
            nodesFrom = new HashSet(this.result);
            sizesDontMatch = this.result.size() != this.nodesFrom.size();
            resultChanged = this.result.size() != sizeResultBefore;
            nodesFromChanged = this.nodesFrom.size() != sizeNodesFromBefore;
            sizeNodesFromBefore = this.nodesFrom.size();
            sizeResultBefore = this.result.size();
        } while (keepSearching = sizesDontMatch && (resultChanged || nodesFromChanged));
        return this.result;
    }

    private boolean search(Object node) throws SearchException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("search:" + node);
        }
        if (this.scannedNodes.contains(node)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("already searched; returning true");
            }
            return true;
        }
        if (!this.callback.searchNode(node)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Callback handler blocked search for node " + node);
            }
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Pushing " + node);
        }
        this.scannedNodes.add(node);
        SortedSet edges = this.callback.getEdges(node);
        if (edges != null) {
            Iterator iterator = edges.iterator();
            while (iterator.hasNext()) {
                IEdge edge = (IEdge)iterator.next();
                Object toNode = edge.getTo();
                this.search(toNode);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Adding node " + node + " to the final result");
        }
        this.callback.nodeAdded(node);
        this.result.add(node);
        return false;
    }

    private boolean reverseSearch(Object node) throws SearchException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("reverseSearch:" + node);
        }
        if (this.reverseScannedNodes.contains(node)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("already searched; returning true");
            }
            return true;
        }
        if (!this.callback.searchNode(node)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("callback handler blocked reverse search for node " + node);
            }
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Pushing (reverse) " + node);
        }
        this.reverseScannedNodes.add(node);
        SortedSet edges = this.callback.getEdges(node);
        if (edges != null) {
            Iterator iterator = edges.iterator();
            while (iterator.hasNext()) {
                IEdge edge = (IEdge)iterator.next();
                Object toNode = edge.getTo();
                if (!toNode.equals(node)) continue;
                Object fromNode = edge.getFrom();
                this.reverseSearch(fromNode);
            }
        }
        this.nodesFrom.add(node);
        return false;
    }
}

