/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitor;
import com.jamonapi.ActiveStatsMonitor;
import com.jamonapi.LastAccessMonitor;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactory;
import com.jamonapi.TestClassPerformance;
import com.jamonapi.TimeStatsDistMonitor;
import com.jamonapi.TimeStatsMonitor;
import com.jamonapi.TimingMonitor;

public class TestClass
implements Runnable {
    static final int THREADS = 250;
    private int threadNum;
    long lobits;
    long hibits;
    AccumulateMonitor mon;

    protected TestClass() {
    }

    public TestClass(int threadNum, long lobits, long hibits, AccumulateMonitor mon) {
        this.threadNum = threadNum;
        this.lobits = lobits;
        this.hibits = hibits;
        this.mon = mon;
    }

    private static void log(Object obj) {
        System.out.println("It took " + obj);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("***** Class unit tests");
        System.out.println("\nAccumulateMonitor.main() test code - all numbers should be equal");
        AccumulateMonitor.main(null);
        System.out.println("\nTimeStatsMonitor.main()");
        TimeStatsMonitor.main(null);
        System.out.println("\nTimeStatsDistMonitor.main()");
        TimeStatsDistMonitor.main(null);
        System.out.println("\nActiveStatsMonitor.main()");
        ActiveStatsMonitor.main(null);
        System.out.println("\nTimingMonitor.main() test code - all numbers should be equal");
        TimingMonitor.main(null);
        System.out.println("\nLastAccessMonitor.main()");
        LastAccessMonitor.main(null);
        System.out.println("\nMonitorFactory.main()");
        MonitorFactory.main(null);
        TestClass test = new TestClass();
        System.out.println("\n***** MonitorFactory.getData():");
        Monitor m1 = MonitorFactory.start("pages.purchase.test");
        Monitor m2 = MonitorFactory.start("steve.souza.test");
        Thread.sleep(350L);
        m1.stop();
        Thread.sleep(650L);
        m2.stop();
        String[][] rows = MonitorFactory.getRootMonitor().getData();
        int i = 0;
        while (i < rows.length) {
            String rowData = "row" + i + "=[";
            int j = 0;
            while (j < rows[0].length) {
                rowData = String.valueOf(rowData) + rows[i][j] + ", ";
                ++j;
            }
            System.out.println(String.valueOf(rowData) + "]");
            ++i;
        }
        System.out.println("\ncomposite tostring()=" + MonitorFactory.getRootMonitor());
        System.out.println("pages composite tostring()=" + MonitorFactory.getComposite("pages"));
        System.out.println("\n***** Multi-threaded test");
        long LOBIT = 1L;
        long HIBIT = 0x10000000L;
        Monitor timingMon = MonitorFactory.start();
        ThreadGroup threadGroup = new ThreadGroup("threadGroup");
        AccumulateMonitor mon1 = new AccumulateMonitor();
        int i2 = 0;
        while (i2 < 250) {
            new Thread(threadGroup, new TestClass(i2, LOBIT, LOBIT, mon1)).start();
            ++i2;
        }
        AccumulateMonitor mon2 = new AccumulateMonitor();
        int i3 = 0;
        while (i3 < 250) {
            new Thread(threadGroup, new TestClass(i3, HIBIT, HIBIT, mon2)).start();
            ++i3;
        }
        AccumulateMonitor mon3 = new AccumulateMonitor();
        int i4 = 0;
        while (i4 < 250) {
            new Thread(threadGroup, new TestClass(i4, LOBIT, HIBIT, mon3)).start();
            ++i4;
        }
        while (threadGroup.activeCount() != 0) {
        }
        System.out.println("Threads have finished processing. It took " + timingMon.stop());
        System.out.println("250=" + mon1);
        System.out.println(String.valueOf(250L * HIBIT) + "=" + mon2);
        System.out.println(String.valueOf(125L * LOBIT + 125L * HIBIT) + "=" + mon3);
        Monitor mon4 = MonitorFactory.start("TimingMonitorThreadTest").stop();
        threadGroup = new ThreadGroup("timingMonitorThreads");
        int i5 = 0;
        while (i5 < 250) {
            new Thread(threadGroup, new TimingMonitorThreads(mon4)).start();
            ++i5;
        }
        while (threadGroup.activeCount() != 0) {
        }
        System.out.println("hits should be 251= " + mon4.stop());
        System.out.println("\n***** MonitorComposite.getHeader():");
        String[] header = MonitorComposite.getHeader();
        int i6 = 0;
        while (i6 < header.length) {
            System.out.println(header[i6]);
            ++i6;
        }
        System.out.println("\n***** MonitorFactory.getReport() 1:");
        System.out.println(MonitorFactory.getReport());
        System.out.println("\n***** MonitorFactory.getReport() 2 (after setting admin page to 'JAMon/JAMonAdmin.jsp':");
        MonitorFactory.setJAMonAdminPage("JAMon/JAMonAdmin.jsp");
        System.out.println(MonitorFactory.getReport());
        TestClassPerformance.main(args);
    }

    public void run() {
        try {
            long incr = 0L;
            if (this.threadNum % 2 == 0) {
                incr = this.lobits;
                Thread.sleep(10L);
            } else {
                incr = this.hibits;
            }
            this.mon.increase(incr);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static class TimingMonitorThreads
    implements Runnable {
        Monitor mon;

        TimingMonitorThreads(Monitor mon) {
            this.mon = mon;
        }

        public void run() {
            this.mon.start().stop();
        }
    }
}

