/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.http;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.RemoteRandomAccessFile;
import edu.sdsc.grid.io.http.HTTPFile;
import edu.sdsc.grid.io.http.HTTPFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;

public class HTTPRandomAccessFile
extends RemoteRandomAccessFile {
    private InputStream in;
    private OutputStream out;
    private long filePointer = 0L;
    private long length;
    private HTTPFile httpFile;

    public HTTPRandomAccessFile(HTTPFileSystem hTTPFileSystem, String string, String string2) throws IOException {
        this(new HTTPFile(hTTPFileSystem, string), string2);
    }

    public HTTPRandomAccessFile(HTTPFile hTTPFile, String string) throws IOException {
        super(hTTPFile, string);
        this.httpFile = hTTPFile;
    }

    protected void open(GeneralFile generalFile) throws IOException {
        this.close();
        if (this.in == null) {
            this.rwCheck(generalFile, this.mode);
        }
        URLConnection uRLConnection = ((HTTPFile)generalFile).httpFileSystem.getNewConn();
        if (this.rw > 0) {
            uRLConnection.setDoOutput(true);
            this.out = uRLConnection.getOutputStream();
        }
        this.in = uRLConnection.getInputStream();
        this.length = this.in.available();
    }

    protected int readBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.filePointer += (long)n3;
        }
        return n3;
    }

    protected void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long l) throws IOException {
        this.seek(l, 1);
    }

    public void seek(long l, int n) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 1: {
                this.filePointer += this.in.skip(l + this.getFilePointer());
                break;
            }
            case 2: {
                this.filePointer += this.in.skip(l + (long)this.in.available());
                break;
            }
            default: {
                if (l < this.filePointer) {
                    this.open(this.httpFile);
                    this.in.skip(l);
                    break;
                }
                this.in.skip(l - this.getFilePointer());
            }
        }
    }

    public long length() throws IOException {
        return this.length;
    }

    public void setLength(long l) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }
}

