/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.io.IOException;
import java.io.Writer;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaAnnotation;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HandlerConfigGenerator
extends AbstractJAXWSGenerator {
    private static final String HANDLER_CHAIN_NAME = "";
    private JavaInterface intf;
    private JavaAnnotation handlerChainAnnotation;

    public HandlerConfigGenerator() {
        this.name = "handler.generator";
    }

    public JavaAnnotation getHandlerAnnotation() {
        return this.handlerChainAnnotation;
    }

    public boolean passthrough() {
        return false;
    }

    public void setJavaInterface(JavaInterface javaInterface) {
        this.intf = javaInterface;
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        if (this.passthrough()) {
            return;
        }
        Element e = this.intf.getHandlerChains();
        NodeList nl = e.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chain");
        if (nl.getLength() > 0) {
            String fName = ProcessorUtil.getHandlerConfigFileName(this.intf.getName());
            this.handlerChainAnnotation = new JavaAnnotation("HandlerChain");
            this.handlerChainAnnotation.addArgument("name", HANDLER_CHAIN_NAME);
            this.handlerChainAnnotation.addArgument("file", fName + ".xml");
            this.generateHandlerChainFile(e, this.parseOutputName(this.intf.getPackageName(), fName, ".xml"));
        }
    }

    private void generateHandlerChainFile(Element hChains, Writer writer) throws ToolException {
        try {
            XMLUtils.generateXMLFile(hChains, writer);
            writer.close();
        }
        catch (IOException ex) {
            throw new ToolException(ex);
        }
    }
}

