/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.NoSuchKeyException;
import com.ice.jni.registry.NoSuchValueException;
import com.ice.jni.registry.RegBinaryValue;
import com.ice.jni.registry.RegDWordValue;
import com.ice.jni.registry.RegMultiStringValue;
import com.ice.jni.registry.RegStringValue;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import com.ice.text.HexNumberFormat;
import com.ice.util.HexDump;
import com.ice.util.StringUtilities;
import com.memoire.vainstall.VAGlobals;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class Registry {
    public static RegistryKey HKEY_CLASSES_ROOT;
    public static RegistryKey HKEY_CURRENT_USER;
    public static RegistryKey HKEY_LOCAL_MACHINE;
    public static RegistryKey HKEY_USERS;
    public static RegistryKey HKEY_PERFORMANCE_DATA;
    public static RegistryKey HKEY_CURRENT_CONFIG;
    public static RegistryKey HKEY_DYN_DATA;
    private static RegistryKey HKEY_ICE_TESTKEY;
    private static String[] preDefines;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_INVALID_HANDLE = 6;
    public static final int ERROR_INVALID_PARAMETER = 87;
    public static final int ERROR_CALL_NOT_IMPLEMENTED = 120;
    public static final int ERROR_INSUFFICIENT_BUFFER = 122;
    public static final int ERROR_LOCK_FAILED = 167;
    public static final int ERROR_TRANSFER_TOO_LONG = 222;
    public static final int ERROR_MORE_DATA = 234;
    public static final int ERROR_NO_MORE_ITEMS = 259;
    public static final int ERROR_BADDB = 1009;
    public static final int ERROR_BADKEY = 1010;
    public static final int ERROR_CANTOPEN = 1011;
    public static final int ERROR_CANTREAD = 1012;
    public static final int ERROR_CANTWRITE = 1013;
    public static final int ERROR_REGISTRY_RECOVERED = 1014;
    public static final int ERROR_REGISTRY_CORRUPT = 1015;
    public static final int ERROR_REGISTRY_IO_FAILED = 1016;
    public static final int ERROR_NOT_REGISTRY_FILE = 1017;
    public static final int ERROR_KEY_DELETED = 1018;
    private static String saveKey;
    private static Hashtable topLevelKeys;
    public boolean debugLevel;
    public static String dllFile;

    public static RegistryKey getTopLevelKey(String string) {
        return (RegistryKey)topLevelKeys.get(string);
    }

    public static RegistryKey openSubkey(RegistryKey registryKey, String string, int n) {
        RegistryKey registryKey2 = null;
        try {
            registryKey2 = registryKey.openSubKey(string, n);
        }
        catch (NoSuchKeyException noSuchKeyException) {
            registryKey2 = null;
        }
        catch (RegistryException registryException) {
            registryKey2 = null;
        }
        return registryKey2;
    }

    public static String getErrorMessage(int n) {
        switch (n) {
            case 0: {
                return "success";
            }
            case 2: {
                return "key or value not found";
            }
            case 5: {
                return "access denied";
            }
            case 6: {
                return "invalid handle";
            }
            case 87: {
                return "invalid parameter";
            }
            case 120: {
                return "call not implemented";
            }
            case 122: {
                return "insufficient buffer";
            }
            case 167: {
                return "lock failed";
            }
            case 222: {
                return "transfer was too long";
            }
            case 234: {
                return "more data buffer needed";
            }
            case 259: {
                return "no more items";
            }
            case 1009: {
                return "bad database";
            }
            case 1010: {
                return "bad key";
            }
            case 1011: {
                return "can not open";
            }
            case 1012: {
                return "can not read";
            }
            case 1013: {
                return "can not write";
            }
            case 1014: {
                return "registry recovered";
            }
            case 1015: {
                return "registry corrupt";
            }
            case 1016: {
                return "registry IO failed";
            }
            case 1017: {
                return "not a registry file";
            }
            case 1018: {
                return "key has been deleted";
            }
        }
        return "errCode=" + n;
    }

    public static void exportRegistryKey(String string, RegistryKey registryKey, boolean bl) throws IOException, NoSuchKeyException, RegistryException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        printWriter.println("REGEDIT4");
        printWriter.println("");
        registryKey.export(printWriter, bl);
        printWriter.flush();
        printWriter.close();
    }

    public static void main(String[] stringArray) {
        preDefines = new String[10];
        Registry.preDefines[0] = "HKLM\\System\\CurrentControlSet\\control";
        Registry.preDefines[1] = "HKLM\\Software";
        Registry.preDefines[2] = "HKLM\\Software\\Miscrosoft";
        Registry.preDefines[3] = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion";
        Registry.preDefines[4] = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\ProfileList";
        Registry.preDefines[5] = "HKCU\\Software";
        Registry.preDefines[6] = "HKCU\\Software\\Microsoft";
        Registry.preDefines[7] = "HKCU\\AppEvents";
        Registry.preDefines[8] = "HKCU\\AppEvents\\Schemes";
        Registry.preDefines[9] = "HKCU\\AppEvents\\Schemes";
        try {
            HKEY_ICE_TESTKEY = HKEY_CURRENT_USER.openSubKey("Software\\ICE Engineering\\test");
        }
        catch (NoSuchKeyException noSuchKeyException) {
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        if (stringArray.length > 0) {
            Registry.subMain(stringArray);
        } else {
            String string = null;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                String[] stringArray2;
                String string2;
                System.out.print("command: ");
                System.out.flush();
                try {
                    string2 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    string2 = null;
                }
                if (string2 == null || string2.length() == 0) break;
                if (string2.equalsIgnoreCase("help")) {
                    Registry.usage(null);
                    continue;
                }
                if (string2.equals("!!") && string != null) {
                    stringArray2 = StringUtilities.parseArgumentString(string);
                } else {
                    stringArray2 = StringUtilities.parseArgumentString(string2);
                    string = string2;
                }
                Registry.subMain(stringArray2);
            }
        }
    }

    public static void usage(String string) {
        if (string != null) {
            System.err.println(string);
        }
        System.err.println("keys regKey -- print the key names");
        System.err.println("values regKey -- print the value names");
        System.err.println("data regKey -- print the key's data");
        System.err.println("string regKey -- print REG_SZ key's string");
        System.err.println("setbin regKey valName binaryString -- set REG_BINARY");
        System.err.println("setdw regKey valName int -- set REG_DWORD");
        System.err.println("setstr regKey valName string -- set REG_SZ");
        System.err.println("setmulti regKey valName semiColonString -- set REG_MULTI_SZ");
        System.err.println("delkey regKey subKey -- delete key 'subKey' of regKey");
        System.err.println("delval regKey valueName -- delete value 'valueName' of regKey");
        System.err.println("export regKey fileName -- export registry key to fileName");
        System.err.println("expand regKey valueName -- expand string value");
        System.err.println("");
        System.err.println("!! -- repeats last command");
        System.err.println("$$ -- re-uses previous keyname");
        System.err.println("Predefined Key Prefixes: (e.g. $0-9)");
        for (int i = 0; i < preDefines.length; ++i) {
            System.err.println("   $" + i + "=" + preDefines[i]);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void subMain(String[] stringArray) {
        void var8_16;
        void var8_12;
        int n;
        void var8_10;
        RegistryKey registryKey = null;
        boolean bl = false;
        String string = null;
        String string2 = null;
        if (stringArray.length < 1 || stringArray[0].equals("help")) {
            Registry.usage(null);
            return;
        }
        if (stringArray.length < 2) {
            Registry.usage(null);
            return;
        }
        String string3 = stringArray[1];
        if (saveKey != null && string3.equals("$$")) {
            String string4 = saveKey;
        } else if (string3.equals("@@")) {
            String string5 = "HKCU\\Software\\ICE Engineering\\test";
        } else {
            char c = string3.charAt(0);
            char c2 = string3.charAt(1);
            if (c == '$' && c2 >= '0' && c2 <= '9') {
                int n2 = c2 - 48;
                if (preDefines[n2] == null) {
                    System.err.println("Predefine '" + string3 + "' not defined.");
                    return;
                }
                if (string3.length() < 3) {
                    String string6 = preDefines[n2];
                } else {
                    String string7 = preDefines[n2] + string3.substring(2);
                }
            } else {
                saveKey = stringArray[1];
            }
        }
        if (var8_10.startsWith("\\\\")) {
            bl = true;
            n = var8_10.indexOf(92, 2);
            string2 = var8_10.substring(2, n);
            String string8 = var8_10.substring(n + 1);
        }
        if ((n = var8_12.indexOf(92)) < 0) {
            string = var8_12;
            Object var8_13 = null;
        } else {
            if (n < 4) {
                System.err.println("Invalid key '" + (String)var8_12 + "', top level key name too short.");
                return;
            }
            string = var8_12.substring(0, n);
            if (n + 1 >= var8_12.length()) {
                Object var8_14 = null;
            } else {
                String string9 = var8_12.substring(n + 1);
            }
        }
        registryKey = Registry.getTopLevelKey(string);
        if (registryKey == null) {
            System.err.println("ERROR, toplevel key '" + string + "' not resolved!");
            return;
        }
        if (bl) {
            System.err.println("REMOTE Key host='" + string2 + "'");
            RegistryKey registryKey2 = null;
            try {
                registryKey2 = registryKey.connectRegistry(string2);
            }
            catch (NoSuchKeyException noSuchKeyException) {
                System.err.println("ERROR No such key connecting to '" + string2 + "', " + noSuchKeyException.getMessage());
                return;
            }
            catch (RegistryException registryException) {
                System.err.println("ERROR errCode=" + registryException.getErrorCode() + "' connecting to '" + string2 + "', " + registryException.getMessage());
                return;
            }
            if (registryKey2 != null) {
                registryKey = registryKey2;
            }
        }
        if (stringArray[0].equalsIgnoreCase("create")) {
            Registry.createCommand(registryKey, (String)var8_16);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("setbin")) {
            Registry.setBinaryCommand(registryKey, (String)var8_16, stringArray[2], stringArray[3]);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("setdw")) {
            Registry.setBinaryCommand(registryKey, (String)var8_16, stringArray[2], stringArray[3]);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("setstr")) {
            Registry.setStringCommand(registryKey, (String)var8_16, stringArray[2], stringArray[3]);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("setmulti")) {
            Registry.setMultiStringCommand(registryKey, (String)var8_16, stringArray[2], stringArray[3]);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("keys")) {
            Registry.listKeysCommand(registryKey, (String)var8_16);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("values")) {
            Registry.listValuesCommand(registryKey, (String)var8_16);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("delkey")) {
            Registry.deleteKeyCommand(registryKey, (String)var8_16, stringArray[2]);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("delval")) {
            Registry.deleteValueCommand(registryKey, (String)var8_16, stringArray[2]);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("data")) {
            Registry.getDataCommand(registryKey, (String)var8_16, stringArray[2]);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("string")) {
            Registry.getStringCommand(registryKey, (String)var8_16, stringArray[2]);
            return;
        }
        if (stringArray[0].equalsIgnoreCase("export")) {
            Registry.exportKeyCommand(registryKey, (String)var8_16, stringArray[2]);
            return;
        }
        if (!stringArray[0].equalsIgnoreCase("expand")) return;
        Registry.expandStringCommand(registryKey, (String)var8_16, stringArray[2]);
    }

    private static void exportKeyCommand(RegistryKey registryKey, String string, String string2) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 1);
        if (registryKey2 == null) {
            return;
        }
        try {
            Registry.exportRegistryKey(string2, registryKey2, true);
        }
        catch (IOException iOException) {
            System.err.println("IO Exception: '" + iOException.getMessage() + "'");
        }
        catch (NoSuchKeyException noSuchKeyException) {
            System.err.println("Error, encountered non-existent key during export.");
        }
        catch (RegistryException registryException) {
            System.err.println("ERROR registry error=" + registryException.getErrorCode() + ", " + registryException.getMessage());
        }
    }

    private static void getDataCommand(RegistryKey registryKey, String string, String string2) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 1);
        if (registryKey2 == null) {
            return;
        }
        RegistryValue registryValue = null;
        try {
            registryValue = registryKey2.getValue(string2);
        }
        catch (NoSuchValueException noSuchValueException) {
            System.err.println("Value '" + string2 + "' does not exist.");
            return;
        }
        catch (RegistryException registryException) {
            System.err.println("ERROR registry error=" + registryException.getErrorCode() + ", " + registryException.getMessage());
            return;
        }
        System.err.println("Value '" + string2 + "' is " + registryValue.toString());
        if (registryValue instanceof RegStringValue) {
            RegStringValue regStringValue = (RegStringValue)registryValue;
            System.err.println("REG_SZ '" + regStringValue.getData() + "'");
        } else if (registryValue instanceof RegMultiStringValue) {
            RegMultiStringValue regMultiStringValue = (RegMultiStringValue)registryValue;
            String[] stringArray = regMultiStringValue.getData();
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.println("REG_MULTI_SZ[" + i + "] '" + stringArray[i] + "'");
            }
        } else if (registryValue instanceof RegDWordValue) {
            RegDWordValue regDWordValue = (RegDWordValue)registryValue;
            HexNumberFormat hexNumberFormat = new HexNumberFormat("XXXXXXXX");
            System.err.println("REG_DWORD" + (5 == regDWordValue.getType() ? "_BIG_ENDIAN" : "") + " '" + regDWordValue.getData() + "' [x" + hexNumberFormat.format(regDWordValue.getData()) + "]");
        } else {
            RegBinaryValue regBinaryValue = (RegBinaryValue)registryValue;
            HexDump.dumpHexData(System.err, "REG_BINARY '" + regBinaryValue.getName() + "'", regBinaryValue.getData(), regBinaryValue.getLength());
        }
    }

    private static void getStringCommand(RegistryKey registryKey, String string, String string2) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 1);
        if (registryKey2 == null) {
            return;
        }
        try {
            String string3 = registryKey2.getStringValue(string2);
            System.err.println("String Value " + string2 + "='" + string3 + "'");
        }
        catch (RegistryException registryException) {
            System.err.println("ERROR getting value '" + string2 + "', " + registryException.getMessage());
            return;
        }
    }

    private static void expandStringCommand(RegistryKey registryKey, String string, String string2) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 1);
        if (registryKey2 == null) {
            return;
        }
        try {
            String string3 = registryKey2.getStringValue(string2);
            System.err.println("String Value " + string2 + "='" + string3 + "'");
            string3 = RegistryKey.expandEnvStrings(string3);
            System.err.println("Expanded Value " + string2 + "='" + string3 + "'");
        }
        catch (RegistryException registryException) {
            System.err.println("ERROR getting value '" + string2 + "', " + registryException.getMessage());
            return;
        }
    }

    private static void deleteKeyCommand(RegistryKey registryKey, String string, String string2) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 2);
        if (registryKey2 == null) {
            return;
        }
        try {
            registryKey2.deleteSubKey(string2);
        }
        catch (NoSuchKeyException noSuchKeyException) {
            System.err.println("Key '" + string + "\\" + string2 + "' does not exist.");
            return;
        }
        catch (RegistryException registryException) {
            System.err.println("ERROR deleting key '" + string + "', " + registryException.getMessage());
            return;
        }
    }

    private static void deleteValueCommand(RegistryKey registryKey, String string, String string2) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 2);
        if (registryKey2 == null) {
            return;
        }
        try {
            registryKey2.deleteValue(string2);
        }
        catch (NoSuchValueException noSuchValueException) {
            System.err.println("Value '" + string2 + "' does not exist.");
            return;
        }
        catch (RegistryException registryException) {
            System.err.println("ERROR deleting value '" + string2 + "', " + registryException.getMessage());
            return;
        }
    }

    private static void listKeysCommand(RegistryKey registryKey, String string) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 1);
        if (registryKey2 == null) {
            return;
        }
        try {
            Enumeration enumeration = registryKey2.keyElements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                System.err.println("Subkey[" + n + "] = '" + string2 + "'");
                ++n;
            }
        }
        catch (RegistryException registryException) {
            System.err.println("ERROR getting key enumerator, " + registryException.getMessage());
            return;
        }
    }

    private static void listValuesCommand(RegistryKey registryKey, String string) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 1);
        if (registryKey2 == null) {
            return;
        }
        try {
            Enumeration enumeration = registryKey2.valueElements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                System.err.println("Value Name[" + n + "] = '" + string2 + "'");
                ++n;
            }
        }
        catch (RegistryException registryException) {
            System.err.println("ERROR getting value enumerator, " + registryException.getMessage());
            return;
        }
    }

    private static void setDWordCommand(RegistryKey registryKey, String string, String string2, String string3) {
        int n;
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 2);
        if (registryKey2 == null) {
            return;
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("ERROR bad int: '" + numberFormatException.getMessage() + "'");
            return;
        }
        RegDWordValue regDWordValue = new RegDWordValue(registryKey2, string2);
        regDWordValue.setData(n);
        Registry.setValue(registryKey2, regDWordValue);
    }

    private static void setMultiStringCommand(RegistryKey registryKey, String string, String string2, String string3) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 2);
        if (registryKey2 == null) {
            return;
        }
        String[] stringArray = StringUtilities.splitString(string3, ";");
        RegMultiStringValue regMultiStringValue = new RegMultiStringValue(registryKey2, string2, stringArray);
        Registry.setValue(registryKey2, regMultiStringValue);
    }

    private static void setStringCommand(RegistryKey registryKey, String string, String string2, String string3) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 2);
        if (registryKey2 == null) {
            return;
        }
        RegStringValue regStringValue = new RegStringValue(registryKey2, string2, string3);
        Registry.setValue(registryKey2, regStringValue);
    }

    private static void setBinaryCommand(RegistryKey registryKey, String string, String string2, String string3) {
        RegistryKey registryKey2 = Registry.openSubKeyVerbose(registryKey, string, 2);
        if (registryKey2 == null) {
            return;
        }
        byte[] byArray = string3.getBytes();
        RegBinaryValue regBinaryValue = new RegBinaryValue(registryKey2, string2, byArray);
        Registry.setValue(registryKey2, regBinaryValue);
    }

    private static void createCommand(RegistryKey registryKey, String string) {
        RegistryKey registryKey2;
        try {
            registryKey2 = registryKey.createSubKey(string, null, 2);
        }
        catch (RegistryException registryException) {
            registryKey2 = null;
            System.err.println("ERROR creating subKey: " + registryException.getMessage());
        }
        if (registryKey2 != null) {
            try {
                registryKey2.flushKey();
                registryKey2.closeKey();
            }
            catch (RegistryException registryException) {
                registryKey2 = null;
                System.err.println("ERROR flushing and closing key: " + registryException.getMessage());
            }
        }
        if (registryKey2 != null) {
            System.err.println("SUCCEEDED " + (registryKey2.wasCreated() ? "Creating" : "Opening via create") + " Key '" + string + "'");
        } else {
            System.err.println("FAILED Creating Key '" + string + "'");
        }
    }

    private static RegistryKey openSubKeyVerbose(RegistryKey registryKey, String string, int n) {
        RegistryKey registryKey2 = null;
        try {
            registryKey2 = registryKey.openSubKey(string, n);
        }
        catch (NoSuchKeyException noSuchKeyException) {
            registryKey2 = null;
            System.err.println("Key '" + string + "' does not exist.");
        }
        catch (RegistryException registryException) {
            registryKey2 = null;
            System.err.println("ERROR registry error=" + registryException.getErrorCode() + ", " + registryException.getMessage());
        }
        return registryKey2;
    }

    private static void setValue(RegistryKey registryKey, RegistryValue registryValue) {
        try {
            registryKey.setValue(registryValue);
            registryKey.flushKey();
        }
        catch (RegistryException registryException) {
            System.err.println("ERROR setting MULTI_SZ value '" + registryValue.getName() + "', " + registryException.getMessage());
        }
    }

    public static void setDllFile(String string) {
        dllFile = string;
    }

    static {
        HKEY_ICE_TESTKEY = null;
        saveKey = null;
        topLevelKeys = null;
        dllFile = VAGlobals.JNI_DLL_FILE;
        if (dllFile == null) {
            System.err.println("ERROR temporary dll File is null");
        }
        try {
            System.load(dllFile);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("ERROR '" + dllFile + "' not found.\n\t" + unsatisfiedLinkError.getMessage());
        }
        catch (SecurityException securityException) {
            System.err.println("ERROR You do not have permission to load the DLL named '" + dllFile + "'.\n\t" + securityException.getMessage());
        }
        HKEY_CLASSES_ROOT = new RegistryKey(Integer.MIN_VALUE, "HKEY_CLASSES_ROOT");
        HKEY_CURRENT_USER = new RegistryKey(-2147483647, "HKEY_CURRENT_USER");
        HKEY_LOCAL_MACHINE = new RegistryKey(-2147483646, "HKEY_LOCAL_MACHINE");
        HKEY_USERS = new RegistryKey(-2147483645, "HKEY_USERS");
        HKEY_PERFORMANCE_DATA = new RegistryKey(-2147483644, "HKEY_PERFORMANCE_DATA");
        HKEY_CURRENT_CONFIG = new RegistryKey(-2147483643, "HKEY_CURRENT_CONFIG");
        HKEY_DYN_DATA = new RegistryKey(-2147483642, "HKEY_DYN_DATA");
        topLevelKeys = new Hashtable(16);
        topLevelKeys.put("HKCR", HKEY_CLASSES_ROOT);
        topLevelKeys.put("HKEY_CLASSES_ROOT", HKEY_CLASSES_ROOT);
        topLevelKeys.put("HKCU", HKEY_CURRENT_USER);
        topLevelKeys.put("HKEY_CURRENT_USER", HKEY_CURRENT_USER);
        topLevelKeys.put("HKLM", HKEY_LOCAL_MACHINE);
        topLevelKeys.put("HKEY_LOCAL_MACHINE", HKEY_LOCAL_MACHINE);
        topLevelKeys.put("HKU", HKEY_USERS);
        topLevelKeys.put("HKUS", HKEY_USERS);
        topLevelKeys.put("HKEY_USERS", HKEY_USERS);
        topLevelKeys.put("HKPD", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKEY_PERFORMANCE_DATA", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKCC", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKEY_CURRENT_CONFIG", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKDD", HKEY_PERFORMANCE_DATA);
        topLevelKeys.put("HKEY_DYN_DATA", HKEY_PERFORMANCE_DATA);
    }
}

