/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.NoSuchKeyException;
import com.ice.jni.registry.NoSuchValueException;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryValue;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class RegistryKey {
    public static final int ACCESS_DEFAULT = 0;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int ACCESS_EXECUTE = 3;
    public static final int ACCESS_ALL = 4;
    protected int hKey;
    protected String name;
    protected boolean created;

    public RegistryKey(int n, String string) {
        this.hKey = n;
        this.name = string;
        this.created = false;
    }

    public RegistryKey(int n, String string, boolean bl) {
        this.hKey = n;
        this.name = string;
        this.created = bl;
    }

    public void finalize() {
        if (this.name.indexOf("\\") > 0) {
            try {
                this.closeKey();
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
    }

    public String getName() {
        int n = this.name.lastIndexOf("\\");
        if (n < 0) {
            return this.name;
        }
        return this.name.substring(n + 1);
    }

    public String getFullName() {
        return this.name;
    }

    public boolean wasCreated() {
        return this.created;
    }

    public void setCreated(boolean bl) {
        this.created = bl;
    }

    public RegistryKey openSubKey(String string) throws NoSuchKeyException, RegistryException {
        return this.openSubKey(string, 1);
    }

    public RegistryKey createSubKey(String string, String string2) throws RegistryException {
        return this.openSubKey(string, 2);
    }

    public void setValue(RegistryValue registryValue) throws RegistryException {
        this.setValue(registryValue.getName(), registryValue);
    }

    public native RegistryKey openSubKey(String var1, int var2) throws NoSuchKeyException, RegistryException;

    public native RegistryKey connectRegistry(String var1) throws NoSuchKeyException, RegistryException;

    public native RegistryKey createSubKey(String var1, String var2, int var3) throws RegistryException;

    public native void closeKey() throws RegistryException;

    public native void deleteSubKey(String var1) throws NoSuchKeyException, RegistryException;

    public native void deleteValue(String var1) throws NoSuchValueException, RegistryException;

    public native void flushKey() throws RegistryException;

    public native void setValue(String var1, RegistryValue var2) throws RegistryException;

    public native RegistryValue getValue(String var1) throws NoSuchValueException, RegistryException;

    public native String getStringValue(String var1) throws NoSuchValueException, RegistryException;

    public native String getDefaultValue() throws NoSuchValueException, RegistryException;

    public native boolean hasDefaultValue() throws RegistryException;

    public native boolean hasOnlyDefaultValue() throws RegistryException;

    public native int getNumberSubkeys() throws RegistryException;

    public native int getMaxSubkeyLength() throws RegistryException;

    public native String regEnumKey(int var1) throws RegistryException;

    public native int getNumberValues() throws RegistryException;

    public native int getMaxValueDataLength() throws RegistryException;

    public native int getMaxValueNameLength() throws RegistryException;

    public native String regEnumValue(int var1) throws RegistryException;

    public native int incrDoubleWord(String var1) throws NoSuchValueException, RegistryException;

    public native int decrDoubleWord(String var1) throws NoSuchValueException, RegistryException;

    public static native String expandEnvStrings(String var0);

    public Enumeration keyElements() throws RegistryException {
        return new RegistryKeyEnumerator(this);
    }

    public Enumeration valueElements() throws RegistryException {
        return new RegistryValueEnumerator(this);
    }

    public void export(PrintWriter printWriter, boolean bl) throws NoSuchKeyException, RegistryException {
        Object object;
        String string;
        printWriter.println("[" + this.getFullName() + "]");
        Enumeration enumeration = this.valueElements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.getValue(string);
            ((RegistryValue)object).export(printWriter);
            ++n;
        }
        printWriter.println("");
        if (bl) {
            enumeration = this.keyElements();
            n = 0;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = this.openSubKey(string);
                ((RegistryKey)object).export(printWriter, bl);
                ((RegistryKey)object).closeKey();
                ++n;
            }
        }
    }

    class RegistryValueEnumerator
    implements Enumeration {
        RegistryKey key;
        int currIndex;
        int numValues;

        public RegistryValueEnumerator(RegistryKey registryKey2) throws RegistryException {
            this.key = registryKey2;
            this.currIndex = 0;
            this.numValues = registryKey2.getNumberValues();
        }

        public boolean hasMoreElements() {
            return this.currIndex < this.numValues;
        }

        public Object nextElement() {
            String string = null;
            try {
                string = this.key.regEnumValue(this.currIndex++);
            }
            catch (RegistryException registryException) {
                throw new NoSuchElementException(registryException.getMessage());
            }
            return string;
        }
    }

    class RegistryKeyEnumerator
    implements Enumeration {
        RegistryKey key;
        int currIndex;
        int numSubKeys;

        public RegistryKeyEnumerator(RegistryKey registryKey2) throws RegistryException {
            this.key = registryKey2;
            this.currIndex = 0;
            this.numSubKeys = registryKey2.getNumberSubkeys();
        }

        public boolean hasMoreElements() {
            return this.currIndex < this.numSubKeys;
        }

        public Object nextElement() {
            String string = null;
            try {
                string = this.key.regEnumKey(this.currIndex++);
            }
            catch (RegistryException registryException) {
                throw new NoSuchElementException(registryException.getMessage());
            }
            return string;
        }
    }
}

