/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import com.ice.util.HTTPUtilities;
import com.ice.util.StringUtilities;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;

public abstract class UserProperties {
    private static final String RCS_ID = "$Id: UserProperties.java,v 1.1 2002/03/14 09:55:00 deniger Exp $";
    private static final String RCS_NAME = "$Name:  $";
    private static final String RCS_REV = "$Revision: 1.1 $";
    private static final String PREFIX_PROPERTY = "propertyPrefix";
    private static final String DEFAULTS_RSRC_NAME = ".com.ice.global.defaultsResource.";
    private static final String GLOBAL_RSRCLIST_NAME = ".com.ice.global.propertyResourceList";
    private static final String GLOBAL_RSRC_PREFIX = ".com.ice.global.propertyResource.";
    private static final String APP_RSRCLIST_NAME = ".com.ice.local.propertyResourceList";
    private static final String APP_RSRC_PREFIX = ".com.ice.local.propertyResource.";
    private static final String LOCAL_PROPERTY = "global.localPropertyFile";
    private static final String LOCAL_DEFAULT = "properties.txt";
    private static boolean debug = false;
    private static boolean verbose = false;
    private static String osname;
    private static String userName;
    private static String userHome;
    private static String prefix;
    private static String osSuffix;
    private static String userSuffix;
    private static String defaultsResource;
    private static String localPropertyFile;
    static /* synthetic */ Class class$com$ice$util$UserProperties;

    public static String getOSName() {
        return osname;
    }

    public static String getUserHome() {
        return userHome;
    }

    public static String getUserName() {
        return userName;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static void setLocalPropertyFile(String string) {
        localPropertyFile = string;
    }

    public static void setDefaultsResource(String string) {
        defaultsResource = string;
    }

    public static void setOSSuffix(String string) {
        osSuffix = string;
    }

    public static void setUserSuffix(String string) {
        userSuffix = string;
    }

    public static void setPropertyPrefix(String string) {
        prefix = string.endsWith(".") ? string : string + ".";
    }

    public static String getPropertyPrefix() {
        return prefix;
    }

    public static Font getFont(String string, Font font) {
        return Font.getFont(UserProperties.fullPropertyName(string), font);
    }

    public static Color getColor(String string, Color color) {
        return Color.getColor(UserProperties.fullPropertyName(string), color);
    }

    public static String fullPropertyName(String string) {
        return prefix + string;
    }

    private static String getOverridableProperty(String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string5 = string.startsWith(".") ? string.substring(1) : UserProperties.fullPropertyName(string);
        if (string5.endsWith(".")) {
            string5 = string5.substring(0, string5.length());
            string3 = System.getProperty(string5, string2);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string5 + " = '" + string3 + "'");
            }
            return string3;
        }
        if (osSuffix != null && userSuffix != null) {
            string4 = string5 + "." + osSuffix + "." + userSuffix;
            string3 = System.getProperty(string4, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string4 + " = '" + string3 + "'");
            }
            if (string3 != null) {
                return string3;
            }
        }
        if (userSuffix != null) {
            string4 = string5 + "." + userSuffix;
            string3 = System.getProperty(string4, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string4 + " = '" + string3 + "'");
            }
            if (string3 != null) {
                return string3;
            }
        }
        if (osSuffix != null) {
            string4 = string5 + "." + osSuffix;
            string3 = System.getProperty(string4, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string4 + " = '" + string3 + "'");
            }
            if (string3 != null) {
                return string3;
            }
        }
        if (string3 == null) {
            string3 = System.getProperty(string5, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string5 + " = '" + string3 + "'");
            }
        }
        if (string3 == null) {
            string3 = string2;
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string + " defaulted to '" + string3 + "'");
            }
        }
        return string3;
    }

    public static String getProperty(String string, String string2) {
        String string3 = UserProperties.getOverridableProperty(string, string2);
        return string3;
    }

    public static int getProperty(String string, int n) {
        int n2 = n;
        String string2 = UserProperties.getProperty(string, null);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
            }
        }
        return n2;
    }

    public static double getProperty(String string, double d) {
        double d2 = d;
        String string2 = UserProperties.getProperty(string, null);
        if (string2 != null) {
            try {
                d2 = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = d;
            }
        }
        return d2;
    }

    public static boolean getProperty(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = UserProperties.getProperty(string, null);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("TRUE")) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase("FALSE")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public static void defaultProperties(Properties properties) {
        properties.put("com.ice.util.UserProperties.revision", RCS_REV);
        properties.put("copyright", "Copyright (c) by Tim Endres");
    }

    public static void addDefaultProperties(Properties properties, Properties properties2) {
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string = null;
            try {
                string = (String)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                string = null;
            }
            if (string == null) continue;
            String string2 = (String)properties2.get(string);
            if (string2 == null) {
                System.err.println("UserProperties.addDefaultProperties: key '" + string + "' has null value!");
                continue;
            }
            properties.put(string, string2);
        }
    }

    private static boolean loadPropertiesStream(InputStream inputStream, Properties properties) throws IOException {
        properties.load(inputStream);
        return true;
    }

    private static boolean loadPropertiesFile(String string, Properties properties) {
        FileInputStream fileInputStream;
        boolean bl = true;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            System.err.println("ERROR opening property file '" + string + "' - " + iOException.getMessage());
            bl = false;
            fileInputStream = null;
        }
        if (bl) {
            try {
                UserProperties.loadPropertiesStream(fileInputStream, properties);
            }
            catch (IOException iOException) {
                System.err.println("ERROR loading property file '" + string + "' - " + iOException.getMessage());
                bl = false;
            }
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("ERROR closing property file '" + string + "' - " + iOException.getMessage());
                bl = false;
            }
        }
        if (bl) {
            System.err.println("Loaded property file '" + string + "'.");
        }
        return bl;
    }

    private static InputStream openNamedResource(String string) throws IOException {
        InputStream inputStream = null;
        boolean bl = false;
        boolean bl2 = true;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            bl2 = false;
            uRL = null;
        }
        if (uRL == null) {
            uRL = (class$com$ice$util$UserProperties == null ? (class$com$ice$util$UserProperties = UserProperties.class$("com.ice.util.UserProperties")) : class$com$ice$util$UserProperties).getResource(string);
        }
        if (uRL != null) {
            String string2;
            String string3;
            URLConnection uRLConnection = uRL.openConnection();
            if (bl2 && (string3 = uRLConnection.getHeaderField(0)) != null && (string2 = HTTPUtilities.getResultCode(string3)) != null && !string2.equals("200")) {
                throw new IOException("status code = " + string2);
            }
            inputStream = uRLConnection.getInputStream();
        }
        return inputStream;
    }

    private static boolean loadPropertiesResource(String string, Properties properties) {
        boolean bl = false;
        try {
            InputStream inputStream = UserProperties.openNamedResource(string);
            if (inputStream != null) {
                UserProperties.loadPropertiesStream(inputStream, properties);
                inputStream.close();
                bl = true;
            }
        }
        catch (IOException iOException) {
            System.err.println("ERROR loading properties resource '" + string + "' - " + iOException.getMessage());
        }
        return bl;
    }

    private static void loadPropertyResourceList(String string, String string2, Properties properties) {
        String string3 = UserProperties.getProperty(string, null);
        if (string3 != null) {
            String[] stringArray = StringUtilities.splitString(string3, ":");
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                boolean bl;
                String string4 = string2 + stringArray[i];
                String string5 = UserProperties.getProperty(string4, null);
                if (string5 == null || (bl = UserProperties.loadPropertiesResource(string5, properties))) continue;
                System.err.println("ERROR loading property resource '" + string5 + "'");
            }
        }
    }

    public static void loadProperties(String string, Properties properties) {
        File file;
        String string2;
        boolean bl;
        Properties properties2;
        if (debug) {
            UserProperties.printContext(System.err);
        }
        if ((properties2 = System.getProperties()) == null) {
            return;
        }
        UserProperties.defaultProperties(properties2);
        String string3 = defaultsResource;
        if (string3 == null) {
            string3 = UserProperties.getProperty(DEFAULTS_RSRC_NAME, null);
        }
        if (string3 != null) {
            bl = UserProperties.loadPropertiesResource(string3, properties2);
            System.err.println("Loaded " + (bl ? "the " : "no ") + "default properties.");
        }
        if (properties != null) {
            UserProperties.addDefaultProperties(properties2, properties);
        }
        if ((string2 = prefix) == null) {
            UserProperties.getProperty(string + "." + PREFIX_PROPERTY, null);
            if (string2 != null) {
                UserProperties.setPropertyPrefix(string2);
                if (verbose) {
                    System.err.println("Property prefix set to '" + string2 + "'");
                }
            }
        }
        UserProperties.loadPropertyResourceList(GLOBAL_RSRCLIST_NAME, GLOBAL_RSRC_PREFIX, properties2);
        String string4 = localPropertyFile;
        if (string4 == null) {
            string4 = UserProperties.getProperty(LOCAL_PROPERTY, LOCAL_DEFAULT);
        }
        if (string4 != null && (file = new File(string4)).exists() && !(bl = UserProperties.loadPropertiesFile(string4, properties2))) {
            System.err.println("ERROR loading local property file '" + string4 + "'");
        }
        UserProperties.loadPropertyResourceList(APP_RSRCLIST_NAME, APP_RSRC_PREFIX, properties2);
    }

    public static void printContext(PrintStream printStream) {
        printStream.println("os.name    = '" + osname + "'");
        printStream.println("user.name  = '" + userName + "'");
        printStream.println("user.home  = '" + userHome + "'");
        printStream.println("");
        printStream.println("prefix     = '" + prefix + "'");
        printStream.println("osSuffix   = '" + osSuffix + "'");
        printStream.println("userSuffix = '" + userSuffix + "'");
        printStream.println("");
    }

    public static void printUsage(PrintStream printStream) {
        printStream.println("Properties options:");
        printStream.println("   -propDebug             -- turns on debugging of property loading");
        printStream.println("   -propVerbose           -- turns on verbose messages during loading");
        printStream.println("   -propDefaults rsrcName -- sets default properties resource name");
        printStream.println("   -propFile path         -- sets application property file path");
        printStream.println("   -propOS suffix         -- sets the os suffix");
        printStream.println("   -propUser suffix       -- sets the user suffix");
        printStream.println("   -propPrefix prefix     -- sets application property prefix");
    }

    public static String[] processOptions(String[] stringArray) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-propPrefix") && i + 1 < stringArray.length) {
                UserProperties.setPropertyPrefix(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-propFile") && i + 1 < stringArray.length) {
                UserProperties.setLocalPropertyFile(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-propDefaults") && i + 1 < stringArray.length) {
                UserProperties.setDefaultsResource(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-propDebug")) {
                UserProperties.setDebug(true);
                continue;
            }
            if (stringArray[i].equals("-propVerbose")) {
                UserProperties.setVerbose(true);
                continue;
            }
            if (stringArray[i].equals("-propOS") && i + 1 < stringArray.length) {
                UserProperties.setOSSuffix(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-propUser") && i + 1 < stringArray.length) {
                UserProperties.setUserSuffix(stringArray[++i]);
                continue;
            }
            vector.addElement(stringArray[i]);
        }
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray2[i] = (String)vector.elementAt(i);
        }
        return stringArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        prefix = null;
        defaultsResource = null;
        localPropertyFile = null;
        osname = System.getProperty("os.name");
        userName = System.getProperty("user.name");
        userHome = System.getProperty("user.home");
        osSuffix = osname.replace(' ', '_');
        userSuffix = userName.replace(' ', '_');
    }
}

