/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall;

import com.memoire.vainstall.SetupFileFilter;
import com.memoire.vainstall.UpgradeInfo;
import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.VAStats;
import com.memoire.vainstall.VAStep;
import com.memoire.vainstall.VAStepFactory;
import com.memoire.vainstall.VAUpgradeStep;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.Vector;

public abstract class AbstractInstall {
    public static final int CANCEL = 1;
    public static final int BACK = 2;
    public static final int NEXT = 4;
    public static final int FINISH = 8;
    public static final boolean IS_WIN = System.getProperty("os.name").startsWith("Win");
    public static final boolean IS_MAC_OS_X = System.getProperty("os.name").startsWith("Mac OS X");
    public static final boolean IS_MAC = System.getProperty("os.name").startsWith("Mac") && !IS_MAC_OS_X;
    public static final boolean IS_UNIX = !IS_WIN && !IS_MAC || IS_MAC_OS_X;
    public static final boolean IS_ROOT = IS_UNIX && "root".equals(System.getProperty("user.name")) || IS_WIN && new File("C:\\").canWrite();
    protected VAStep step_;
    protected boolean dirty_;
    protected VAStepFactory ui_;
    protected VAStats stats_;
    protected static final int LANGUAGE = 0;
    protected static final int START = 1;
    protected static final int WELCOME = 2;
    protected static final int LICENSE = 3;
    protected static final int README = 4;
    protected static final int LICENSE_KEY = 5;
    protected static final int UPGRADE = 6;
    protected static final int DIRECTORY = 7;
    protected static final int INSTALL = 8;
    protected static final int SHORTCUTS = 9;
    protected static final int END = 10;
    protected int state_;
    protected int actionEnabled_;
    protected File sharedDir_;
    protected File classloaderTempDir_;
    protected UpgradeInfo uInfo_;
    protected String language;

    public AbstractInstall() {
        if (IS_WIN) {
            this.extractJniDll();
        }
        this.actionEnabled_ = 0;
        this.stats_ = new VAStats();
        this.sharedDir_ = null;
        this.uInfo_ = null;
        this.dirty_ = false;
        this.state_ = 1;
    }

    public void deleteDirRecursive(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] filelist = dir.listFiles();
        int i = 0;
        while (i < filelist.length) {
            boolean isdir = filelist[i].isDirectory();
            if (isdir) {
                this.deleteDirRecursive(filelist[i]);
            } else if (!filelist[i].delete()) {
                this.stats_.addFile(filelist[i], false);
                VAGlobals.printDebug("F " + filelist[i] + " not deleted");
            }
            ++i;
        }
        if (!dir.delete()) {
            this.stats_.addDirectory(dir, false);
            VAGlobals.printDebug("D " + dir + " not deleted");
        }
    }

    public boolean cleanShortcuts(File shortcutLogDir) throws IOException {
        File logFile = new File(shortcutLogDir, "shortcuts.vai");
        boolean value = false;
        if (logFile.exists()) {
            value = true;
            Vector directories = this.deleteFiles(logFile);
            this.deleteDirectories(directories);
        }
        return value;
    }

    protected Vector deleteFiles(File log) throws IOException {
        Vector<File> dirs = new Vector<File>();
        LineNumberReader logReader = new LineNumberReader(new FileReader(log));
        String line = logReader.readLine();
        while (line != null) {
            File del = new File(line);
            if (del.isDirectory()) {
                dirs.add(del);
            } else if (del.delete()) {
                this.stats_.addFile(del, true);
            } else {
                del.deleteOnExit();
                this.stats_.addFile(del, false);
                VAGlobals.printDebug("F " + del + " not deleted");
            }
            line = logReader.readLine();
        }
        logReader.close();
        return dirs;
    }

    protected void deleteDirectories(Vector directories) throws IOException {
        Object[] dirs = directories.toArray();
        Arrays.sort(dirs);
        int i = dirs.length - 1;
        while (i >= 0) {
            File del = (File)dirs[i];
            if (del.delete()) {
                this.stats_.addDirectory(del, true);
            } else {
                del.deleteOnExit();
                this.stats_.addDirectory(del, false);
                VAGlobals.printDebug("D " + del + " not deleted");
            }
            --i;
        }
    }

    private void restoreLastVersion(File sharedDir, UpgradeInfo uInfo) {
        File destPath = new File(sharedDir, "vai_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION);
        if (destPath.exists()) {
            this.deleteDirRecursive(destPath);
        }
        if (uInfo == null || !uInfo.upgrade) {
            return;
        }
        File lastVerPath = new File(sharedDir, "vai_" + VAGlobals.APP_NAME + "_" + uInfo.lastVersion());
        if (destPath.equals(lastVerPath)) {
            lastVerPath = new File(String.valueOf(destPath.getAbsolutePath()) + ".bak");
            lastVerPath.renameTo(destPath);
        }
    }

    public void setActionEnabled(int a) {
        this.actionEnabled_ = a;
        this.ui_.setActionEnabled(a);
    }

    public void cancel() {
        this.cleanInstall(this.sharedDir_, this.uInfo_);
        this.quit();
    }

    protected void cleanInstall(File sharedDir, UpgradeInfo uInfo) {
        if (!this.dirty_ || sharedDir == null || !sharedDir.exists()) {
            VAGlobals.printDebug("No cleaning needed");
            return;
        }
        File uninstDir = new File(String.valueOf(sharedDir.getAbsolutePath()) + File.separator + "vai_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION);
        if (!uninstDir.exists()) {
            VAGlobals.printDebug("No cleaning needed");
            return;
        }
        VAGlobals.printDebug("Deleting uninstall files...");
        if (uInfo != null && uInfo.upgrade) {
            this.restoreLastVersion(sharedDir, uInfo);
        } else {
            this.deleteDirRecursive(uninstDir);
        }
        VAGlobals.printDebug("All cleaned OK");
    }

    protected void checkUpgrade(File sharedDir, UpgradeInfo uInfo) {
        VAUpgradeStep step = (VAUpgradeStep)this.step_;
        step.status(VAGlobals.i18n("Setup_LookPreviousVersions"));
        this.ui_.uiSleep(2000L);
        this.checkVersions(sharedDir, uInfo);
        if (uInfo.upgrade) {
            VAGlobals.printDebug("Previous version found : " + uInfo.lastVersion());
            step.status(String.valueOf(VAGlobals.i18n("Setup_PreviousVersionFound")) + " " + uInfo.lastVersion());
            step.version(uInfo.lastVersion());
            step.directory(uInfo.lastPath().getAbsolutePath());
        } else {
            VAGlobals.printDebug("No previous version found");
            step.status(VAGlobals.i18n("Setup_NoPreviousVersionFound"));
            step.version(VAGlobals.i18n("Setup_None"));
            step.directory(VAGlobals.i18n("Setup_None"));
        }
    }

    private void checkVersions(File sharedDir, UpgradeInfo uInfo) {
        Object[] ls = sharedDir.list(new SetupFileFilter("vai_" + VAGlobals.APP_NAME + "_", 1, 1));
        if (ls != null && ls.length > 0) {
            Arrays.sort(ls);
            uInfo.versions = new String[ls.length];
            uInfo.paths = new File[ls.length];
            int i = 0;
            while (i < ls.length) {
                uInfo.versions[i] = ((String)ls[i]).substring(((String)ls[i]).lastIndexOf(95) + 1);
                try {
                    LineNumberReader log = new LineNumberReader(new FileReader(new File(new File(sharedDir, (String)ls[i]), "uninstall.vai")));
                    String f = log.readLine();
                    if (f != null) {
                        uInfo.paths[i] = new File(f);
                    }
                    log.close();
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                    uInfo.paths[i] = null;
                }
                ++i;
            }
        }
        uInfo.upgrade = uInfo.lastVersion() != null && uInfo.lastPath() != null;
    }

    private void extractJniDll() {
        try {
            String entryName = "/ICE_JNIRegistry.dll";
            InputStream dll = this.getClass().getResourceAsStream(entryName);
            File dllFile = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + entryName.substring(entryName.lastIndexOf(47) + 1));
            VAGlobals.printDebug("Extracting library " + dllFile);
            System.out.println(dllFile.getAbsolutePath());
            FileOutputStream dllout = new FileOutputStream(dllFile);
            byte[] data = new byte[512];
            int read = dll.read(data, 0, data.length);
            while (read > 0) {
                dllout.write(data, 0, read);
                read = dll.read(data, 0, data.length);
            }
            dll.close();
            dllout.close();
            VAGlobals.printDebug(" library extracted");
            VAGlobals.JNI_DLL_FILE = dllFile.getAbsolutePath();
        }
        catch (IOException e) {
            this.exitOnError(e);
        }
    }

    protected void exitOnError(Throwable e) {
        if (this.ui_ != null) {
            this.ui_.showFatalError(e);
        } else {
            e.printStackTrace();
        }
        System.exit(1);
    }

    protected void quit() {
        if (this.classloaderTempDir_ != null) {
            VAGlobals.printDebug("Temporary directory deleted: " + this.classloaderTempDir_.getAbsolutePath());
            this.deleteDirRecursive(this.classloaderTempDir_);
        }
        this.ui_ = null;
        VAGlobals.printDebug("Exiting");
        System.exit(0);
    }

    public abstract void nextStep();

    public abstract void previousStep();

    public abstract void redoStep();
}

