/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall;

import com.memoire.vainstall.VaiFileFilter;
import java.io.FileFilter;
import java.util.StringTokenizer;

class FileNameGroup {
    String originBase_;
    String destBase_;
    String commonPath_;
    String extensions_;
    boolean executable_ = false;
    boolean recursive_ = true;

    public FileNameGroup(String string) {
        if (string.startsWith("(E)")) {
            string = string.substring(3);
            this.executable_ = true;
        }
        if (string.startsWith("(N)")) {
            string = string.substring(3);
            this.recursive_ = false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(new String(string), "|", true);
        this.originBase_ = stringTokenizer.nextToken();
        if (this.originBase_.endsWith("/")) {
            this.originBase_ = this.originBase_.substring(0, this.originBase_.length() - 1);
        }
        stringTokenizer.nextToken();
        this.destBase_ = stringTokenizer.nextToken();
        if (this.destBase_.equals("|")) {
            this.destBase_ = null;
        } else {
            if (this.destBase_.endsWith("/")) {
                this.destBase_ = this.destBase_.substring(0, this.destBase_.length() - 1);
            }
            stringTokenizer.nextToken();
        }
        this.extensions_ = null;
        this.commonPath_ = null;
        if (stringTokenizer.hasMoreTokens()) {
            this.commonPath_ = stringTokenizer.nextToken();
            if (this.commonPath_.equals("|")) {
                this.commonPath_ = null;
            }
            if (stringTokenizer.hasMoreTokens()) {
                if (this.commonPath_ != null) {
                    stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    this.extensions_ = stringTokenizer.nextToken();
                }
            }
        }
    }

    public String getOrigin() {
        if (this.commonPath_ == null) {
            return this.originBase_;
        }
        return this.originBase_ + "/" + this.commonPath_;
    }

    public String getDestination() {
        if (this.destBase_ == null && this.commonPath_ == null) {
            return "";
        }
        if (this.destBase_ == null) {
            return this.commonPath_;
        }
        if (this.commonPath_ == null) {
            return this.destBase_;
        }
        return this.destBase_ + "/" + this.commonPath_;
    }

    public FileFilter getFileFilter() throws IllegalArgumentException {
        String[] stringArray = null;
        if (this.extensions_ != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.extensions_, ",");
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
                if (stringArray[i].length() >= 2 && stringArray[i].startsWith("*")) {
                    stringArray[i] = stringArray[i].substring(1);
                    continue;
                }
                if (stringArray[i].length() >= 3 && stringArray[i].startsWith("!*")) {
                    stringArray[i] = "!" + stringArray[i].substring(2);
                    continue;
                }
                throw new IllegalArgumentException("invalid pattern: " + stringArray[i]);
            }
        }
        return new VaiFileFilter(stringArray);
    }

    public boolean isExecutable() {
        return this.executable_;
    }

    public boolean isRecursive() {
        return this.recursive_;
    }
}

