/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall;

import com.ice.jni.registry.RegStringValue;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import com.memoire.vainstall.AbstractInstall;
import com.memoire.vainstall.LicenseKeySupport;
import com.memoire.vainstall.LogInfo;
import com.memoire.vainstall.SetupFileFilter;
import com.memoire.vainstall.UpgradeInfo;
import com.memoire.vainstall.VADirectoryStep;
import com.memoire.vainstall.VAEndStep;
import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.VAInstallStep;
import com.memoire.vainstall.VALanguageStep;
import com.memoire.vainstall.VALicenseKeyStep;
import com.memoire.vainstall.VALicenseStep;
import com.memoire.vainstall.VALinkDebian;
import com.memoire.vainstall.VALinkGnome;
import com.memoire.vainstall.VALinkKDE;
import com.memoire.vainstall.VALinkWindows;
import com.memoire.vainstall.VAReadmeStep;
import com.memoire.vainstall.VAShortcutStep;
import com.memoire.vainstall.VAStepFactory;
import com.memoire.vainstall.VAUpgradeStep;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Setup
extends AbstractInstall {
    public static final String JAVA_HOME = System.getProperty("java.home");
    public static final String JAVA_EXE = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + (IS_WIN ? ".exe" : "");
    private static final String JAVAW_EXE = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + (IS_WIN ? "w.exe" : "");
    private File fileWithArchive_;
    private String installClassName_;
    private long installClassOffset_;
    private long installClassSize_;
    private long jarOffset_;
    private LicenseKeySupport licenseKeySupport;
    private boolean choosedLanguage;
    private Object[] launchparms;
    private String customPrePostClassName_;
    private String originalLanguage;
    static /* synthetic */ Class class$java$io$PrintWriter;
    static /* synthetic */ Class class$com$memoire$vainstall$VAInstallStep;
    static /* synthetic */ Class class$java$lang$String;

    public Setup(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, Boolean bl, String string11, File file, String string12, Long l, Long l2, Long l3, File file2) {
        this.classloaderTempDir_ = file2;
        try {
            this.licenseKeySupport = (LicenseKeySupport)this.getClass().getClassLoader().loadClass(string11).newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("cannot load license key support: " + exception.toString());
        }
        this.uInfo_ = new UpgradeInfo();
        VAGlobals.UI_MODE = System.getProperty("uimode", string);
        VAGlobals.UI_BLUESCREEN = !"no".equals(string2);
        String string13 = System.getProperty("bluescreen");
        if (string13 != null) {
            VAGlobals.UI_BLUESCREEN = !"no".equalsIgnoreCase(string13);
        }
        VAGlobals.UI_BLUESCREEN_COLOR = string3 == null || "".equals(string3) || "null".equals(string3) ? null : new Color(Integer.parseInt(string3, 16));
        VAGlobals.IMAGE = "com/memoire/vainstall/resources/banner.gif";
        VAGlobals.APP_NAME = string4;
        VAGlobals.APP_VERSION = string5;
        try {
            VAGlobals.DEST_PATH = Setup.expandDirectory(string6, false, this.uInfo_);
        }
        catch (IOException iOException) {
            VAGlobals.printDebug(iOException.toString());
        }
        if (VAGlobals.DEST_PATH == null) {
            try {
                VAGlobals.DEST_PATH = Setup.expandDirectory("[HOME]" + Setup.getWithoutMacro(string6), false, this.uInfo_);
            }
            catch (IOException iOException) {
                VAGlobals.printDebug(iOException.toString());
            }
            if (VAGlobals.DEST_PATH == null) {
                VAGlobals.DEST_PATH = System.getProperty("user.dir" + Setup.getWithoutMacro(string6));
            }
        }
        VAGlobals.LINK_SECTION_NAME = string7;
        VAGlobals.LINK_SECTION_ICON = string8;
        VAGlobals.LINK_ENTRY_NAME = string9;
        VAGlobals.LINK_ENTRY_ICON = string10;
        VAGlobals.CREATE_UNINSTALL_SHORTCUT = bl;
        VAGlobals.OPERATION = this.uInfo_.forceUpgrade ? 3 : 1;
        this.fileWithArchive_ = file;
        this.installClassName_ = string12;
        this.installClassOffset_ = l;
        this.installClassSize_ = l2;
        this.jarOffset_ = l3;
        InputStream inputStream = this.getClass().getResourceAsStream("resources/vainstall.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.language = properties.getProperty("vainstall.destination.language");
        if (this.language != null) {
            if (this.language.toLowerCase().indexOf("choose") != -1) {
                this.choosedLanguage = true;
                this.state_ = 0;
            }
            VAGlobals.setLanguage(this.language);
        }
        this.originalLanguage = VAGlobals.getCurrentLanguage();
        this.customPrePostClassName_ = properties.getProperty("vainstall.install.customprepost.className");
        this.ui_ = VAStepFactory.createUI(VAGlobals.UI_MODE, this);
        VAGlobals.printDebug("UI created");
        if (!file.exists()) {
            this.ui_.showError(new Exception(VAGlobals.i18n("Setup_ArchiveNotFound") + file.getAbsolutePath()));
            this.quit();
        }
        this.nextStep();
        this.ui_.activateUI();
    }

    public void nextStep() {
        switch (this.state_) {
            case 0: {
                VAGlobals.printDebug("LANGUAGE");
                this.state_ = 1;
                this.setActionEnabled(5);
                this.step_ = this.ui_.createSetupLanguageStep();
                break;
            }
            case 1: {
                VAGlobals.printDebug("WELCOME");
                if (this.step_ instanceof VALanguageStep) {
                    this.language = ((VALanguageStep)this.step_).getLanguage();
                    VAGlobals.setLanguage(this.language);
                }
                this.state_ = 2;
                if (!this.choosedLanguage) {
                    this.setActionEnabled(5);
                } else {
                    this.setActionEnabled(7);
                }
                this.step_ = this.ui_.createWelcomeStep();
                break;
            }
            case 2: {
                VAGlobals.printDebug("LICENSE");
                this.state_ = 3;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createLicenseStep();
                ((VALicenseStep)this.step_).setText(this.getClass().getResourceAsStream("license.txt"));
                break;
            }
            case 3: {
                if (!((VALicenseStep)this.step_).isLicenseAccepted()) {
                    this.ui_.showError(new Exception(VAGlobals.i18n("Setup_AcceptLicense")));
                    break;
                }
                VAGlobals.printDebug("README");
                this.state_ = 4;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createReadmeStep();
                ((VAReadmeStep)this.step_).setText(this.getClass().getResourceAsStream("readme.txt"));
                break;
            }
            case 4: {
                if (this.licenseKeySupport.needsLicenseKey()) {
                    VAGlobals.printDebug("LICENSE_KEY");
                    this.state_ = 5;
                    this.setActionEnabled(0);
                    this.step_ = this.ui_.createLicenseKeyStep();
                    ((VALicenseKeyStep)this.step_).setLicenseKeySupport(this.licenseKeySupport);
                    this.setActionEnabled(7);
                    break;
                }
                this.nextStepUpgrade();
                break;
            }
            case 5: {
                if (((VALicenseKeyStep)this.step_).getGetFields(this.licenseKeySupport)) {
                    this.nextStepUpgrade();
                    break;
                }
                this.ui_.showError(new Exception("invalid license key"));
                break;
            }
            case 6: {
                boolean bl = true;
                if (this.uInfo_.forceUpgrade || VAGlobals.APP_VERSION.equals(this.uInfo_.lastVersion())) {
                    bl = true;
                } else {
                    VAUpgradeStep vAUpgradeStep = (VAUpgradeStep)this.step_;
                    bl = vAUpgradeStep.isConfirmUpgrade();
                }
                boolean bl2 = this.uInfo_.upgrade = this.uInfo_.upgrade && bl;
                if (this.uInfo_.upgrade) {
                    if (!this.uInfo_.lastPath().exists()) {
                        this.exitOnError(new Exception(this.uInfo_.lastPath() + VAGlobals.i18n("Setup_DirectoryNotAccessible") + "\n" + VAGlobals.i18n("Setup_ReinstallFirst")));
                    }
                    if (this.uInfo_.module && !VAGlobals.APP_VERSION.equals(this.uInfo_.lastVersion())) {
                        this.exitOnError(new Exception(VAGlobals.i18n("Setup_VersionWarning") + "\n" + VAGlobals.i18n("Setup_Current") + this.uInfo_.lastVersion() + ", " + VAGlobals.i18n("Setup_ThisOne") + VAGlobals.APP_VERSION + "\n" + VAGlobals.i18n("Setup_ReinstallFirst")));
                    }
                    if (this.uInfo_.lastVersion().compareTo(VAGlobals.APP_VERSION) > 0) {
                        this.ui_.showError(new Exception(VAGlobals.i18n("Setup_VersionWarning") + "\n" + VAGlobals.i18n("Setup_Current") + this.uInfo_.lastVersion() + ", " + VAGlobals.i18n("Setup_ThisOne") + VAGlobals.APP_VERSION + "\n" + VAGlobals.i18n("Setup_CurrentVersionNewer") + "\n" + VAGlobals.i18n("Setup_MayCancelUpdate")));
                    }
                    VAGlobals.printDebug("Upgrade from version: " + this.uInfo_.lastVersion());
                    VAGlobals.DEST_PATH = this.uInfo_.lastPath().getAbsolutePath();
                    this.uInfo_.paths = null;
                    VAGlobals.printDebug("INSTALL");
                    this.state_ = 8;
                    this.setActionEnabled(7);
                    this.step_ = this.ui_.createInstallStep();
                    break;
                }
                if (this.uInfo_.forceUpgrade) {
                    this.exitOnError(new Exception(VAGlobals.i18n("Setup_UpdateOnly") + "\n" + VAGlobals.i18n("Setup_NoSuitableVersion") + "\n" + VAGlobals.APP_NAME));
                }
                VAGlobals.printDebug("DIRECTORY");
                this.state_ = 7;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createDirectoryStep();
                ((VADirectoryStep)this.step_).setDirectory(new File(VAGlobals.DEST_PATH));
                break;
            }
            case 7: {
                VADirectoryStep vADirectoryStep = (VADirectoryStep)this.step_;
                File file = vADirectoryStep.getDirectory();
                if (file == null) {
                    return;
                }
                File file2 = this.checkDirectory(file);
                if (file2 != null) {
                    vADirectoryStep.roDirectory(file2);
                    VAGlobals.printDebug("  " + file2.getAbsolutePath() + " read-only");
                    return;
                }
                if (this.uInfo_.paths != null) {
                    for (int i = 0; i < this.uInfo_.paths.length; ++i) {
                        if (this.uInfo_.paths[i] == null || !this.uInfo_.paths[i].getAbsolutePath().equals(file.getAbsolutePath())) continue;
                        vADirectoryStep.rejectDirectory();
                        VAGlobals.printDebug("  " + file.getAbsolutePath() + " rejected");
                        return;
                    }
                }
                if (!vADirectoryStep.acceptDirectory()) {
                    VAGlobals.printDebug("  " + file.getAbsolutePath() + " refused by user");
                    return;
                }
                VAGlobals.DEST_PATH = file.getAbsolutePath();
                VAGlobals.printDebug("  " + file.getAbsolutePath() + " accepted");
                VAGlobals.printDebug("INSTALL");
                this.state_ = 8;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createInstallStep();
                break;
            }
            case 8: {
                this.setActionEnabled(0);
                this.startInstall(this.sharedDir_, this.uInfo_);
                if (this.uInfo_.upgrade || this.uInfo_.forceUpgrade) {
                    try {
                        if (this.cleanShortcuts(new File(this.sharedDir_.getAbsolutePath() + File.separator + "vai_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION + File.separator))) {
                            this.createShortcuts(this.sharedDir_);
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println("[Setup]: " + iOException.getMessage());
                    }
                    VAGlobals.printDebug("END");
                    this.state_ = 10;
                    this.setActionEnabled(8);
                    this.step_ = this.ui_.createEndStep();
                    ((VAEndStep)this.step_).setStats(this.stats_);
                    break;
                }
                VAGlobals.printDebug("SHORTCUTS");
                this.state_ = 9;
                this.setActionEnabled(4);
                this.step_ = this.ui_.createShortcutStep();
                break;
            }
            case 9: {
                if (((VAShortcutStep)this.step_).isShortcutAccepted()) {
                    this.createShortcuts(this.sharedDir_);
                }
                VAGlobals.printDebug("END");
                this.state_ = 10;
                this.setActionEnabled(8);
                this.step_ = this.ui_.createEndStep();
                ((VAEndStep)this.step_).setStats(this.stats_);
                break;
            }
            case 10: {
                this.ui_.quitUI();
                this.quit();
            }
        }
    }

    private void nextStepUpgrade() {
        VAGlobals.printDebug("UPGRADE");
        this.state_ = 6;
        this.setActionEnabled(0);
        this.step_ = this.ui_.createUpgradeStep();
        VAGlobals.printDebug(IS_ROOT ? "Root install" : "User install");
        this.sharedDir_ = this.findVAISharedDir();
        VAGlobals.printDebug("vainstall directory: !!!" + this.sharedDir_);
        this.checkUpgrade(this.sharedDir_, this.uInfo_);
        if (!VAGlobals.APP_VERSION.equals(this.uInfo_.lastVersion()) && this.uInfo_.upgrade && !this.uInfo_.forceUpgrade) {
            VAUpgradeStep vAUpgradeStep = (VAUpgradeStep)this.step_;
            vAUpgradeStep.setChoiceEnabled(true);
        }
        this.setActionEnabled(7);
    }

    public void previousStep() {
        switch (this.state_) {
            case 2: {
                VAGlobals.printDebug("LANGUAGE");
                this.state_ = 1;
                this.setActionEnabled(5);
                VAGlobals.setLanguage(this.originalLanguage);
                this.step_ = this.ui_.createSetupLanguageStep();
                break;
            }
            case 3: {
                VAGlobals.printDebug("WELCOME");
                this.state_ = 2;
                if (!this.choosedLanguage) {
                    this.setActionEnabled(5);
                } else {
                    this.setActionEnabled(7);
                }
                this.step_ = this.ui_.createWelcomeStep();
                break;
            }
            case 4: {
                VAGlobals.printDebug("LICENSE");
                this.state_ = 3;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createLicenseStep();
                ((VAReadmeStep)this.step_).setText(this.getClass().getResourceAsStream("license.txt"));
                break;
            }
            case 5: {
                VAGlobals.printDebug("README");
                this.state_ = 4;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createReadmeStep();
                ((VAReadmeStep)this.step_).setText(this.getClass().getResourceAsStream("readme.txt"));
                break;
            }
            case 6: {
                if (this.licenseKeySupport.needsLicenseKey()) {
                    VAGlobals.printDebug("LICENSE_KEY");
                    this.state_ = 5;
                    this.setActionEnabled(0);
                    this.step_ = this.ui_.createLicenseKeyStep();
                    ((VALicenseKeyStep)this.step_).setLicenseKeySupport(this.licenseKeySupport);
                    this.setActionEnabled(7);
                    break;
                }
                VAGlobals.printDebug("README");
                this.state_ = 4;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createReadmeStep();
                ((VAReadmeStep)this.step_).setText(this.getClass().getResourceAsStream("readme.txt"));
                break;
            }
            case 7: {
                VAGlobals.printDebug("UPGRADE");
                this.state_ = 6;
                this.setActionEnabled(0);
                this.step_ = this.ui_.createUpgradeStep();
                this.checkUpgrade(this.sharedDir_, this.uInfo_);
                if (!VAGlobals.APP_VERSION.equals(this.uInfo_.lastVersion()) && this.uInfo_.upgrade && !this.uInfo_.forceUpgrade) {
                    VAUpgradeStep vAUpgradeStep = (VAUpgradeStep)this.step_;
                    vAUpgradeStep.setChoiceEnabled(true);
                }
                this.setActionEnabled(7);
                break;
            }
            case 8: {
                if (this.uInfo_.upgrade) {
                    this.state_ = 6;
                    this.setActionEnabled(0);
                    this.step_ = this.ui_.createUpgradeStep();
                    this.checkUpgrade(this.sharedDir_, this.uInfo_);
                    this.setActionEnabled(7);
                    break;
                }
                VAGlobals.printDebug("DIRECTORY");
                this.state_ = 7;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createDirectoryStep();
                ((VADirectoryStep)this.step_).setDirectory(new File(VAGlobals.DEST_PATH));
                break;
            }
            default: {
                VAGlobals.printDebug("can't go back...");
            }
        }
    }

    public void redoStep() {
        switch (this.state_) {
            case 1: {
                this.setActionEnabled(5);
                this.step_ = this.ui_.createSetupLanguageStep();
                break;
            }
            case 2: {
                this.setActionEnabled(7);
                this.step_ = this.ui_.createWelcomeStep();
                break;
            }
            case 3: {
                this.setActionEnabled(7);
                this.step_ = this.ui_.createLicenseStep();
                ((VALicenseStep)this.step_).setText(this.getClass().getResourceAsStream("license.txt"));
                break;
            }
            case 4: {
                this.setActionEnabled(7);
                this.step_ = this.ui_.createReadmeStep();
                ((VAReadmeStep)this.step_).setText(this.getClass().getResourceAsStream("readme.txt"));
                break;
            }
            case 5: {
                VAGlobals.printDebug("LICENSE_KEY");
                this.state_ = 5;
                this.setActionEnabled(0);
                this.step_ = this.ui_.createLicenseKeyStep();
                ((VALicenseKeyStep)this.step_).setLicenseKeySupport(this.licenseKeySupport);
                this.setActionEnabled(7);
                break;
            }
            case 6: {
                this.setActionEnabled(0);
                this.step_ = this.ui_.createUpgradeStep();
                this.checkUpgrade(this.sharedDir_, this.uInfo_);
                if (!VAGlobals.APP_VERSION.equals(this.uInfo_.lastVersion()) && this.uInfo_.upgrade && !this.uInfo_.forceUpgrade) {
                    VAUpgradeStep vAUpgradeStep = (VAUpgradeStep)this.step_;
                    vAUpgradeStep.setChoiceEnabled(true);
                }
                this.setActionEnabled(7);
                break;
            }
            case 7: {
                this.setActionEnabled(7);
                this.step_ = this.ui_.createDirectoryStep();
                ((VADirectoryStep)this.step_).setDirectory(new File(VAGlobals.DEST_PATH));
                break;
            }
            case 8: {
                this.setActionEnabled(7);
                this.step_ = this.ui_.createInstallStep();
                break;
            }
            case 9: {
                this.setActionEnabled(4);
                this.step_ = this.ui_.createShortcutStep();
                break;
            }
            case 10: {
                this.setActionEnabled(8);
                this.step_ = this.ui_.createEndStep();
                ((VAEndStep)this.step_).setStats(this.stats_);
            }
        }
    }

    private File checkDirectory(File file) {
        File file2 = null;
        for (File file3 = file; file3 != null; file3 = file3.getParentFile()) {
            if (!file3.exists()) continue;
            if (!file3.canWrite()) {
                file2 = file3;
                break;
            }
            file2 = null;
            break;
        }
        return file2;
    }

    private void createShortcuts(File file) {
        try {
            Vector vector = this.loadLogFile(file);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file.getAbsolutePath() + File.separator + "vai_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION + File.separator + "shortcuts.vai"));
            LogInfo logInfo = new LogInfo();
            logInfo.log = printWriter;
            logInfo.oldlog = vector;
            HashSet hashSet = new HashSet();
            if (IS_UNIX) {
                VAGlobals.printDebug("KDE LINKS IN:");
                VAGlobals.printDebug("  " + System.getProperty("user.home") + File.separator + ".kde" + File.separator + "share" + File.separator + "applnk" + File.separator + VAGlobals.LINK_SECTION_NAME);
                VAGlobals.printDebug("  " + System.getProperty("user.home") + File.separator + "Desktop");
                VALinkKDE.createAll(this.launchparms, hashSet);
                VAGlobals.printDebug("GNOME LINKS IN:");
                VAGlobals.printDebug("  " + System.getProperty("user.home") + File.separator + ".gnome" + File.separator + "apps" + File.separator + VAGlobals.LINK_SECTION_NAME);
                VAGlobals.printDebug("  " + System.getProperty("user.home") + File.separator + ".gnome-desktop");
                VALinkGnome.createAll(this.launchparms, hashSet);
                VAGlobals.printDebug("DEBIAN LINKS IN:");
                VAGlobals.printDebug("  " + System.getProperty("user.home") + File.separator + ".menu");
                VALinkDebian.create();
            } else if (IS_WIN) {
                VALinkWindows.create(this.launchparms, file, this.installClassName_, hashSet);
            } else {
                this.ui_.showError(new Exception(VAGlobals.i18n("Setup_SorryFeatureNotImplemented")));
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                printWriter.println(string);
            }
            logInfo.close();
        }
        catch (IOException iOException) {
            this.ui_.showError(iOException);
        }
    }

    private void startInstall(File file, UpgradeInfo upgradeInfo) {
        VAInstallStep vAInstallStep = (VAInstallStep)this.step_;
        LogInfo logInfo = new LogInfo();
        ObjectInputStream objectInputStream = null;
        try {
            if (upgradeInfo.upgrade) {
                VAGlobals.printDebug("Upgrade mode");
            } else {
                VAGlobals.printDebug("Install mode");
            }
            vAInstallStep.status(VAGlobals.i18n("Setup_ExtractingUninstaller"));
            File file2 = this.extractUninstallFiles(file, upgradeInfo.upgrade, upgradeInfo.lastVersion());
            objectInputStream = new ObjectInputStream(this.getClass().getResourceAsStream("archive_infos"));
            FileWriter fileWriter = new FileWriter(file.getAbsolutePath() + File.separator + "vai_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION + File.separator + "uninstall.vai");
            logInfo.log = new PrintWriter(fileWriter);
            logInfo.filewriter = fileWriter;
            File file3 = new File(this.computeLocalPath(""));
            vAInstallStep.details("D " + file3);
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException(VAGlobals.i18n("Setup_NotCreateDirectory") + " " + file3);
            }
            logInfo.log.println(file3.getAbsolutePath());
            if (this.customPrePostClassName_.length() > 0) {
                this.callPreCustom(logInfo.log, this.uInfo_, vAInstallStep);
            }
            vAInstallStep.status(VAGlobals.i18n("Setup_DecompressingFiles"));
            int n = objectInputStream.readInt();
            this.unzip(this.licenseKeySupport.decodeStream(this.getClass().getResourceAsStream("archive.zip")), n, file, upgradeInfo.upgrade, logInfo, file2);
            vAInstallStep.status(VAGlobals.i18n("Setup_GeneratingLaunchScripts"));
            this.launchparms = this.generateLaunchScripts(objectInputStream, logInfo);
            this.ui_.uiSleep(2000L);
            vAInstallStep.status(VAGlobals.i18n("Setup_LaunchScriptsGenerated"));
            this.ui_.uiSleep(1000L);
            vAInstallStep.status(VAGlobals.i18n("Setup_GeneratingUninstallScript"));
            this.generateUninstallScripts(file, logInfo);
            this.ui_.uiSleep(2000L);
            vAInstallStep.status(VAGlobals.i18n("Setup_UninstallScriptGenerated"));
            this.ui_.uiSleep(1000L);
            if (IS_UNIX) {
                vAInstallStep.status(VAGlobals.i18n("Setup_RestoringExeAttributes"));
                this.restoreUnixExecutables(objectInputStream);
                this.ui_.uiSleep(2000L);
                vAInstallStep.status(VAGlobals.i18n("Setup_ExeAttributesRestored"));
                this.ui_.uiSleep(1000L);
            }
            if (IS_WIN) {
                vAInstallStep.status(VAGlobals.i18n("Setup_UpdatingWindowsRegistry"));
                this.updateWindowsRegistry(file, upgradeInfo.upgrade, upgradeInfo.lastVersion());
                this.ui_.uiSleep(2000L);
                vAInstallStep.status(VAGlobals.i18n("Setup_WindowsRegistryUpdated"));
                this.ui_.uiSleep(1000L);
            }
            if (this.customPrePostClassName_.length() > 0) {
                this.callPostCustom(logInfo.log, this.uInfo_, vAInstallStep);
            }
            logInfo.close();
            objectInputStream.close();
            objectInputStream = null;
            this.removeBackups();
            vAInstallStep.status(VAGlobals.i18n("Setup_InstallationComplete"));
            this.ui_.uiSleep(1000L);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
            VAGlobals.printDebug("exception caught - closing logInfo");
            if (logInfo != null) {
                logInfo.close();
            } else {
                VAGlobals.printDebug("logInfo is null!");
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    VAGlobals.printDebug("exception closing infos " + iOException.getMessage());
                }
            }
            this.exitOnError(exception);
        }
    }

    protected void exitOnError(Throwable throwable) {
        this.cleanInstall(this.sharedDir_, this.uInfo_);
        super.exitOnError(throwable);
    }

    private final void callPostCustom(PrintWriter printWriter, UpgradeInfo upgradeInfo, VAInstallStep vAInstallStep) throws Exception {
        VAGlobals.printDebug("begin custom post-install/upgrade");
        vAInstallStep.status(VAGlobals.i18n("Custom_Mopping..."));
        boolean bl = upgradeInfo.upgrade ? this.customUpgrade("postUpgrade", printWriter, upgradeInfo.lastVersion(), vAInstallStep) : this.customInstall("postInstall", printWriter, vAInstallStep);
        if (!bl) {
            VAGlobals.printDebug("custom postInstall/postUpgrade returned false");
            throw new IOException(VAGlobals.i18n("Setup_PostFailed"));
        }
        VAGlobals.printDebug("end custom post-install/upgrade - OK");
    }

    private final void callPreCustom(PrintWriter printWriter, UpgradeInfo upgradeInfo, VAInstallStep vAInstallStep) throws Exception {
        VAGlobals.printDebug("begin custom pre-install/upgrade");
        vAInstallStep.status(VAGlobals.i18n("Custom_Preparing..."));
        boolean bl = upgradeInfo.upgrade ? this.customUpgrade("preUpgrade", printWriter, upgradeInfo.lastVersion(), vAInstallStep) : this.customInstall("preInstall", printWriter, vAInstallStep);
        if (!bl) {
            VAGlobals.printDebug("custom preInstall/preUpgrade returned false");
            throw new IOException(VAGlobals.i18n("Setup_PreFailed"));
        }
        VAGlobals.printDebug("end custom pre-install/upgrade - OK");
    }

    public static final boolean callReflect(Method method, Object[] objectArray) throws Exception {
        try {
            return (Boolean)method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Exception)invocationTargetException.getTargetException();
        }
    }

    private final boolean customInstall(String string, PrintWriter printWriter, VAInstallStep vAInstallStep) throws Exception {
        Class<?> clazz = Class.forName(this.customPrePostClassName_);
        Method method = clazz.getMethod(string, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = Setup.class$("java.io.PrintWriter")) : class$java$io$PrintWriter, class$com$memoire$vainstall$VAInstallStep == null ? (class$com$memoire$vainstall$VAInstallStep = Setup.class$("com.memoire.vainstall.VAInstallStep")) : class$com$memoire$vainstall$VAInstallStep);
        Object[] objectArray = new Object[]{printWriter, vAInstallStep};
        return Setup.callReflect(method, objectArray);
    }

    private final boolean customUpgrade(String string, PrintWriter printWriter, String string2, VAInstallStep vAInstallStep) throws Exception {
        Class<?> clazz = Class.forName(this.customPrePostClassName_);
        Method method = clazz.getMethod(string, class$java$lang$String == null ? (class$java$lang$String = Setup.class$("java.lang.String")) : class$java$lang$String, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = Setup.class$("java.io.PrintWriter")) : class$java$io$PrintWriter, class$com$memoire$vainstall$VAInstallStep == null ? (class$com$memoire$vainstall$VAInstallStep = Setup.class$("com.memoire.vainstall.VAInstallStep")) : class$com$memoire$vainstall$VAInstallStep);
        Object[] objectArray = new Object[]{string2, printWriter, vAInstallStep};
        return Setup.callReflect(method, objectArray);
    }

    private File findVAISharedDir() {
        File file;
        block16: {
            file = null;
            try {
                if (IS_ROOT) {
                    if (IS_WIN) {
                        try {
                            RegistryKey registryKey = Registry.HKEY_LOCAL_MACHINE.openSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion");
                            file = new File(registryKey.getStringValue("CommonFilesDir"));
                            registryKey.closeKey();
                        }
                        catch (Exception exception) {
                            file = null;
                        }
                        if (file == null || !file.exists()) {
                            VAGlobals.printDebug("Could not find common dir in registry:");
                            VAGlobals.printDebug("using 'C:\\Program Files\\Common Files'");
                            file = new File("C:\\Program Files\\Common Files");
                            if (!file.exists()) {
                                file.mkdirs();
                            }
                        }
                    } else if (IS_UNIX && !(file = new File("/usr/share")).exists()) {
                        file = new File("/opt/share");
                    }
                    if (!file.exists()) {
                        throw new IOException(VAGlobals.i18n("Setup_CouldNotFindVAInstall"));
                    }
                    if (!(file = new File(file, "vainstall")).exists()) {
                        file.mkdirs();
                    }
                    break block16;
                }
                if (IS_WIN) {
                    file = new File(System.getProperty("user.home") + File.separator + "vainstall");
                } else if (IS_UNIX) {
                    file = new File(System.getProperty("user.home") + File.separator + ".vainstall");
                }
                if (!file.exists()) {
                    file.mkdirs();
                }
            }
            catch (IOException iOException) {
                this.exitOnError(iOException);
            }
        }
        return file;
    }

    private File extractUninstallFiles(File file, boolean bl, String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        File file2 = new File(file, "vai_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION);
        File file3 = null;
        if (bl) {
            object5 = new File(file, "vai_" + VAGlobals.APP_NAME + "_" + string);
            if (file2.equals(object5)) {
                File file4 = new File(file2.getAbsolutePath() + ".bak");
                if (!file2.renameTo(file4)) {
                    throw new IOException(VAGlobals.i18n("Setup_NotCreateDirectory") + " " + file2);
                }
                file3 = new File(file4.getAbsolutePath() + System.getProperty("file.separator") + "uninstall.vai");
            } else {
                file3 = new File(((File)object5).getAbsolutePath() + System.getProperty("file.separator") + "uninstall.vai");
            }
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException(VAGlobals.i18n("Setup_NotCreateDirectory") + " " + file2);
            }
        } else if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException(VAGlobals.i18n("Setup_NotCreateDirectory") + " " + file2);
        }
        this.dirty_ = true;
        object5 = file2.listFiles();
        for (int i = 0; i < ((File[])object5).length; ++i) {
            object5[i].delete();
        }
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[]{};
        int n = 0;
        if (this.installClassSize_ > 0L || this.jarOffset_ > 0L) {
            fileOutputStream = new FileOutputStream(file2.getAbsolutePath() + File.separator + this.installClassName_ + ".class");
            fileInputStream = new FileInputStream(this.fileWithArchive_);
            if (this.installClassOffset_ > 0L) {
                fileInputStream.skip(this.installClassOffset_);
            }
            byArray = new byte[]{};
            byArray = this.installClassSize_ < 0L ? new byte[(int)this.jarOffset_] : new byte[(int)this.installClassSize_];
            n = fileInputStream.read(byArray, 0, byArray.length);
            fileOutputStream.write(byArray, 0, n);
            fileOutputStream.close();
            fileInputStream.close();
        }
        fileInputStream = new FileInputStream(this.fileWithArchive_);
        if (this.jarOffset_ > 0L) {
            fileInputStream.skip(this.jarOffset_);
        }
        JarInputStream jarInputStream = new JarInputStream(fileInputStream);
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file2.getAbsolutePath() + File.separator + "install.jar"));
        ZipEntry zipEntry = jarInputStream.getNextEntry();
        while (zipEntry != null) {
            object4 = zipEntry.getName();
            if (!((String)object4).equals("com/memoire/vainstall/resources/vainstall.properties")) {
                if (((String)object4).equals(this.installClassName_ + ".class")) {
                    fileOutputStream = new FileOutputStream(file2.getAbsolutePath() + File.separator + this.installClassName_ + ".class");
                    byArray = new byte[2048];
                    n = jarInputStream.read(byArray);
                    while (n > 0) {
                        fileOutputStream.write(byArray, 0, n);
                        n = jarInputStream.read(byArray);
                    }
                    fileOutputStream.close();
                } else if (!((String)object4).endsWith(".zip")) {
                    byArray = new byte[2048];
                    object3 = new ByteArrayOutputStream();
                    while ((n = jarInputStream.read(byArray)) != -1) {
                        ((ByteArrayOutputStream)object3).write(byArray, 0, n);
                    }
                    object2 = new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray());
                    ((ByteArrayOutputStream)object3).close();
                    object = new ZipEntry((String)object4);
                    CRC32 cRC32 = new CRC32();
                    ((ZipEntry)object).setCrc(cRC32.getValue());
                    ((ZipEntry)object).setSize(((ByteArrayOutputStream)object3).toByteArray().length);
                    jarOutputStream.putNextEntry((ZipEntry)object);
                    byArray = new byte[512];
                    n = ((ByteArrayInputStream)object2).read(byArray, 0, byArray.length);
                    while (n > 0) {
                        cRC32.update(byArray, 0, n);
                        jarOutputStream.write(byArray, 0, n);
                        n = ((ByteArrayInputStream)object2).read(byArray, 0, byArray.length);
                    }
                    ((ByteArrayInputStream)object2).close();
                    ((ZipEntry)object).setCrc(cRC32.getValue());
                    jarOutputStream.closeEntry();
                }
            }
            jarInputStream.closeEntry();
            zipEntry = jarInputStream.getNextEntry();
        }
        object4 = this.getClass().getResourceAsStream("resources/vainstall.properties");
        object3 = new Properties();
        try {
            ((Properties)object3).load((InputStream)object4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.language == null) {
            this.language = "default";
        }
        ((Properties)object3).setProperty("vainstall.destination.language", this.language);
        object2 = new ZipEntry("com/memoire/vainstall/resources/vainstall.properties");
        object = new CRC32();
        ((ZipEntry)object2).setCrc(((CRC32)object).getValue());
        ((ZipEntry)object2).setSize(((Properties)object3).size());
        jarOutputStream.putNextEntry((ZipEntry)object2);
        ((Properties)object3).store(jarOutputStream, "VAInstall 0.21");
        ((ZipEntry)object2).setCrc(((CRC32)object).getValue());
        jarOutputStream.closeEntry();
        jarInputStream.close();
        jarOutputStream.close();
        fileInputStream.close();
        return file3;
    }

    private Object[] generateLaunchScripts(ObjectInputStream objectInputStream, LogInfo logInfo) throws IOException {
        VAInstallStep vAInstallStep = (VAInstallStep)this.step_;
        Vector vector = null;
        try {
            vector = (Vector)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.ui_.showError(new Exception(VAGlobals.i18n("Setup_UnableToGenerateScripts")));
            return null;
        }
        if (vector == null) {
            vAInstallStep.status(VAGlobals.i18n("Setup_NoLaunchScript"));
            VAGlobals.printDebug("No launch script");
            return null;
        }
        if (!IS_WIN && !IS_UNIX) {
            this.ui_.showError(new Exception(VAGlobals.i18n("Setup_SorryScriptsNotSupported")));
            return null;
        }
        String string = System.getProperty("line.separator");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < vector.size(); ++i) {
            String string2;
            String[] stringArray;
            String[] stringArray2;
            String string3;
            int n;
            Object object;
            Object object2;
            String string4;
            StringTokenizer stringTokenizer;
            String string5;
            String[] stringArray3 = new String[6];
            String string6 = (String)vector.get(i);
            String string7 = "";
            if (IS_WIN) {
                string7 = string7 + "REM Launch script" + string;
                string7 = string7 + string;
            } else {
                string7 = string7 + "#!/bin/sh" + string;
                string7 = string7 + "### Launch Script for " + VAGlobals.APP_NAME + string;
                string7 = string7 + string;
            }
            if (!IS_WIN) {
                string7 = string7 + "VA_APP_HOME=`dirname $0`" + string;
            }
            if ("JavaLauncher".equals(string5 = (stringTokenizer = new StringTokenizer(string6, "\n")).nextToken())) {
                string5 = stringTokenizer.nextToken();
                string4 = string5.substring(string5.indexOf(61) + 1);
                string5 = stringTokenizer.nextToken();
                string5 = string5.substring(string5.indexOf(61) + 1);
                object2 = new StringTokenizer(string5, ",");
                object = new String[((StringTokenizer)object2).countTokens()];
                n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object[n++] = ((StringTokenizer)object2).nextToken();
                }
                string5 = stringTokenizer.nextToken();
                string3 = string5.substring(string5.indexOf(61) + 1);
                string5 = stringTokenizer.nextToken();
                string5 = string5.substring(string5.indexOf(61) + 1);
                object2 = new StringTokenizer(string5, ",");
                stringArray2 = new String[((StringTokenizer)object2).countTokens()];
                n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    stringArray2[n++] = ((StringTokenizer)object2).nextToken();
                }
                string5 = stringTokenizer.nextToken();
                string5 = string5.substring(string5.indexOf(61) + 1);
                object2 = new StringTokenizer(string5, ",");
                stringArray = new String[((StringTokenizer)object2).countTokens()];
                n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    stringArray[n++] = ((StringTokenizer)object2).nextToken();
                }
                if ("console".equals(string3)) {
                    string7 = string7 + "\"" + JAVA_EXE + "\"";
                    stringArray3[1] = JAVA_EXE;
                } else {
                    string7 = string7 + "\"" + JAVAW_EXE + "\"";
                    stringArray3[1] = JAVAW_EXE;
                }
                stringArray3[2] = "";
                for (n = 0; n < stringArray2.length; ++n) {
                    string7 = string7 + " " + stringArray2[n];
                    stringArray3[2] = stringArray3[2] + " " + stringArray2[n];
                }
                if (((String[])object).length > 0) {
                    string7 = string7 + " -cp \"";
                    stringArray3[3] = " -cp \"";
                }
                for (n = 0; n < ((String[])object).length; ++n) {
                    string2 = "";
                    if (n > 0) {
                        string2 = string2 + File.pathSeparator;
                    }
                    if (!IS_WIN && !object[n].startsWith("/")) {
                        string2 = string2 + "$VA_APP_HOME/";
                    }
                    string2 = string2 + object[n];
                    string2 = string2.replace('/', File.separatorChar);
                    string7 = string7 + string2;
                    stringArray3[3] = stringArray3[3] + string2;
                }
                if (((String[])object).length > 0) {
                    string7 = string7 + "\"";
                    stringArray3[3] = stringArray3[3] + "\"";
                }
                string7 = string7 + " " + string4;
                stringArray3[4] = " " + string4;
                stringArray3[5] = "";
                for (n = 0; n < stringArray.length; ++n) {
                    string7 = string7 + " \"" + stringArray[n] + "\"";
                    stringArray3[5] = stringArray3[5] + " \"" + stringArray[n] + "\"";
                }
                string7 = IS_WIN ? string7 + " %1 %2 %3 %4 %5 %6 %7 %8 %9" : string7 + " $*";
            } else if ("JarLauncher".equals(string5)) {
                string5 = stringTokenizer.nextToken();
                string4 = string5.substring(string5.indexOf(61) + 1);
                string5 = stringTokenizer.nextToken();
                string5 = string5.substring(string5.indexOf(61) + 1);
                object2 = new StringTokenizer(string5, ",");
                object = new String[((StringTokenizer)object2).countTokens()];
                n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object[n++] = ((StringTokenizer)object2).nextToken();
                }
                string5 = stringTokenizer.nextToken();
                string3 = string5.substring(string5.indexOf(61) + 1);
                string5 = stringTokenizer.nextToken();
                string5 = string5.substring(string5.indexOf(61) + 1);
                object2 = new StringTokenizer(string5, ",");
                stringArray2 = new String[((StringTokenizer)object2).countTokens()];
                n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    stringArray2[n++] = ((StringTokenizer)object2).nextToken();
                }
                string5 = stringTokenizer.nextToken();
                string5 = string5.substring(string5.indexOf(61) + 1);
                object2 = new StringTokenizer(string5, ",");
                stringArray = new String[((StringTokenizer)object2).countTokens()];
                n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    stringArray[n++] = ((StringTokenizer)object2).nextToken();
                }
                if ("console".equals(string3)) {
                    string7 = string7 + "\"" + JAVA_EXE + "\"";
                    stringArray3[1] = JAVA_EXE;
                } else {
                    string7 = string7 + "\"" + JAVAW_EXE + "\"";
                    stringArray3[1] = JAVAW_EXE;
                }
                stringArray3[2] = "";
                for (n = 0; n < stringArray2.length; ++n) {
                    string7 = string7 + " " + stringArray2[n];
                    stringArray3[2] = stringArray3[2] + " " + stringArray2[n];
                }
                if (((String[])object).length > 0) {
                    string7 = string7 + " -cp \"";
                    stringArray3[3] = " -cp \"";
                    for (n = 0; n < ((String[])object).length; ++n) {
                        string2 = "";
                        if (n > 0) {
                            string2 = string2 + File.pathSeparator;
                        }
                        if (!IS_WIN && !object[n].startsWith("/")) {
                            string2 = string2 + "$VA_APP_HOME/";
                        }
                        string2 = string2 + object[n];
                        string2 = string2.replace('/', File.separatorChar);
                        string7 = string7 + string2;
                        stringArray3[3] = stringArray3[3] + string2;
                    }
                    string7 = string7 + "\"";
                    stringArray3[3] = stringArray3[3] + "\"";
                }
                if (!IS_WIN && !string4.startsWith("/")) {
                    string4 = "$VA_APP_HOME/" + string4;
                }
                string7 = string7 + " -jar " + string4;
                stringArray3[4] = " -jar " + string4;
                stringArray3[5] = "";
                for (n = 0; n < stringArray.length; ++n) {
                    string7 = string7 + " \"" + stringArray[n] + "\"";
                    stringArray3[5] = stringArray3[5] + " \"" + stringArray[n] + "\"";
                }
                string7 = IS_WIN ? string7 + " %1 %2 %3 %4 %5 %6 %7 %8 %9" : string7 + " $*";
            } else {
                this.ui_.showError(new Exception(VAGlobals.i18n("Setup_UnSupportedScriptSkipping")));
                return null;
            }
            string5 = stringTokenizer.nextToken();
            stringArray3[0] = string4 = string5.substring(string5.indexOf(61) + 1);
            string4 = this.computeLocalPath(string4);
            string4 = IS_WIN ? string4 + ".bat" : string4 + ".sh";
            object2 = new File(string4);
            vAInstallStep.details(((File)object2).getAbsolutePath());
            if (!logInfo.oldlog.contains(((File)object2).getAbsolutePath())) {
                logInfo.log.println(((File)object2).getAbsolutePath());
            }
            object = new PrintWriter(new FileWriter((File)object2));
            ((PrintWriter)object).println(string7);
            ((PrintWriter)object).close();
            arrayList.add(stringArray3);
        }
        return arrayList.toArray();
    }

    private void generateUninstallScripts(File file, LogInfo logInfo) throws IOException {
        VAInstallStep vAInstallStep = (VAInstallStep)this.step_;
        if (!IS_WIN && !IS_UNIX) {
            this.ui_.showError(new Exception(VAGlobals.i18n("Setup_NotGenerateScript")));
            return;
        }
        if (!(file = new File(file, "vai_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION)).exists() && !file.mkdirs()) {
            this.ui_.showError(new Exception(VAGlobals.i18n("Setup_NotCreateDirectory") + " " + file));
            return;
        }
        File[] fileArray = new File(VAGlobals.DEST_PATH).listFiles(new SetupFileFilter("uninstall_" + VAGlobals.APP_NAME + "_", 1, 1));
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
        String string = "uninstall_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION;
        string = this.computeLocalPath(string);
        string = IS_WIN ? string + ".bat" : string + ".sh";
        vAInstallStep.details(string);
        File file2 = new File(string);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        logInfo.log.println(file2.getAbsolutePath());
        if (IS_WIN) {
            printWriter.println("REM Uninstall script for " + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION);
            printWriter.println();
        } else {
            printWriter.println("#!/bin/sh");
            printWriter.println("### Uninstall script for " + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION);
            printWriter.println();
            printWriter.println("stty -icanon");
        }
        String string2 = "";
        string2 = string2 + "\"" + JAVA_EXE + "\"" + " -cp \"" + file.getAbsolutePath() + "\" ";
        if ("no".equalsIgnoreCase(System.getProperty("bluescreen"))) {
            string2 = string2 + "-Dbluescreen=no ";
        }
        string2 = string2 + this.installClassName_ + " uninstall \"" + file.getAbsolutePath() + "\"";
        printWriter.println(string2);
        if (IS_UNIX) {
            printWriter.println("stty icanon");
        }
        printWriter.close();
    }

    private Vector loadLogFile(File file) throws IOException {
        Vector<String> vector = new Vector<String>();
        if (file == null) {
            return vector;
        }
        File file2 = new File(file.getAbsolutePath() + File.separator + "vai_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION + File.separator + "uninstall.vai");
        if (file2 != null && file2.exists()) {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file2));
            String string = lineNumberReader.readLine();
            while (string != null) {
                vector.add(string);
                string = lineNumberReader.readLine();
            }
            lineNumberReader.close();
        } else {
            VAGlobals.printDebug("log not found" + file.getAbsoluteFile());
        }
        return vector;
    }

    private void unzip(InputStream inputStream, int n, File file, boolean bl, LogInfo logInfo, File file2) throws IOException {
        Object object;
        Object object2;
        VAInstallStep vAInstallStep = (VAInstallStep)this.step_;
        int n2 = 0;
        ZipInputStream zipInputStream = new ZipInputStream(new GZIPInputStream(inputStream));
        vAInstallStep.setProgression(0);
        this.dirty_ = true;
        Vector vector = this.loadLogFile(file2);
        PrintWriter printWriter = logInfo.log;
        logInfo.oldlog = vector;
        for (int i = 1; i < vector.size(); ++i) {
            object = object2 = (String)vector.get(i);
            int n3 = ((String)object2).lastIndexOf(File.separator);
            if (n3 > 0) {
                object = ((String)object2).substring(n3 + 1);
            }
            if (((String)object).startsWith("uninstall_" + VAGlobals.APP_NAME + "_")) continue;
            printWriter.println((String)object2);
        }
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            object2 = new File(this.computeLocalPath(zipEntry.getName()));
            if (zipEntry.isDirectory()) {
                if (!((File)object2).exists()) {
                    this.makeDirs((File)object2, logInfo);
                    zipInputStream.closeEntry();
                }
            } else {
                object = ((File)object2).getParentFile();
                if (object != null && !((File)object).exists()) {
                    this.makeDirs((File)object, logInfo);
                }
                vAInstallStep.details("F " + object2);
                FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
                byte[] byArray = new byte[4096];
                int n4 = zipInputStream.read(byArray, 0, byArray.length);
                while (n4 > 0) {
                    fileOutputStream.write(byArray, 0, n4);
                    n4 = zipInputStream.read(byArray, 0, byArray.length);
                }
                this.stats_.addFile((File)object2, true);
                if (!vector.contains(((File)object2).getAbsolutePath())) {
                    printWriter.println(((File)object2).getAbsolutePath());
                }
                vAInstallStep.setProgression(++n2 * 100 / n);
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
    }

    private void makeDirs(File file, LogInfo logInfo) throws IOException {
        VAInstallStep vAInstallStep = (VAInstallStep)this.step_;
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            this.makeDirs(file2, logInfo);
        }
        vAInstallStep.details("D " + file);
        if (file.mkdir()) {
            this.stats_.addDirectory(file, true);
            if (!logInfo.oldlog.contains(file.getAbsolutePath())) {
                logInfo.log.println(file.getAbsolutePath());
            }
        } else {
            throw new IOException(VAGlobals.i18n("Setup_NotCreateDirectory") + " " + file);
        }
    }

    protected void removeBackups() {
        File file = new File(this.sharedDir_, "vai_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION);
        if (this.uInfo_ == null || !this.uInfo_.upgrade) {
            return;
        }
        File file2 = new File(this.sharedDir_, "vai_" + VAGlobals.APP_NAME + "_" + this.uInfo_.lastVersion());
        if (file.equals(file2)) {
            file2 = new File(file.getAbsolutePath() + ".bak");
        }
        if (file2.exists()) {
            this.deleteDirRecursive(file2);
        }
    }

    protected void updateWindowsRegistry(File file, boolean bl, String string) throws IOException {
        RegistryKey registryKey;
        File file2 = new File(file.getAbsolutePath() + File.separator + "vai_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION);
        if (bl) {
            try {
                registryKey = Registry.HKEY_LOCAL_MACHINE.openSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", 2);
                registryKey.deleteSubKey(VAGlobals.APP_NAME + " " + string);
                registryKey.closeKey();
            }
            catch (Exception exception) {
                this.ui_.showError(new Exception(VAGlobals.i18n("Setup_NotDeleteRegistryKey") + " " + VAGlobals.APP_NAME + " " + string));
            }
        }
        try {
            registryKey = Registry.HKEY_LOCAL_MACHINE.createSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + VAGlobals.APP_NAME + " " + VAGlobals.APP_VERSION, "", 2);
            RegStringValue regStringValue = new RegStringValue(registryKey, "DisplayName");
            regStringValue.setData(VAGlobals.APP_NAME + " " + VAGlobals.APP_VERSION);
            registryKey.setValue(regStringValue);
            RegStringValue regStringValue2 = new RegStringValue(registryKey, "UninstallString");
            String string2 = "";
            string2 = string2 + "\"" + JAVA_EXE + "\"" + " -cp \"" + file2.getAbsolutePath() + "\" ";
            if ("no".equalsIgnoreCase(System.getProperty("bluescreen"))) {
                string2 = string2 + "-Dbluescreen=no ";
            }
            string2 = string2 + this.installClassName_ + " uninstall \"" + file2.getAbsolutePath() + "\"";
            regStringValue2.setData(string2);
            registryKey.setValue(regStringValue2);
            registryKey.closeKey();
        }
        catch (Exception exception) {
            throw new IOException("" + exception);
        }
    }

    private void restoreUnixExecutables(ObjectInputStream objectInputStream) {
        VAInstallStep vAInstallStep = (VAInstallStep)this.step_;
        try {
            Vector vector = (Vector)objectInputStream.readObject();
            String[] stringArray = new String[4 + vector.size()];
            stringArray[0] = "chmod";
            stringArray[1] = "-R";
            stringArray[2] = "a+x";
            stringArray[3] = "";
            if (IS_WIN || IS_UNIX) {
                stringArray[3] = stringArray[3] + this.computeLocalPath("uninstall_" + VAGlobals.APP_NAME + "_" + VAGlobals.APP_VERSION);
                stringArray[3] = IS_WIN ? stringArray[3] + ".bat" : stringArray[3] + ".sh";
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                if (string.startsWith("[SCRIPT]")) {
                    string = string.substring(8);
                    string = IS_WIN ? string + ".bat" : string + ".sh";
                }
                stringArray[4 + i] = this.computeLocalPath(string);
                vAInstallStep.details(string);
                this.stats_.addExecutable(new File(stringArray[4 + i]));
            }
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i] + " ";
            }
            VAGlobals.printDebug(string);
            Process process = Runtime.getRuntime().exec(stringArray);
            boolean bl = true;
            while (bl) {
                try {
                    process.waitFor();
                    bl = false;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (process.exitValue() != 0) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            VAGlobals.printDebug(exception.toString());
            this.ui_.showError(new Exception(VAGlobals.i18n("Setup_ErrorRestoringExeAttributes")));
        }
    }

    public static String getWithoutMacro(String string) {
        if (string == null) {
            return "";
        }
        if (!string.startsWith("[")) {
            return string;
        }
        int n = string.indexOf(93);
        return string.substring(n + 1);
    }

    public static String expandDirectory(String string, boolean bl, UpgradeInfo upgradeInfo) throws IOException {
        String string2 = null;
        if (!string.startsWith("[")) {
            string2 = string;
        } else {
            Object object;
            int n = string.indexOf(93);
            String string3 = string.substring(1, n).trim();
            if ("HOME".equals(string3)) {
                string2 = System.getProperty("user.home");
                if (IS_WIN && IS_ROOT && string2 != null && string2.length() > 3 && string2.charAt(1) == ':') {
                    string2 = string2.substring(0, 3);
                }
            } else if ("C:".equals(string3)) {
                if (IS_WIN) {
                    string2 = "C:\\";
                } else if (IS_UNIX) {
                    string2 = "/";
                } else if (IS_MAC) {
                    string2 = ":";
                }
            } else if ("PROGRAM".equals(string3)) {
                if (!IS_ROOT) {
                    string2 = System.getProperty("user.home");
                } else if (IS_WIN) {
                    try {
                        object = Registry.HKEY_LOCAL_MACHINE.openSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion");
                        string2 = ((RegistryKey)object).getStringValue("ProgramFilesDir");
                        ((RegistryKey)object).closeKey();
                    }
                    catch (Exception exception) {
                        if (bl) {
                            throw new IOException(exception.getMessage());
                        }
                        string2 = null;
                    }
                    if (string2 == null) {
                        VAGlobals.printDebug("Could not find program dir in registry:");
                        VAGlobals.printDebug("using 'C:\\Program Files'");
                        string2 = "C:\\Program Files";
                    }
                } else if (IS_UNIX) {
                    string2 = "/usr/local";
                }
            } else if ("UPDATE".equals(string3)) {
                if (upgradeInfo.versions == null) {
                    upgradeInfo.forceUpgrade = true;
                    return string;
                }
                string2 = upgradeInfo.lastPath().getAbsolutePath();
            } else if ("MODULE".equals(string3)) {
                if (upgradeInfo.versions == null) {
                    upgradeInfo.forceUpgrade = true;
                    upgradeInfo.module = true;
                    return string;
                }
                string2 = upgradeInfo.lastPath().getAbsolutePath();
            } else if (string3.length() == 2 && string3.endsWith(":")) {
                if (IS_WIN) {
                    string2 = string3.substring(0, 2) + File.separator;
                } else if (IS_UNIX) {
                    string2 = "/";
                }
            }
            object = "";
            if (string.length() > n + 1 && ((String)(object = (String)object + string.substring(n + 1).trim())).startsWith("/")) {
                object = ((String)object).substring(1);
            }
            if (string2 == null) {
                if (bl) {
                    throw new IOException(VAGlobals.i18n("Setup_InvalidDir") + string);
                }
                string2 = System.getProperty("user.dir");
            }
            string2 = string2 + File.separator + (String)object;
        }
        return string2;
    }

    private String computeLocalPath(String string) throws IOException {
        String string2 = Setup.expandDirectory(string, false, this.uInfo_);
        if (string2 == null) {
            throw new IOException(VAGlobals.i18n("Setup_InvalidPath") + string);
        }
        if (!(string2.startsWith("/") || string2.startsWith("C:\\") || string2.startsWith(":"))) {
            string2 = VAGlobals.DEST_PATH + "/" + string2;
        }
        return string2.replace('/', File.separatorChar);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

