/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall;

import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import com.memoire.vainstall.AbstractInstall;
import com.memoire.vainstall.Setup;
import com.memoire.vainstall.VAEndStep;
import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.VAInstallStep;
import com.memoire.vainstall.VAStepFactory;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Vector;

public class Uninstall
extends AbstractInstall {
    private File uninstlog_;
    private String customPrePostClassName_;
    static /* synthetic */ Class class$com$memoire$vainstall$VAInstallStep;

    public Uninstall(String string, String string2, String string3, String string4, String string5, String string6) {
        VAGlobals.UI_MODE = System.getProperty("uimode", string);
        VAGlobals.UI_BLUESCREEN = !"no".equals(string2);
        String string7 = System.getProperty("bluescreen");
        if (string7 != null) {
            VAGlobals.UI_BLUESCREEN = !"no".equalsIgnoreCase(string7);
        }
        VAGlobals.UI_BLUESCREEN_COLOR = string3 == null || "".equals(string3) || "null".equals(string3) ? null : new Color(Integer.parseInt(string3, 16));
        VAGlobals.IMAGE = "com/memoire/vainstall/resources/banner.gif";
        VAGlobals.APP_NAME = string4;
        VAGlobals.APP_VERSION = string5;
        VAGlobals.DEST_PATH = string6;
        VAGlobals.OPERATION = 2;
        InputStream inputStream = this.getClass().getResourceAsStream("resources/vainstall.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.language = properties.getProperty("vainstall.destination.language");
        if (this.language != null) {
            VAGlobals.setLanguage(this.language);
        } else {
            VAGlobals.setLanguage("default");
        }
        this.customPrePostClassName_ = properties.getProperty("vainstall.install.customprepost.className");
        this.ui_ = VAStepFactory.createUI(VAGlobals.UI_MODE, this);
        VAGlobals.printDebug("UI created");
        this.uninstlog_ = new File(string6 + File.separator + "uninstall.vai");
        if (!this.uninstlog_.exists() || !this.uninstlog_.canRead()) {
            this.exitOnError(new IOException(this.uninstlog_.getName() + " " + VAGlobals.i18n("Uninstall_NotBeRead")));
        }
        this.nextStep();
        this.ui_.activateUI();
    }

    public void nextStep() {
        switch (this.state_) {
            case 1: {
                this.state_ = 2;
                this.setActionEnabled(5);
                this.step_ = this.ui_.createWelcomeStep();
                break;
            }
            case 2: {
                this.state_ = 8;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createInstallStep();
                break;
            }
            case 8: {
                this.setActionEnabled(0);
                this.startUninstall();
                this.setActionEnabled(4);
                this.state_ = 10;
                this.setActionEnabled(8);
                this.step_ = this.ui_.createEndStep();
                ((VAEndStep)this.step_).setStats(this.stats_);
                break;
            }
            case 10: {
                this.ui_.quitUI();
                this.quit();
            }
        }
    }

    public void previousStep() {
        switch (this.state_) {
            case 8: {
                VAGlobals.printDebug("WELCOME");
                this.state_ = 2;
                this.setActionEnabled(5);
                this.step_ = this.ui_.createWelcomeStep();
                break;
            }
            default: {
                VAGlobals.printDebug("can't go back...");
            }
        }
    }

    private void startUninstall() {
        VAInstallStep vAInstallStep = (VAInstallStep)this.step_;
        try {
            vAInstallStep.setProgression(0);
            if (this.customPrePostClassName_.length() > 0) {
                this.callCustom("preUninstall", vAInstallStep, VAGlobals.i18n("Custom_Preparing..."));
            }
            vAInstallStep.status(VAGlobals.i18n("Uninstall_DeletingFiles"));
            Vector vector = this.deleteFiles(this.uninstlog_);
            vAInstallStep.setProgression(50);
            vAInstallStep.status(VAGlobals.i18n("Uninstall_DeletingDirectories"));
            this.deleteDirectories(vector);
            vAInstallStep.setProgression(60);
            this.cleanShortcuts(this.uninstlog_.getParentFile());
            vAInstallStep.setProgression(90);
            vAInstallStep.status(VAGlobals.i18n("Uninstall_DeletingUninstallDirectory"));
            this.deleteDirRecursive(new File(VAGlobals.DEST_PATH));
            vAInstallStep.setProgression(100);
            if (IS_WIN) {
                vAInstallStep.status(VAGlobals.i18n("Uninstall_UpdatingWindowsRegistry"));
                this.updateWindowsRegistry();
                this.ui_.uiSleep(2000L);
                vAInstallStep.status(VAGlobals.i18n("Uninstall_WindowsRegistryUpdated"));
                this.ui_.uiSleep(1000L);
                new File("ICE_JNIRegistry.dll").delete();
            }
            if (this.customPrePostClassName_.length() > 0) {
                this.callCustom("postUninstall", vAInstallStep, VAGlobals.i18n("Custom_Mopping..."));
            }
            vAInstallStep.status(VAGlobals.i18n("Uninstall_UninstallationComplete"));
        }
        catch (Exception exception) {
            this.exitOnError(exception);
        }
    }

    public void redoStep() {
        switch (this.state_) {
            case 1: {
                this.setActionEnabled(5);
                this.step_ = this.ui_.createSetupLanguageStep();
                break;
            }
            case 2: {
                this.setActionEnabled(7);
                this.step_ = this.ui_.createWelcomeStep();
                break;
            }
            case 8: {
                this.setActionEnabled(7);
                this.step_ = this.ui_.createInstallStep();
                break;
            }
            case 10: {
                this.setActionEnabled(8);
                this.step_ = this.ui_.createEndStep();
                ((VAEndStep)this.step_).setStats(this.stats_);
            }
        }
    }

    protected void updateWindowsRegistry() throws IOException {
        try {
            RegistryKey registryKey = Registry.HKEY_LOCAL_MACHINE.openSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", 2);
            registryKey.deleteSubKey(VAGlobals.APP_NAME + " " + VAGlobals.APP_VERSION);
            registryKey.closeKey();
        }
        catch (Exception exception) {
            throw new IOException("" + exception);
        }
    }

    private void callCustom(String string, VAInstallStep vAInstallStep, String string2) throws Exception {
        vAInstallStep.status(string2);
        VAGlobals.printDebug("begin custom " + string);
        Class<?> clazz = Class.forName(this.customPrePostClassName_);
        Method method = clazz.getMethod(string, class$com$memoire$vainstall$VAInstallStep == null ? (class$com$memoire$vainstall$VAInstallStep = Uninstall.class$("com.memoire.vainstall.VAInstallStep")) : class$com$memoire$vainstall$VAInstallStep);
        boolean bl = Setup.callReflect(method, new Object[]{vAInstallStep});
        if (!bl) {
            VAGlobals.printDebug("custom pre/post-uninstall returned false");
            throw new IOException(VAGlobals.i18n("Uninstall_CustomFailed"));
        }
        VAGlobals.printDebug("end custom " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

