/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.UIManager;

public class VAGlobals {
    public static final boolean DEBUG = "yes".equals(System.getProperty("DEBUG"));
    public static final String NAME = "VAInstall";
    public static final String VERSION = "0.21";
    public static final String AUTHOR = "Axel von Arnim";
    public static final String COPYRIGHT = "2000-2002";
    public static final String LICENSE = "GPL2";
    public static final String HTTP = "http://www.ifrance.com/vonarnim/vainstall";
    public static final String EMAIL = "vonarnim@club-internet.fr";
    public static final Class BASE_CLASS = new VAGlobals().getClass();
    public static final int UNKNOWN = 0;
    public static final int INSTALL = 1;
    public static final int UNINSTALL = 2;
    public static final int UPDATE = 3;
    public static int OPERATION = 0;
    public static String UI_MODE;
    public static boolean UI_BLUESCREEN;
    public static Color UI_BLUESCREEN_COLOR;
    public static String IMAGE;
    public static String DEST_PATH;
    public static String APP_NAME;
    public static String APP_VERSION;
    public static String JNI_DLL_FILE;
    public static String LINK_SECTION_NAME;
    public static String LINK_SECTION_ICON;
    public static String LINK_ENTRY_NAME;
    public static String LINK_ENTRY_ICON;
    public static boolean CREATE_UNINSTALL_SHORTCUT;
    public static String[][] languages;
    private static String[] allSupportedLanguages;
    private static String[] supportedLanguages;
    private static Locale locale;
    private static String currentLanguage;
    private static Hashtable resourceList;

    public static void printDebug(String string) {
        if (DEBUG) {
            System.err.println(string);
        }
    }

    public static String i18n(String string) {
        String string2 = null;
        try {
            string2 = VAGlobals.getResource("com.memoire.vainstall.Language", string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 == null) {
            try {
                string2 = VAGlobals.getResource("com.memoire.vainstall.gui.Language", string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            try {
                string2 = VAGlobals.getResource("com.memoire.vainstall.xui.Language", string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            try {
                string2 = VAGlobals.getResource("com.memoire.vainstall.tui.Language", string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static String i18n(String string, Object[] objectArray) {
        String string2 = VAGlobals.i18n(string);
        if (string2 != null && objectArray != null) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    public static String getResource(String string, String string2) throws MissingResourceException {
        if (locale == null || DEBUG) {
            locale = new Locale("en", "UK");
        }
        if (resourceList == null) {
            resourceList = new Hashtable();
        }
        if (!resourceList.contains(string)) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
            resourceList.put(string, resourceBundle);
            return resourceBundle.getString(string2);
        }
        return ((ResourceBundle)resourceList.get(string)).getString(string2);
    }

    public static int getResourceInt(String string, String string2) throws MissingResourceException {
        if (locale == null) {
            locale = new Locale("en", "UK");
        }
        if (resourceList == null) {
            resourceList = new Hashtable();
        }
        if (!resourceList.contains(string)) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
            resourceList.put(string, resourceBundle);
            Integer n = (Integer)resourceBundle.getObject(string2);
            return n;
        }
        Integer n = (Integer)((ResourceBundle)resourceList.get(string)).getObject(string2);
        return n;
    }

    public static void setLanguage(String string) {
        if (resourceList != null) {
            resourceList.clear();
        }
        if (string.toLowerCase().indexOf("choose") != -1) {
            int n;
            if (string.equalsIgnoreCase("choose")) {
                VAGlobals.setLanguage("default");
                return;
            }
            Vector<String> vector = new Vector<String>();
            String[] stringArray = VAGlobals.getAllSupportedLanguages();
            Locale locale = Locale.getDefault();
            for (int i = 0; i < languages.length; ++i) {
                if (!locale.getLanguage().equals(languages[i][2])) continue;
                currentLanguage = languages[i][0];
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                string2 = string2.trim().toLowerCase();
                for (n = 0; n < languages.length; ++n) {
                    if (!string2.equals(languages[n][0])) continue;
                    if (string2.equals(currentLanguage)) {
                        vector.insertElementAt(languages[n][0], 0);
                        continue;
                    }
                    vector.addElement(languages[n][0]);
                }
            }
            supportedLanguages = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                for (n = 0; n < languages.length; ++n) {
                    if (!vector.elementAt(i).equals(languages[n][0])) continue;
                    VAGlobals.supportedLanguages[i] = languages[n][1];
                }
            }
            VAGlobals.setLanguage("default");
            return;
        }
        if (string.equals("default")) {
            Locale locale = Locale.getDefault();
            String string3 = locale.getLanguage();
            for (int i = 0; i < languages.length; ++i) {
                if (!string3.equals(languages[i][2])) continue;
                currentLanguage = languages[i][0];
                VAGlobals.locale = new Locale(languages[i][2], languages[i][3]);
            }
        } else {
            for (int i = 0; i < languages.length; ++i) {
                if (!string.equals(languages[i][0])) continue;
                currentLanguage = languages[i][0];
                locale = new Locale(languages[i][2], languages[i][3]);
            }
        }
        UIManager.put("OptionPane.yesButtonText", VAGlobals.getResource("com.memoire.vainstall.Language", "Common_OptionPane.yesButtonText"));
        UIManager.put("OptionPane.noButtonText", VAGlobals.getResource("com.memoire.vainstall.Language", "Common_OptionPane.noButtonText"));
        UIManager.put("OptionPane.okButtonText", VAGlobals.getResource("com.memoire.vainstall.Language", "Common_OptionPane.okButtonText"));
        UIManager.put("OptionPane.cancelButtonText", VAGlobals.getResource("com.memoire.vainstall.Language", "Common_OptionPane.cancelButtonText"));
    }

    public static String[] getSupportedLanguages() {
        if (supportedLanguages == null) {
            supportedLanguages = new String[languages.length];
            for (int i = 0; i < languages.length; ++i) {
                VAGlobals.supportedLanguages[i] = languages[i][1];
            }
        }
        return supportedLanguages;
    }

    public static String[] getAllSupportedLanguages() {
        if (allSupportedLanguages == null) {
            allSupportedLanguages = new String[languages.length];
            for (int i = 0; i < languages.length; ++i) {
                VAGlobals.allSupportedLanguages[i] = languages[i][1];
            }
        }
        return allSupportedLanguages;
    }

    public static String getCurrentLanguage() {
        return currentLanguage;
    }

    public static int suggestLanguage() {
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        int n = -1;
        for (int i = 0; i < languages.length; ++i) {
            if (!string.equals(languages[i][2])) continue;
            if (string2.equals(languages[i][3])) {
                return i;
            }
            if (n != -1) continue;
            n = i;
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    static {
        languages = new String[][]{{"danish", "Danish", "da", "DK"}, {"german", "Deutsch", "de", "DE"}, {"english", "English", "en", "UK"}, {"french", "Fran\u00e7ais", "fr", "FR"}, {"italian", "Italian", "it", "IT"}, {"japanese", "Japanese", "ja", "JP"}};
        resourceList = null;
    }
}

