/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall;

import com.memoire.vainstall.VAGlobals;
import java.io.File;
import java.util.Vector;

public class VAStats {
    public static final boolean SUCCESS = true;
    public static final boolean FAILURE = false;
    Vector dirs_ = new Vector();
    Vector files_ = new Vector();
    Vector exes_ = new Vector();
    int nbDirSucc_ = 0;
    int nbFileSucc_ = 0;

    public void addFile(File file, boolean bl) {
        if (bl) {
            if (file.isDirectory()) {
                ++this.nbDirSucc_;
            } else {
                ++this.nbFileSucc_;
            }
        } else if (file.isDirectory()) {
            this.dirs_.add(file);
        } else {
            this.files_.add(file);
        }
    }

    public void addDirectory(File file, boolean bl) {
        if (bl) {
            ++this.nbDirSucc_;
        } else {
            this.dirs_.add(file);
        }
    }

    public void addExecutable(File file) {
        this.exes_.add(file);
    }

    public File[] getSuccessfulDirs() {
        return new File[this.nbDirSucc_];
    }

    public File[] getSuccessfulFiles() {
        return new File[this.nbFileSucc_];
    }

    public File[] getExecutables() {
        File[] fileArray = new File[this.exes_.size()];
        for (int i = 0; i < this.exes_.size(); ++i) {
            fileArray[i] = (File)this.exes_.get(i);
        }
        return fileArray;
    }

    public File[] getFailedDirs() {
        File[] fileArray = new File[this.dirs_.size()];
        for (int i = 0; i < this.dirs_.size(); ++i) {
            fileArray[i] = (File)this.dirs_.get(i);
        }
        return fileArray;
    }

    public File[] getFailedFiles() {
        File[] fileArray = new File[this.files_.size()];
        for (int i = 0; i < this.files_.size(); ++i) {
            fileArray[i] = (File)this.files_.get(i);
        }
        return fileArray;
    }

    public String getSuccessReport() {
        String string = "";
        switch (VAGlobals.OPERATION) {
            case 1: 
            case 3: {
                string = string + VAGlobals.i18n("VAStats_CreatedDirectories") + " " + this.nbDirSucc_ + "\n";
                string = string + VAGlobals.i18n("VAStats_CreatedFiles") + " " + this.nbFileSucc_ + "\n";
                break;
            }
            case 2: {
                string = string + VAGlobals.i18n("VAStats_DeletedDirectories") + " " + this.nbDirSucc_ + "\n";
                string = string + VAGlobals.i18n("VAStats_DeletedFiles") + " " + this.nbFileSucc_ + "\n";
            }
        }
        return string;
    }

    public String getFailureReport() {
        int n;
        String string = "";
        if (this.dirs_.size() > 0) {
            switch (VAGlobals.OPERATION) {
                case 1: 
                case 3: {
                    string = string + VAGlobals.i18n("VAStats_NotCreateDirectories") + "\n";
                    break;
                }
                case 2: {
                    string = string + VAGlobals.i18n("VAStats_NotRemoveDirectories") + "\n";
                }
            }
            for (n = 0; n < this.dirs_.size(); ++n) {
                string = string + "  " + ((File)this.dirs_.get(n)).getAbsolutePath() + "\n";
            }
        }
        if (this.files_.size() > 0) {
            switch (VAGlobals.OPERATION) {
                case 1: 
                case 3: {
                    string = string + VAGlobals.i18n("VAStats_NotCreateFiles") + "\n";
                    break;
                }
                case 2: {
                    string = string + VAGlobals.i18n("VAStats_NotRemoveFiles") + "\n";
                }
            }
            for (n = 0; n < this.files_.size(); ++n) {
                string = string + "  " + ((File)this.files_.get(n)).getAbsolutePath() + "\n";
            }
        }
        return string;
    }

    public String getExecutablesReport() {
        String string = "";
        if (this.exes_.size() > 0 && (VAGlobals.OPERATION == 1 || VAGlobals.OPERATION == 3)) {
            string = string + VAGlobals.i18n("VAStats_Executables") + "\n";
            for (int i = 0; i < this.exes_.size(); ++i) {
                string = string + "  " + ((File)this.exes_.get(i)).getAbsolutePath() + "\n";
            }
        }
        return string;
    }
}

