/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall;

import com.memoire.vainstall.AbstractInstall;
import com.memoire.vainstall.VAStep;
import com.memoire.vainstall.VAWizardInterface;
import java.awt.Toolkit;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class VAStepFactory {
    private static VAStepFactory UNIQUE_UI = null;
    private AbstractInstall setup_;
    private VAWizardInterface wizard_;

    private static boolean testGraphicUi(String string) {
        boolean bl = true;
        if ("graphic".equals(string) || "xtra".equals(string)) {
            try {
                Toolkit.getDefaultToolkit();
            }
            catch (Error error) {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean testTextUi(String string, AbstractInstall abstractInstall) {
        boolean bl = true;
        if (!"ansi".equals(string)) return bl;
        if (AbstractInstall.IS_WIN) return false;
        if (AbstractInstall.IS_MAC) return false;
        return true;
    }

    public static VAStepFactory createUI(String string, AbstractInstall abstractInstall) {
        if (UNIQUE_UI != null) {
            return UNIQUE_UI;
        }
        if (string == null || string.length() == 0) {
            System.err.println("No UI specified: trying graphic UI");
            return VAStepFactory.createUI("graphic", abstractInstall);
        }
        if (!VAStepFactory.testGraphicUi(string)) {
            System.err.println("No graphic display found. Switching to ansi mode");
            return VAStepFactory.createUI("ansi", abstractInstall);
        }
        if (!VAStepFactory.testTextUi(string, abstractInstall)) {
            System.err.println("Ansi not supported. Switching to text mode");
            return VAStepFactory.createUI("text", abstractInstall);
        }
        String string2 = "com.memoire.vainstall." + string.charAt(0) + "ui.VA" + Character.toUpperCase(string.charAt(0)) + string.substring(1) + "UI";
        try {
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getConstructor(null);
            Object obj = constructor.newInstance(null);
            UNIQUE_UI = (VAStepFactory)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException + ": " + string2);
            if ("graphic".equals(string)) {
                return VAStepFactory.createUI("ansi", abstractInstall);
            }
            if ("ansi".equals(string)) {
                return VAStepFactory.createUI("text", abstractInstall);
            }
            if ("text".equals(string)) {
                abstractInstall.cancel();
                return null;
            }
            System.err.println("trying graphic UI");
            return VAStepFactory.createUI("graphic", abstractInstall);
        }
        catch (ClassCastException classCastException) {
            System.err.println(classCastException);
            System.err.println("This class is not a VAStepFactory: " + string2);
            abstractInstall.cancel();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException);
            System.err.println("Please implement a void constructor for " + string2);
            abstractInstall.cancel();
        }
        catch (SecurityException securityException) {
            System.err.println(securityException);
            abstractInstall.cancel();
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException);
            System.err.println("Please don't make this class abstract: " + string2);
            abstractInstall.cancel();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
            System.err.println("Please set public access to constructor for " + string2);
            abstractInstall.cancel();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
            System.err.println("Please set no args to constructor for " + string2);
            abstractInstall.cancel();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(invocationTargetException);
            System.err.println("Exception in constructor for " + string2);
            invocationTargetException.getTargetException().printStackTrace();
            abstractInstall.cancel();
        }
        if (UNIQUE_UI != null) {
            VAStepFactory.UNIQUE_UI.setup_ = abstractInstall;
            UNIQUE_UI.initUI();
        }
        return UNIQUE_UI;
    }

    public abstract void initUI();

    public void activateUI() {
        if (this.wizard_ == null) {
            this.showError(new NullPointerException("Null wizard! Please create one or overload VAStepFactory::activateUI()"));
            this.setup_.cancel();
        }
        this.wizard_.show();
    }

    public void quitUI() {
        if (this.wizard_ != null) {
            this.wizard_.dispose(false);
        }
    }

    public abstract VAStep createSetupLanguageStep();

    public abstract VAStep createWelcomeStep();

    public abstract VAStep createLicenseStep();

    public abstract VAStep createReadmeStep();

    public abstract VAStep createLicenseKeyStep();

    public abstract VAStep createUpgradeStep();

    public abstract VAStep createDirectoryStep();

    public abstract VAStep createInstallStep();

    public abstract VAStep createShortcutStep();

    public abstract VAStep createEndStep();

    public void setActionEnabled(int n) {
        if (this.wizard_ == null) {
            this.showError(new NullPointerException("Null wizard! Please create one or overload VAStepFactory::setActionEnabled()"));
            this.setup_.cancel();
        }
        this.wizard_.setActionEnabled(n);
    }

    public void showFatalError(Throwable throwable) {
        throwable.printStackTrace();
    }

    public void showError(Throwable throwable) {
        System.err.println(throwable);
    }

    public void uiSleep(long l) {
    }

    protected AbstractInstall getInstaller() {
        return this.setup_;
    }

    protected VAWizardInterface getWizard() {
        return this.wizard_;
    }

    protected void setWizard(VAWizardInterface vAWizardInterface) {
        this.wizard_ = vAWizardInterface;
    }
}

