/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall.ant;

import com.memoire.vainstall.LicenseKeySupport;
import com.memoire.vainstall.Setup;
import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.VAProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class VAInstallTask
extends Task {
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final String JDK_HOME = System.getProperty("java.home") + File.separator + "..";
    private static String VAILOGO = null;
    private static final String[] JAR_FILES_COMMON = new String[]{"com/memoire/vainstall/Language_da_DK.class", "com/memoire/vainstall/Language_de_DE.class", "com/memoire/vainstall/Language_en_UK.class", "com/memoire/vainstall/Language_fr_FR.class", "com/memoire/vainstall/Language_ja_JP.class", "com/memoire/vainstall/Language_it_IT.class", "com/memoire/vainstall/AbstractInstall.class", "com/memoire/vainstall/Setup.class", "com/memoire/vainstall/VAClassLoader.class", "com/memoire/vainstall/SetupFileFilter.class", "com/memoire/vainstall/UpgradeInfo.class", "com/memoire/vainstall/LogInfo.class", "com/memoire/vainstall/Uninstall.class", "com/memoire/vainstall/VAGlobals.class", "com/memoire/vainstall/VAStats.class", "com/memoire/vainstall/VAStep.class", "com/memoire/vainstall/VAStepFactory.class", "com/memoire/vainstall/VAWelcomeStep.class", "com/memoire/vainstall/VAReadmeStep.class", "com/memoire/vainstall/VALanguageStep.class", "com/memoire/vainstall/VALicenseStep.class", "com/memoire/vainstall/VALicenseKeyStep.class", "com/memoire/vainstall/VADirectoryStep.class", "com/memoire/vainstall/VAInstallStep.class", "com/memoire/vainstall/VAUpgradeStep.class", "com/memoire/vainstall/VAShortcutStep.class", "com/memoire/vainstall/VAEndStep.class", "com/memoire/vainstall/VAWizardInterface.class", "com/memoire/vainstall/VALinkDebian.class", "com/memoire/vainstall/VALinkGnome.class", "com/memoire/vainstall/VALinkWindows.class", "com/memoire/vainstall/VALinkKDE.class", "com/memoire/vainstall/WindowsShortcut.class", "com/memoire/vainstall/LicenseKeySupport.class", "com/memoire/vainstall/LicenseKeySupport$FieldInfo.class", "com/memoire/vainstall/DefaultLicenseKeySupport.class", "com/memoire/vainstall/TestLicenseKeySupport.class"};
    private static final String[] JAR_FILES_JNIREGISTRY = new String[]{"ICE_JNIRegistry.dll", "com/ice/jni/registry/NoSuchKeyException.class", "com/ice/jni/registry/NoSuchValueException.class", "com/ice/jni/registry/RegBinaryValue.class", "com/ice/jni/registry/RegDWordValue.class", "com/ice/jni/registry/RegMultiStringValue.class", "com/ice/jni/registry/RegStringValue.class", "com/ice/jni/registry/Registry.class", "com/ice/jni/registry/RegistryException.class", "com/ice/jni/registry/RegistryKey.class", "com/ice/jni/registry/RegistryValue.class", "com/ice/text/HexNumberFormat.class", "com/ice/util/AWTUtilities.class", "com/ice/util/ClassUtilities.class", "com/ice/util/FileLog.class", "com/ice/util/HTTPUtilities.class", "com/ice/util/HexDump.class", "com/ice/util/StringUtilities.class", "com/ice/util/URLUtilities.class", "com/ice/util/UserProperties.class"};
    private static final String[] JAR_FILES_TEXT_UI = new String[]{"com/memoire/vainstall/tui/Language_da_DK.class", "com/memoire/vainstall/tui/Language_de_DE.class", "com/memoire/vainstall/tui/Language_en_UK.class", "com/memoire/vainstall/tui/Language_fr_FR.class", "com/memoire/vainstall/tui/Language_ja_JP.class", "com/memoire/vainstall/tui/NullOutputStream.class", "com/memoire/vainstall/tui/TuiDefaultStep.class", "com/memoire/vainstall/tui/TuiDirectoryStep.class", "com/memoire/vainstall/tui/TuiInstallStep.class", "com/memoire/vainstall/tui/TuiLanguageStep.class", "com/memoire/vainstall/tui/TuiLicenseStep.class", "com/memoire/vainstall/tui/TuiReadmeStep.class", "com/memoire/vainstall/tui/TuiShortcutStep.class", "com/memoire/vainstall/tui/TuiWelcomeStep.class", "com/memoire/vainstall/tui/TuiWizard.class", "com/memoire/vainstall/tui/VATextUI.class", "com/memoire/vainstall/tui/TuiUpgradeStep.class", "com/memoire/vainstall/tui/TuiEndStep.class"};
    private static final String[] JAR_FILES_ANSI_UI = new String[]{"com/memoire/vainstall/aui/VAAnsiUI.class"};
    private static final String[] JAR_FILES_GRAPHIC_UI = new String[]{"com/memoire/vainstall/gui/Language_da_DK.class", "com/memoire/vainstall/gui/Language_de_DE.class", "com/memoire/vainstall/gui/Language_en_UK.class", "com/memoire/vainstall/gui/Language_fr_FR.class", "com/memoire/vainstall/gui/Language_ja_JP.class", "com/memoire/vainstall/gui/VABlueScreen.class", "com/memoire/vainstall/gui/VABlueScreen$1.class", "com/memoire/vainstall/gui/VAGraphicUI.class", "com/memoire/vainstall/gui/VAWizard.class", "com/memoire/vainstall/gui/VAPanel.class", "com/memoire/vainstall/gui/VAWelcomePanel.class", "com/memoire/vainstall/gui/VAImagePanel.class", "com/memoire/vainstall/gui/VAInstallPanel.class", "com/memoire/vainstall/gui/VALanguagePanel.class", "com/memoire/vainstall/gui/VALicensePanel.class", "com/memoire/vainstall/gui/VALicenseKeyPanel.class", "com/memoire/vainstall/gui/VALicenseKeyPanel$1.class", "com/memoire/vainstall/gui/VAReadmePanel.class", "com/memoire/vainstall/gui/VADirectoryPanel.class", "com/memoire/vainstall/gui/VADirectoryPanel$1.class", "com/memoire/vainstall/gui/VAUpgradePanel.class", "com/memoire/vainstall/gui/VAShortcutPanel.class", "com/memoire/vainstall/gui/VAEndPanel.class"};
    private static final String[] JAR_FILES_XTRA_UI = new String[]{"com/memoire/vainstall/xui/Language_da_DK.class", "com/memoire/vainstall/xui/Language_de_DE.class", "com/memoire/vainstall/xui/Language_en_UK.class", "com/memoire/vainstall/xui/Language_fr_FR.class", "com/memoire/vainstall/xui/Language_ja_JP.class", "com/memoire/vainstall/xui/XuiBlueScreen.class", "com/memoire/vainstall/xui/XuiWizard.class", "com/memoire/vainstall/xui/XuiAbstractPanel.class", "com/memoire/vainstall/xui/XuiPanel.class", "com/memoire/vainstall/xui/XuiImagePanel.class", "com/memoire/vainstall/xui/XuiTitle.class", "com/memoire/vainstall/xui/XuiButton.class", "com/memoire/vainstall/xui/XuiButtonBorder.class", "com/memoire/vainstall/xui/XuiLabel.class", "com/memoire/vainstall/xui/XuiRadioButton.class", "com/memoire/vainstall/xui/XuiOptionPane.class", "com/memoire/vainstall/xui/XuiWelcomePanel.class", "com/memoire/vainstall/xui/XuiReadmePanel.class", "com/memoire/vainstall/xui/XuiLicensePanel.class", "com/memoire/vainstall/xui/XuiInstallPanel.class", "com/memoire/vainstall/xui/XuiShortcutPanel.class", "com/memoire/vainstall/xui/XuiUpgradePanel.class", "com/memoire/vainstall/xui/XuiLanguagePanel.class", "com/memoire/vainstall/xui/XuiEndPanel.class", "com/memoire/vainstall/xui/XuiDirectoryPanel$1.class", "com/memoire/vainstall/xui/XuiDirectoryPanel.class", "com/memoire/vainstall/xui/VAXtraUI.class"};
    private static final String IMAGE_KEY = "com/memoire/vainstall/resources/banner.gif";
    private File filelist_ = null;
    private String destPath_ = null;
    private String archMethod_ = null;
    private long archOffset_ = -1234567890L;
    private long installClassOffset_ = -10987654321L;
    private long installClassSize_ = -1234543210L;
    private long jarSize_;
    private String licenseKeySupportClassName_ = "com.memoire.vainstall.DefaultLicenseKeySupport";
    private String encodeKey_;
    private LicenseKeySupport licenseKeySupport_;
    private String additionalFiles_;
    private String uiMode_ = null;
    private String uiBluescreen_ = null;
    private String uiBluescreenColor_ = null;
    private String image_;
    private String appName_ = null;
    private String appVersion_ = null;
    private String linkSectionName_ = null;
    private String linkSectionIcon_ = null;
    private String linkEntryName_ = null;
    private String linkEntryIcon_ = null;
    private String instClassName_ = null;
    private String[] targets_;
    private String currentTarget_;
    private String jarAlias_ = null;
    private String jarPassphrase_ = null;
    private String jarCodebase_ = null;
    private String jarVendor_ = null;
    private String jarHomepage_ = null;
    private File license_ = null;
    private File readme_ = null;
    private ByteArrayOutputStream archiveInfos_ = null;
    private int archivecount_ = 0;
    private Vector archiveEntryList_;
    private Properties installProperties = new Properties();
    protected Vector filesets = new Vector();
    protected Vector javaLauncherList = new Vector();

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public JavaLauncherArgument createJavaLauncher() {
        JavaLauncherArgument javaLauncherArgument = new JavaLauncherArgument();
        this.javaLauncherList.addElement(javaLauncherArgument);
        return javaLauncherArgument;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.start();
    }

    protected void validateAttributes() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("Specify at least one fileset.");
        }
        for (int i = 0; i < this.javaLauncherList.size(); ++i) {
            JavaLauncherArgument javaLauncherArgument = (JavaLauncherArgument)this.javaLauncherList.elementAt(i);
            if (javaLauncherArgument.getScriptname() != null && javaLauncherArgument.getJavaclass() != null) continue;
            throw new BuildException("'scriptname' and 'javaclass' is required for 'javalauncher'.");
        }
    }

    private void addFilesetsToArchive(ZipOutputStream zipOutputStream) throws IOException {
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            String string = fileSet.getDir(this.project).toString();
            String[] stringArray = directoryScanner.getIncludedFiles();
            String[] stringArray2 = directoryScanner.getIncludedDirectories();
            for (int j = 0; j < stringArray.length; ++j) {
                System.out.println("file=" + stringArray[j]);
                ZipEntry zipEntry = new ZipEntry(stringArray[j]);
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(string + File.separator + stringArray[j]);
                byte[] byArray = new byte[2048];
                int n = fileInputStream.read(byArray, 0, byArray.length);
                while (n > 0) {
                    zipOutputStream.write(byArray, 0, n);
                    n = fileInputStream.read(byArray, 0, byArray.length);
                }
                fileInputStream.close();
                zipOutputStream.closeEntry();
                ++this.archivecount_;
                this.archiveEntryList_.add(stringArray[j]);
            }
        }
    }

    public VAInstallTask() {
        this.targets_ = new String[0];
        this.archiveEntryList_ = new Vector();
    }

    public void start() {
        if (!this.processProperties()) {
            return;
        }
        try {
            this.log(VAGlobals.i18n("VAArchiver_CompressingFiles"));
            this.archiveInfos_ = new ByteArrayOutputStream();
            File file = this.makeArchive("archive.zip");
            file.deleteOnExit();
            System.out.println(VAGlobals.i18n("VAArchiver_CreatingJarFiles"));
            this.archiveInfos_.flush();
            byte[] byArray = this.archiveInfos_.toByteArray();
            File file2 = this.makeJar("install.jar", file, this.license_, this.readme_, byArray);
            this.jarSize_ = file2.length();
            this.archiveInfos_.close();
            file2.deleteOnExit();
            File file3 = new File(this.instClassName_ + ".java");
            file3.deleteOnExit();
            File file4 = null;
            boolean bl = true;
            for (int i = 0; i < this.targets_.length; ++i) {
                File file5;
                System.out.println();
                System.out.println(this.targets_[i] + VAGlobals.i18n("VAArchiver_Target"));
                this.currentTarget_ = this.targets_[i];
                System.out.println(VAGlobals.i18n("VAArchiver_GeneratingInstallClass"));
                this.generateInstallCode(file3, "com/memoire/vainstall/resources/Install.vaitpl", "com/memoire/vainstall/VAClassLoader.class");
                System.out.println(VAGlobals.i18n("VAArchiver_CompilingInstallClass"));
                file4 = this.compile(file3.getName());
                this.installClassSize_ = file4.length();
                VAGlobals.printDebug("  InstallClass size=" + this.installClassSize_);
                if ("jar".equals(this.targets_[i])) {
                    file5 = new File(this.instClassName_ + ".jar");
                    File file6 = new File(this.instClassName_ + ".mf");
                    file6.deleteOnExit();
                    System.out.println(VAGlobals.i18n("VAArchiver_CreatingManifestFile"));
                    this.generateManifestFile(file6);
                    System.out.println(VAGlobals.i18n("VAArchiver_UpdatingJarFile"));
                    this.copy(file2, file5);
                    this.jar("uvfm", file5, new File[]{file6, file4});
                    if (this.jarAlias_ == null || "".equals(this.jarAlias_.trim()) || this.jarPassphrase_ == null || "".equals(this.jarPassphrase_.trim())) continue;
                    System.out.println(VAGlobals.i18n("VAArchiver_SigningJarFile"));
                    this.jarsign(this.jarPassphrase_, file5, this.jarAlias_);
                    continue;
                }
                if ("jnlp".equals(this.targets_[i])) {
                    file5 = new File(this.instClassName_ + ".jnlp");
                    System.out.println(VAGlobals.i18n("VAArchiver_CreatingJnlpFile"));
                    this.generateJnlpFile(file5);
                    continue;
                }
                if ("java".equals(this.targets_[i])) {
                    this.installClassOffset_ = -10987654321L;
                    bl = false;
                    if (!this.archMethod_.equals("append")) continue;
                    this.archOffset_ = file4.length();
                    VAGlobals.printDebug(VAGlobals.i18n("VAArchiver_ArchiveOffset") + this.archOffset_);
                    this.generateInstallCode(file3, "com/memoire/vainstall/resources/Install.vaitpl", "com/memoire/vainstall/VAClassLoader.class");
                    System.out.println(VAGlobals.i18n("VAArchiver_CompilingInstallClass"));
                    this.compile(file3.getName());
                    System.out.println(VAGlobals.i18n("VAArchiver_AppendingArchive"));
                    this.appendArchive(file4);
                    continue;
                }
                if ("unix".equals(this.targets_[i])) {
                    file5 = new File(this.instClassName_ + ".sh");
                    this.installClassOffset_ = this.generateUnixInstallShell(file5, "com/memoire/vainstall/resources/Install-sh.vaitpl", file4);
                    VAGlobals.printDebug(VAGlobals.i18n("VAArchiver_InstallClassOffset") + this.installClassOffset_);
                    if (!this.archMethod_.equals("append")) continue;
                    this.archOffset_ = file5.length();
                    VAGlobals.printDebug(VAGlobals.i18n("VAArchiver_ArchiveOffset") + this.archOffset_);
                    this.generateInstallCode(file3, "com/memoire/vainstall/resources/Install.vaitpl", "com/memoire/vainstall/VAClassLoader.class");
                    System.out.println(VAGlobals.i18n("VAArchiver_CompilingInstallClass"));
                    this.compile(file3.getName());
                    this.generateUnixInstallShell(file5, "com/memoire/vainstall/resources/Install-sh.vaitpl", file4);
                    System.out.println(VAGlobals.i18n("VAArchiver_AppendingArchive"));
                    this.appendArchive(file5);
                    continue;
                }
                if (!"win95".equals(this.targets_[i]) && !"linux-i386".equals(this.targets_[i])) continue;
                file5 = null;
                if ("win95".equals(this.targets_[i])) {
                    file5 = new File(this.instClassName_ + ".exe");
                } else if ("linux-i386".equals(this.targets_[i])) {
                    file5 = new File(this.instClassName_ + ".lin");
                }
                this.installClassOffset_ = this.generateNativeInstallExe(file5, "com/memoire/vainstall/resources/Install-" + this.targets_[i] + "-exe.vaitpl", file4);
                VAGlobals.printDebug(VAGlobals.i18n("VAArchiver_InstallClassOffset") + this.installClassOffset_);
                if (!this.archMethod_.equals("append")) continue;
                this.archOffset_ = file5.length();
                VAGlobals.printDebug(VAGlobals.i18n("VAArchiver_ArchiveOffset") + this.archOffset_);
                this.generateInstallCode(file3, "com/memoire/vainstall/resources/Install.vaitpl", "com/memoire/vainstall/VAClassLoader.class");
                System.out.println(VAGlobals.i18n("VAArchiver_CompilingInstallClass"));
                this.compile(file3.getName());
                this.generateNativeInstallExe(file5, "com/memoire/vainstall/resources/Install-" + this.targets_[i] + "-exe.vaitpl", file4);
                System.out.println(VAGlobals.i18n("VAArchiver_AppendingArchive"));
                this.appendArchive(file5);
            }
            if (file4 != null && bl) {
                file4.delete();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean processProperties() {
        block59: {
            Object object;
            Object object2;
            Object object3;
            Class<?> clazz;
            String string;
            block58: {
                block57: {
                    VAILOGO = "com/memoire/vainstall/resources/vailogo.gif";
                    VAGlobals.setLanguage("default");
                    string = this.getProject().getProperty("vainstall.destination.language");
                    if (string != null) {
                        this.installProperties.put("vainstall.destination.language", string);
                    }
                    this.destPath_ = this.getProject().getProperty("vainstall.destination.defaultPath");
                    if (this.destPath_ == null) {
                        this.log("Note: Property 'vainstall.destination.defaultPath' = null");
                        return false;
                    }
                    if (!this.checkVaiPath(this.destPath_)) {
                        this.log("Note: Property 'vainstall.destination.defaultPath' has incorrect format.");
                        return false;
                    }
                    string = this.getProject().getProperty("vainstall.destination.installMode");
                    if ("update".equals(string)) {
                        this.destPath_ = "[UPDATE]";
                    } else if (!"install".equals(string)) {
                        this.log("Note: Property 'vainstall.destination.installMode'. No valid install mode specified: Defaulting to 'install'.");
                        System.err.println("no valid installMode specified: defaulting to install");
                    }
                    string = this.getProject().getProperty("vainstall.destination.targets");
                    if (string == null) {
                        this.log("Note: Property 'vainstall.destination.targets'. No target specified.");
                        return false;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    Vector<String> vector = new Vector<String>();
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken().trim().toLowerCase();
                        if (!("java".equals(string2) || "jar".equals(string2) || "jnlp".equals(string2) || "unix".equals(string2) || "win95".equals(string2) || "linux-i386".equals(string2))) {
                            System.err.println("unknown target: " + string2);
                            return false;
                        }
                        if (vector.contains(string2)) continue;
                        vector.add(string2);
                    }
                    if (vector.contains("jnlp") && !vector.contains("jar")) {
                        vector.add("jar");
                    }
                    this.targets_ = new String[vector.size()];
                    int n = 0;
                    if (vector.contains("jar")) {
                        this.targets_[n++] = "jar";
                    }
                    if (vector.contains("jnlp")) {
                        this.targets_[n++] = "jnlp";
                    }
                    if (vector.contains("unix")) {
                        this.targets_[n++] = "unix";
                    }
                    if (vector.contains("linux-i386")) {
                        this.targets_[n++] = "linux-i386";
                    }
                    if (vector.contains("win95")) {
                        this.targets_[n++] = "win95";
                    }
                    if (vector.contains("java")) {
                        this.targets_[n++] = "java";
                    }
                    if (vector.contains("jar")) {
                        this.jarAlias_ = VAProperties.PROPERTIES.getProperty("vainstall.jarsigner.alias");
                        this.jarPassphrase_ = VAProperties.PROPERTIES.getProperty("vainstall.jarsigner.passphrase");
                    }
                    if (vector.contains("jnlp")) {
                        this.jarCodebase_ = VAProperties.PROPERTIES.getProperty("vainstall.jnlp.codebase");
                        if (this.jarCodebase_ == null || "".equals(this.jarCodebase_)) {
                            System.err.println("vainstall.jnlp.codebase null");
                            return false;
                        }
                        this.jarHomepage_ = VAProperties.PROPERTIES.getProperty("vainstall.jnlp.homepage");
                        if (this.jarHomepage_ == null || "".equals(this.jarHomepage_)) {
                            System.err.println("vainstall.jnlp.homepage null");
                            return false;
                        }
                        this.jarVendor_ = VAProperties.PROPERTIES.getProperty("vainstall.jnlp.vendor");
                        if (this.jarVendor_ == null || "".equals(this.jarVendor_)) {
                            System.err.println("vainstall.jnlp.vendor null");
                            return false;
                        }
                    }
                    this.archMethod_ = this.getProject().getProperty("vainstall.archive.archivingMethod");
                    if (this.archMethod_ == null) {
                        this.archMethod_ = "append";
                    }
                    this.uiMode_ = this.getProject().getProperty("vainstall.destination.ui");
                    if (this.uiMode_ == null) {
                        this.uiMode_ = "graphic";
                    }
                    this.uiBluescreen_ = this.getProject().getProperty("vainstall.destination.ui.bluescreen");
                    if (this.uiBluescreen_ == null) {
                        this.uiBluescreen_ = "yes";
                    }
                    this.uiBluescreenColor_ = this.getProject().getProperty("vainstall.destination.ui.bluescreen.colour");
                    if (this.uiBluescreenColor_ != null && !"".equals(this.uiBluescreenColor_)) {
                        try {
                            Integer.parseInt(this.uiBluescreenColor_, 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.log("Note: Property 'vainstall.destination.ui.bluescreen.colour' has invalid format.");
                            return false;
                        }
                    }
                    if ((string = this.getProject().getProperty("vainstall.destination.ui.image")) == null) {
                        this.log("Note: Property 'vainstall.destination.ui.image' = null: Will use default image.");
                        this.image_ = IMAGE_KEY;
                    } else {
                        this.image_ = string;
                    }
                    this.appName_ = this.getProject().getProperty("vainstall.destination.appName");
                    if (this.appName_ == null) {
                        this.log("Note: Property 'vainstall.destination.appName' = null.");
                        return false;
                    }
                    this.appVersion_ = this.getProject().getProperty("vainstall.destination.appVersion");
                    if (this.appVersion_ == null) {
                        this.log("Note: Property 'vainstall.destination.appVersion' = null.");
                        return false;
                    }
                    this.linkSectionName_ = this.getProject().getProperty("vainstall.destination.linkSectionName");
                    if (this.linkSectionName_ == null) {
                        this.log("Note: Property 'vainstall.destination.appVersion' = null : Defaulting to 'Applications'.");
                        this.linkSectionName_ = "Applications";
                    }
                    this.linkSectionIcon_ = this.getProject().getProperty("vainstall.destination.linkSectionIcon");
                    if (this.linkSectionIcon_ == null) {
                        this.log("Note: Property 'vainstall.destination.linkSectionIcon' = null.");
                        this.linkSectionIcon_ = "";
                    }
                    this.linkEntryName_ = this.getProject().getProperty("vainstall.destination.linkEntryName");
                    if (this.linkEntryName_ == null) {
                        this.log("Note: Property 'vainstall.destination.linkEntryName' = null : Defaulting to '" + this.appName_ + "'.");
                        this.linkEntryName_ = this.appName_;
                    }
                    this.linkEntryIcon_ = this.getProject().getProperty("vainstall.destination.linkEntryIcon");
                    if (this.linkEntryIcon_ == null) {
                        this.log("Note: Property 'vainstall.destination.linkEntryIcon' = null.");
                        this.linkEntryIcon_ = "";
                    }
                    this.instClassName_ = this.getProject().getProperty("vainstall.archive.installClassName");
                    if (this.instClassName_ == null) {
                        this.instClassName_ = "Install_" + this.appName_;
                    }
                    if ((string = this.getProject().getProperty("vainstall.archive.license")) == null) {
                        this.log("Note: Property 'vainstall.archive.license' = null.");
                        return false;
                    }
                    this.license_ = new File(string);
                    if (!this.license_.exists() || !this.license_.canRead()) {
                        this.log("Note: Property 'vainstall.archive.license' : Can not read " + this.license_ + ".");
                        return false;
                    }
                    try {
                        clazz = new FileInputStream(this.license_);
                        object3 = VAProperties.PROPERTIES.getProperty("vainstall.archive.license.encoding");
                        if (object3 == null || ((String)object3).equals("")) break block57;
                        try {
                            object2 = new InputStreamReader((InputStream)((Object)clazz), (String)object3);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            this.log("Note: Unsuported encoding for license!");
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        this.log("Note: Problems reading license file!");
                        return false;
                    }
                }
                string = this.getProject().getProperty("vainstall.license.key.support");
                System.out.println("fred " + string);
                if (string != null && !"".equals(string)) {
                    this.licenseKeySupportClassName_ = string;
                }
                this.encodeKey_ = this.getProject().getProperty("vainstall.license.key.support.encode.key");
                this.additionalFiles_ = this.getProject().getProperty("vainstall.additional.files");
                clazz = null;
                try {
                    clazz = Class.forName(this.licenseKeySupportClassName_);
                }
                catch (Exception exception) {
                    if (clazz != null || this.additionalFiles_ == null) break block58;
                    object2 = new StringTokenizer(this.additionalFiles_, ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = new StringTokenizer(((StringTokenizer)object2).nextToken(), "!");
                        String string3 = ((StringTokenizer)object).nextToken();
                        if (string3 == null || string3.indexOf(this.licenseKeySupportClassName_) <= -1) continue;
                        try {
                            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{new File(string3).getParentFile().toURL()});
                            clazz = uRLClassLoader.loadClass(this.licenseKeySupportClassName_);
                            break;
                        }
                        catch (Exception exception2) {
                            System.out.println("License key support could not be initialized  with specific URLCLassLoader" + exception2);
                            break;
                        }
                    }
                }
            }
            if (clazz == null) {
                throw new RuntimeException("License key support could not be initialized: ");
            }
            try {
                System.out.println(clazz.getName());
                this.licenseKeySupport_ = (LicenseKeySupport)clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("LicenseKeySupport can't be instantiated" + exception);
            }
            string = this.getProject().getProperty("vainstall.archive.readme");
            if (string == null) {
                this.log("Note: Property 'vainstall.archive.readme' = null.");
                return false;
            }
            this.readme_ = new File(string);
            if (!this.readme_.exists() || !this.readme_.canRead()) {
                this.log("Note: Property 'vainstall.archive.readme' : Can not read " + this.readme_ + ".");
                return false;
            }
            try {
                object3 = new FileInputStream(this.readme_);
                object2 = VAProperties.PROPERTIES.getProperty("vainstall.archive.readme.encoding");
                if (object2 == null || ((String)object2).equals("")) break block59;
                try {
                    object = new InputStreamReader((InputStream)object3, (String)object2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.log("Note: Unsupported encoding for readme!");
                    return false;
                }
            }
            catch (Exception exception) {
                this.log("Note: Problems reading readme file!");
                return false;
            }
        }
        return true;
    }

    private File makeArchive(String string) throws IOException {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < this.javaLauncherList.size(); ++i) {
            object2 = (JavaLauncherArgument)this.javaLauncherList.elementAt(i);
            object = "JavaLauncher\n";
            object = (String)object + "Class=" + ((JavaLauncherArgument)object2).getJavaclass() + "\n";
            object = (String)object + "ClassPath=" + (((JavaLauncherArgument)object2).getClasspath() == null ? "" : ((JavaLauncherArgument)object2).getClasspath()) + "\n";
            object = (String)object + "JavaMode=" + (((JavaLauncherArgument)object2).getJavamode() == null ? "console" : ((JavaLauncherArgument)object2).getJavamode()) + "\n";
            object = (String)object + "JavaArgs=" + (((JavaLauncherArgument)object2).getJavaargs() == null ? "" : ((JavaLauncherArgument)object2).getJavaargs()) + "\n";
            object = (String)object + "ClassArgs=" + (((JavaLauncherArgument)object2).getClassargs() == null ? "" : ((JavaLauncherArgument)object2).getClassargs()) + "\n";
            object = (String)object + "ScriptName=" + ((JavaLauncherArgument)object2).getScriptname() + "\n";
            vector.add(object);
            vector2.add("[SCRIPT]" + ((JavaLauncherArgument)object2).getScriptname());
        }
        File file = new File(string);
        object2 = file.getParentFile();
        if (object2 != null && !((File)object2).canWrite()) {
            throw new IOException(file + " can not be written");
        }
        object = new ZipOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
        ((ZipOutputStream)object).setLevel(0);
        this.addFilesetsToArchive((ZipOutputStream)object);
        ((ZipOutputStream)object).close();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.archiveInfos_);
        objectOutputStream.writeInt(this.archivecount_);
        objectOutputStream.writeObject(vector);
        objectOutputStream.writeObject(vector2);
        objectOutputStream.flush();
        return file;
    }

    private String convertToLocalPath(String string) throws IOException {
        String string2 = Setup.expandDirectory(string, true, null);
        if (string2 == null) {
            throw new IOException("Invalid path: " + string);
        }
        return string2.replace('/', File.separatorChar);
    }

    private String convertToGenericPath(String string) {
        return string.replace(File.separatorChar, '/');
    }

    private void generateInstallCode(File file, String string, String string2) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        int n = 0;
        byte[] byArray = new byte[128];
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + string);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        System.out.println(VAGlobals.i18n("VAArchiver_GeneratingInstallClassCode"));
        String string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> InstallClassName")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("public class " + this.instClassName_ + " {");
        printWriter.println("  private static final Class installClass=new " + this.instClassName_ + "().getClass();");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> ArchivingMethod")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static String ARCH_METHOD=\"" + this.archMethod_ + "\";");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> TargetType")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static String TARGET_TYPE=\"" + this.currentTarget_ + "\";");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> InstallClassOffset")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static long ICLASS_OFFSET=" + this.installClassOffset_ + "L;");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> InstallClassSize")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        if (this.installClassSize_ != this.archOffset_) {
            printWriter.println("  private static long ICLASS_SIZE=" + this.installClassSize_ + "L;");
        } else {
            printWriter.println("  private static long ICLASS_SIZE=-1234543210L;");
        }
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> ArchiveOffset")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static long ARCH_OFFSET=" + this.archOffset_ + "L;");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> JarSize")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static long JAR_SIZE=" + this.jarSize_ + "L;");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> UIMode")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static String UI_MODE=\"" + this.uiMode_ + "\";");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> UIBluescreen")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static String UI_BLUESCREEN=\"" + this.uiBluescreen_ + "\";");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> UIBluescreenColor")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static String UI_BLUESCREEN_COLOR=\"" + this.uiBluescreenColor_ + "\";");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> DestPath")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static String DEST_PATH=\"" + this.destPath_ + "\";");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> AppInfo")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static String APP_NAME=\"" + this.appName_ + "\";");
        printWriter.println("  private static String APP_VERSION=\"" + this.appVersion_ + "\";");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> LinkInfos")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static String LINK_SECTION_NAME=\"" + this.linkSectionName_ + "\";");
        printWriter.println("  private static String LINK_SECTION_ICON=\"" + this.linkSectionIcon_ + "\";");
        printWriter.println("  private static String LINK_ENTRY_NAME=\"" + this.linkEntryName_ + "\";");
        printWriter.println("  private static String LINK_ENTRY_ICON=\"" + this.linkEntryIcon_ + "\";");
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> LicenseKey")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        printWriter.println("  private static String LICENSE_KEY_SUPPORT_NAME=\"" + this.licenseKeySupportClassName_ + "\";");
        System.out.println(VAGlobals.i18n("VAArchiver_AppendingClassloader"));
        string3 = lineNumberReader.readLine();
        while (string3 != null && !string3.startsWith("// --> ClassLoader")) {
            printWriter.println(string3);
            string3 = lineNumberReader.readLine();
        }
        InputStream inputStream2 = ((Object)((Object)this)).getClass().getResourceAsStream("/" + string2);
        System.out.println("  CLASSLOADER = /" + string2);
        printWriter.println("  private static String[] CL_CLASS={");
        n = inputStream2.read(byArray);
        while (n > 0) {
            printWriter.println("\"" + this.codeLine(byArray, n) + "\",");
            n = inputStream2.read(byArray);
        }
        inputStream2.close();
        printWriter.println("  };\n}");
        lineNumberReader.close();
        printWriter.close();
        inputStream.close();
        inputStreamReader.close();
    }

    private void generateJnlpFile(File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<jnlp spec=\"1.0\"");
        printWriter.println("      codebase=\"" + this.jarCodebase_ + "\"");
        printWriter.println("      href=\"" + this.instClassName_ + ".jnlp\">");
        printWriter.println("  <information>");
        printWriter.println("    <title>" + this.appName_ + " " + this.appVersion_ + " Installer</title>");
        printWriter.println("    <vendor>" + this.jarVendor_ + "</vendor>");
        printWriter.println("    <homepage href=\"" + this.jarHomepage_ + "\"/>");
        printWriter.println("    <description>Installer for " + this.appName_ + " " + this.appVersion_ + "</description>");
        printWriter.println("    <offline/>");
        printWriter.println("  </information>");
        printWriter.println("  <resources>");
        printWriter.println("    <j2se version=\"1.3 1.2\"/>");
        printWriter.println("    <jar href=\"" + this.instClassName_ + ".jar\"/>");
        printWriter.println("  </resources>");
        printWriter.println("  <security>");
        printWriter.println("    <all-permissions/>");
        printWriter.println("  </security>");
        printWriter.println("  <application-desc main-class=\"" + this.instClassName_ + "\"/>");
        printWriter.println("</jnlp>");
        printWriter.close();
    }

    private void generateManifestFile(File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        printWriter.println("Manifest-Version: 1.0");
        printWriter.println("Main-Class: " + this.instClassName_);
        printWriter.close();
    }

    private long generateUnixInstallShell(File file, String string, File file2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + string);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        String string2 = "";
        String string3 = "000000000000";
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(string3.length());
        int n = 0;
        long l = 0L;
        System.out.println(VAGlobals.i18n("VAArchiver_GenerateInstallShell"));
        String string4 = lineNumberReader.readLine();
        while (string4 != null && !string4.startsWith("# InstallClassStart")) {
            string2 = string2 + string4 + "\n";
            string4 = lineNumberReader.readLine();
        }
        string2 = string2 + "InstallClassStart=" + string3 + "\n";
        n = string2.length() - 1 - 1 - string3.length();
        string4 = lineNumberReader.readLine();
        while (string4 != null && !string4.startsWith("# InstallClassSize")) {
            string2 = string2 + string4 + "\n";
            string4 = lineNumberReader.readLine();
        }
        string2 = string2 + new String("InstallClassSize=" + file2.length() + "\n");
        string4 = lineNumberReader.readLine();
        while (string4 != null && !string4.startsWith("# InstallClassName")) {
            string2 = string2 + string4 + "\n";
            string4 = lineNumberReader.readLine();
        }
        string2 = string2 + new String("InstallClassName=" + this.instClassName_ + "\n");
        string4 = lineNumberReader.readLine();
        while (string4 != null && !string4.startsWith("# Install class")) {
            string2 = string2 + string4 + "\n";
            string4 = lineNumberReader.readLine();
        }
        if (string4 != null) {
            string2 = string2 + string4 + "\n";
        }
        fileOutputStream.write(string2.substring(0, n + 1).getBytes());
        fileOutputStream.write(numberFormat.format(string2.length()).getBytes());
        fileOutputStream.write(string2.substring(n + 1 + string3.length()).getBytes());
        l = string2.length();
        string2 = null;
        FileInputStream fileInputStream = new FileInputStream(file2);
        byte[] byArray = new byte[2048];
        int n2 = fileInputStream.read(byArray);
        while (n2 > 0) {
            fileOutputStream.write(byArray, 0, n2);
            n2 = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        lineNumberReader.close();
        fileOutputStream.close();
        return l;
    }

    private void shiftArray(byte[] byArray) {
        for (int i = 0; i < byArray.length - 1; ++i) {
            byArray[i] = byArray[i + 1];
        }
        byArray[byArray.length - 1] = 0;
    }

    private long generateNativeInstallExe(File file, String string, File file2) throws IOException {
        byte[] byArray;
        int n;
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + string);
        System.out.println("generateNativeInstallExe = /" + string);
        System.out.println("reader length=" + inputStream.available());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string2 = "000000000000";
        byte[] byArray2 = new byte[string2.length()];
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(string2.length());
        int n2 = 0;
        long l = inputStream.available();
        int n3 = 0;
        System.out.println(VAGlobals.i18n("VAArchiver_GenerateInstallExe"));
        inputStream.read(byArray2, 0, byArray2.length);
        n3 = 1;
        for (n = 0; n < 3; ++n) {
            int n4;
            while (!(new String(byArray2).equals("clname_here_") || new String(byArray2).equals("clstart_here") || new String(byArray2).equals("clstop_here_"))) {
                byteArrayOutputStream.write(byArray2[0]);
                n4 = inputStream.read();
                ++n3;
                this.shiftArray(byArray2);
                byArray2[byArray2.length - 1] = (byte)n4;
            }
            if (new String(byArray2).equals("clname_here_")) {
                System.err.println("  clname_here_ found at " + (n3 - 1));
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append(this.instClassName_);
                for (int i = stringBuffer.length() - 1; i < 64; ++i) {
                    stringBuffer.append('.');
                }
                byArray = stringBuffer.toString().getBytes();
                for (int i = 0; i < 64; ++i) {
                    byteArrayOutputStream.write(byArray[i]);
                    ++n3;
                }
                inputStream.skip(64 - byArray2.length);
                inputStream.read(byArray2, 0, byArray2.length);
                continue;
            }
            if (new String(byArray2).equals("clstart_here")) {
                System.err.println("  clstart_here found at " + (n3 - 1));
                byArray2 = numberFormat.format(l).getBytes();
                for (n4 = 0; n4 < byArray2.length; ++n4) {
                    byteArrayOutputStream.write(byArray2[n4]);
                    ++n3;
                }
                inputStream.read(byArray2, 0, byArray2.length);
                continue;
            }
            if (!new String(byArray2).equals("clstop_here_")) continue;
            System.err.println("  clstop_here_ found at " + (n3 - 1));
            n2 = n3 - 1;
            byteArrayOutputStream.write(byArray2);
            n3 += 12;
            inputStream.read(byArray2, 0, byArray2.length);
        }
        byteArrayOutputStream.write(byArray2);
        byArray2 = new byte[2048];
        n = inputStream.read(byArray2);
        while (n > 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
            n = inputStream.read(byArray2);
        }
        inputStream.close();
        FileInputStream fileInputStream = new FileInputStream(file2);
        n = fileInputStream.read(byArray2);
        while (n > 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
            n = fileInputStream.read(byArray2);
        }
        fileInputStream.close();
        byteArrayOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        string2 = numberFormat.format(byArray.length);
        byte[] byArray3 = string2.getBytes();
        for (int i = 0; i < byArray3.length; ++i) {
            byArray[n2 + i] = byArray3[i];
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
        return l;
    }

    private void appendArchive(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file.getName(), true);
        FileInputStream fileInputStream = new FileInputStream("install.jar");
        byte[] byArray = new byte[2048];
        int n = fileInputStream.read(byArray);
        while (n > 0) {
            fileOutputStream.write(byArray, 0, n);
            n = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    private void copy(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[2048];
        int n = fileInputStream.read(byArray);
        while (n > 0) {
            fileOutputStream.write(byArray, 0, n);
            n = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    private void jar(String string, File file, File[] fileArray) throws IOException {
        Process process = null;
        Vector<String> vector = new Vector<String>();
        vector.add(JDK_HOME + File.separator + "bin" + File.separator + "jar");
        if (string != null && !string.equals("")) {
            vector.add(string);
        }
        vector.add(file.getName());
        for (int i = 0; i < fileArray.length; ++i) {
            vector.add(fileArray[i].getName());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        try {
            process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
        }
        catch (Exception exception) {
            throw new IOException("Runtime exception: check if you have installed the JDK and run java from the JDK\nException message: " + exception.getMessage());
        }
        this.printCmdOutput(process, "jar");
        if (process.exitValue() != 0) {
            throw new RuntimeException("  abnormal exit");
        }
    }

    private void jarsign(String string, File file, String string2) throws IOException {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{JDK_HOME + File.separator + "bin" + File.separator + "jarsigner", "-storepass", string, file.getName(), string2});
            process.waitFor();
        }
        catch (Exception exception) {
            throw new IOException("Runtime exception: check if you have installed the JDK and run java from the JDK\nException message: " + exception.getMessage());
        }
        this.printCmdOutput(process, "jarsign");
        if (process.exitValue() != 0) {
            throw new RuntimeException("  abnormal exit");
        }
    }

    private File compile(String string) throws IOException {
        File file = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{JDK_HOME + File.separator + "bin" + File.separator + "javac", string});
            process.waitFor();
        }
        catch (Exception exception) {
            throw new IOException("Runtime exception: check if you have installed the JDK and run java from the JDK\nException message: " + exception.getMessage());
        }
        this.printCmdOutput(process, "javac");
        if (process.exitValue() != 0) {
            throw new RuntimeException("  abnormal exit");
        }
        file = new File(string.substring(0, string.lastIndexOf(46)) + ".class");
        System.out.println("  " + file + " " + file.exists());
        return file;
    }

    private void printCmdOutput(Process process, String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        boolean bl = false;
        System.out.println("  --- start " + string + " ---");
        String string2 = bufferedReader.readLine();
        String string3 = bufferedReader2.readLine();
        while (string2 != null || string3 != null) {
            if (string2 != null) {
                System.out.println("  " + string2);
            }
            if (string3 != null) {
                System.err.println("  " + string3);
            }
            string2 = bufferedReader.readLine();
            string3 = bufferedReader2.readLine();
        }
        bufferedReader.close();
        bufferedReader2.close();
        System.out.println("  --- end   " + string + " ---");
    }

    private File makeJar(String string, File file, File file2, File file3, byte[] byArray) throws IOException {
        File file4 = new File(string);
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file4));
        this.copyInternalToJar(jarOutputStream, JAR_FILES_COMMON);
        this.copyInternalToJar(jarOutputStream, JAR_FILES_JNIREGISTRY);
        this.copyInternalToJar(jarOutputStream, JAR_FILES_TEXT_UI);
        this.copyInternalToJar(jarOutputStream, JAR_FILES_ANSI_UI);
        if (this.uiMode_.equals("graphic")) {
            this.copyInternalToJar(jarOutputStream, JAR_FILES_GRAPHIC_UI);
        }
        if (this.uiMode_.equals("xtra")) {
            this.copyInternalToJar(jarOutputStream, JAR_FILES_XTRA_UI);
        }
        this.addToJar(jarOutputStream, new ByteArrayInputStream(byArray), "com/memoire/vainstall/archive_infos", byArray.length);
        this.addToJar(jarOutputStream, new FileInputStream(file), "com/memoire/vainstall/archive.zip", file.length());
        FileInputStream fileInputStream = new FileInputStream(file2);
        String string2 = VAProperties.PROPERTIES.getProperty("vainstall.archive.license.encoding");
        if (string2 == null || string2.equals("")) {
            string2 = new InputStreamReader(fileInputStream).getEncoding();
        }
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string2);
        this.addToJarEncoded(jarOutputStream, inputStreamReader, "com/memoire/vainstall/license.txt", file2.length());
        FileInputStream fileInputStream2 = new FileInputStream(file3);
        String string3 = VAProperties.PROPERTIES.getProperty("vainstall.archive.readme.encoding");
        if (string3 == null || string3.equals("")) {
            string3 = new InputStreamReader(fileInputStream2).getEncoding();
        }
        InputStreamReader inputStreamReader2 = new InputStreamReader((InputStream)fileInputStream2, string3);
        this.addToJarEncoded(jarOutputStream, inputStreamReader2, "com/memoire/vainstall/readme.txt", file3.length());
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(this.image_));
        }
        catch (Exception exception) {
            this.image_ = "/" + this.image_;
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(this.image_);
        }
        if (inputStream == null) {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(IMAGE_KEY);
            this.image_ = IMAGE_KEY;
        }
        if (inputStream != null) {
            this.addToJar(jarOutputStream, inputStream, IMAGE_KEY, ((InputStream)inputStream).available());
        }
        InputStream inputStream2 = ((Object)((Object)this)).getClass().getResourceAsStream("/" + VAILOGO);
        this.addToJar(jarOutputStream, inputStream2, VAILOGO, inputStream2.available());
        inputStream2.close();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.installProperties.store(byteArrayOutputStream, "VAInstall 0.21");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        this.addToJar(jarOutputStream, byteArrayInputStream, "com/memoire/vainstall/resources/vainstall.properties", byteArrayOutputStream.toByteArray().length);
        jarOutputStream.close();
        return file4;
    }

    private void copyInternalToJar(JarOutputStream jarOutputStream, String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.endsWith(".jar")) {
                this.copyJarFilesToJar(jarOutputStream, string);
                continue;
            }
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + string);
            this.addToJar(jarOutputStream, inputStream, string, inputStream.available());
        }
    }

    private void copyJarFilesToJar(JarOutputStream jarOutputStream, String string) throws IOException {
        byte[] byArray = new byte[2048];
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + string);
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        JarEntry jarEntry = null;
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = jarInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.addToJar(jarOutputStream, byteArrayInputStream, jarEntry.getName(), byteArrayOutputStream.toByteArray().length);
            byteArrayOutputStream.close();
            jarInputStream.closeEntry();
        }
        jarInputStream.close();
        inputStream.close();
    }

    private void addToJar(JarOutputStream jarOutputStream, InputStream inputStream, String string, long l) throws IOException {
        byte[] byArray = new byte[2048];
        ZipEntry zipEntry = new ZipEntry(string);
        CRC32 cRC32 = new CRC32();
        zipEntry.setSize(l);
        zipEntry.setCrc(cRC32.getValue());
        jarOutputStream.putNextEntry(zipEntry);
        int n = inputStream.read(byArray);
        while (n > 0) {
            cRC32.update(byArray, 0, n);
            jarOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        zipEntry.setCrc(cRC32.getValue());
        inputStream.close();
        jarOutputStream.closeEntry();
    }

    private void addToJarEncoded(JarOutputStream jarOutputStream, InputStreamReader inputStreamReader, String string, long l) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((n = ((Reader)bufferedReader).read()) > -1) {
            stringBuffer.append((char)n);
        }
        ((Reader)bufferedReader).close();
        inputStreamReader.close();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
        outputStreamWriter.write(stringBuffer.toString());
        outputStreamWriter.flush();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        this.addToJar(jarOutputStream, byteArrayInputStream, string, l);
    }

    private boolean checkVaiPath(String string) {
        int n = string.indexOf(93);
        if (!string.startsWith("[")) {
            return true;
        }
        if (n <= 2) {
            return false;
        }
        String string2 = string.substring(1, n).trim();
        System.out.println(string);
        System.out.println(string2);
        if ("HOME".equals(string2) || "PROGRAM".equals(string2)) {
            return true;
        }
        return string2.length() == 2 && string2.endsWith(":") && Character.isLetter(string2.charAt(0));
    }

    private String codeLine(byte[] byArray, int n) {
        String string = null;
        byte[] byArray2 = new byte[2 * n];
        for (int i = 0; i < n; ++i) {
            byArray2[2 * i] = (byte)(65 + (byArray[i] & 0xF));
            byArray2[2 * i + 1] = (byte)(65 + (byArray[i] & 0xF0) / 16);
        }
        string = new String(byArray2);
        return string;
    }

    public class JavaLauncherArgument {
        private String scriptname;
        private String javaclass;
        private String classargs;
        private String javamode;
        private String javaargs;
        private String classpath;

        public void setScriptname(String string) {
            this.scriptname = string;
        }

        public String getScriptname() {
            return this.scriptname;
        }

        public void setJavaclass(String string) {
            this.javaclass = string;
        }

        public String getJavaclass() {
            return this.javaclass;
        }

        public void setClassargs(String string) {
            this.classargs = string;
        }

        public String getClassargs() {
            return this.classargs;
        }

        public void setJavamode(String string) {
            this.javamode = string;
        }

        public String getJavamode() {
            return this.javamode;
        }

        public void setJavaargs(String string) {
            this.javaargs = string;
        }

        public String getJavaargs() {
            return this.javaargs;
        }

        public void setClasspath(String string) {
            this.classpath = string;
        }

        public String getClasspath() {
            return this.classpath;
        }
    }
}

