/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall.gui;

import com.memoire.vainstall.VADirectoryStep;
import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.gui.VAImagePanel;
import com.memoire.vainstall.gui.VAPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class VADirectoryPanel
extends VAPanel
implements VADirectoryStep {
    JTextField tfDir_;
    JButton btBrowse_;

    public VADirectoryPanel() {
        this.setLayout(new BoxLayout(this, 0));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 5, 5, 5))));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(VAGlobals.i18n("UI_Directory"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 20.0f));
        jLabel.setOpaque(true);
        jLabel.setBorder(new EmptyBorder(new Insets(5, 0, 5, 0)));
        jLabel.setBackground(jPanel.getBackground().darker());
        jLabel.setForeground(Color.white);
        jPanel2.add("North", jLabel);
        this.tfDir_ = new JTextField();
        jPanel2.add("South", this.tfDir_);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.btBrowse_ = new JButton(VAGlobals.i18n("UI_Browse"));
        this.btBrowse_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VADirectoryPanel.this.browse();
            }
        });
        jPanel3.add("North", this.btBrowse_);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        VAImagePanel vAImagePanel = VAImagePanel.IMAGE_PANEL;
        this.add(vAImagePanel);
        this.add(jPanel);
    }

    public void setDirectory(File file) {
        if (file != null) {
            this.tfDir_.setText(file.getAbsolutePath());
        }
    }

    public File getDirectory() {
        String string = this.tfDir_.getText().trim();
        if (string == null || "".equals(string)) {
            JOptionPane.showMessageDialog(this, VAGlobals.i18n("UI_MustChoose"), VAGlobals.i18n("UI_Error"), 0);
            return null;
        }
        File file = new File(string);
        return file;
    }

    public void roDirectory(File file) {
        JOptionPane.showMessageDialog(this, VAGlobals.i18n("Setup_NoWritableDirectory") + file.getAbsolutePath() + "\n" + VAGlobals.i18n("Setup_NoWritableDirectoryInfos"), VAGlobals.i18n("UI_Error"), 0);
    }

    public void rejectDirectory() {
        JOptionPane.showMessageDialog(this, VAGlobals.i18n("UI_NotChooseDirectory"), VAGlobals.i18n("UI_Error"), 0);
    }

    public boolean acceptDirectory() {
        int n = JOptionPane.showConfirmDialog(this, VAGlobals.i18n("UI_InstallationDirectory") + "\n" + this.getDirectory() + "\n" + VAGlobals.i18n("UI_IsThatRight"), VAGlobals.i18n("UI_Confirm"), 0, 3);
        return n == 0;
    }

    private void browse() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showSaveDialog(this);
        File file = null;
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (file.exists() && file.isDirectory() && file.canWrite()) {
                this.tfDir_.setText(file.getAbsolutePath());
            } else {
                JOptionPane.showMessageDialog(this, file.getName() + VAGlobals.i18n("UI_NotValidDirectory"), VAGlobals.i18n("UI_Error"), 0);
            }
        }
    }
}

