/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall.gui;

import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.VAStep;
import com.memoire.vainstall.VAStepFactory;
import com.memoire.vainstall.gui.VABlueScreen;
import com.memoire.vainstall.gui.VADirectoryPanel;
import com.memoire.vainstall.gui.VAEndPanel;
import com.memoire.vainstall.gui.VAInstallPanel;
import com.memoire.vainstall.gui.VALanguagePanel;
import com.memoire.vainstall.gui.VALicenseKeyPanel;
import com.memoire.vainstall.gui.VALicensePanel;
import com.memoire.vainstall.gui.VAReadmePanel;
import com.memoire.vainstall.gui.VAShortcutPanel;
import com.memoire.vainstall.gui.VAUpgradePanel;
import com.memoire.vainstall.gui.VAWelcomePanel;
import com.memoire.vainstall.gui.VAWizard;
import javax.swing.JOptionPane;

public class VAGraphicUI
extends VAStepFactory {
    VABlueScreen blueScreen_;

    public void initUI() {
        if (!VAGlobals.UI_BLUESCREEN) {
            VAGlobals.printDebug("no blue screen");
        } else {
            this.blueScreen_ = new VABlueScreen();
            this.blueScreen_.show();
        }
        this.setWizard(VAWizard.createWizard());
    }

    public void activateUI() {
        if (VAGlobals.UI_BLUESCREEN) {
            ((VAWizard)this.getWizard()).setLocationRelativeTo(this.blueScreen_);
        }
        super.activateUI();
    }

    public void quitUI() {
        super.quitUI();
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (VAGlobals.UI_BLUESCREEN) {
            this.blueScreen_.dispose();
        }
    }

    public void showFatalError(Throwable throwable) {
        JOptionPane.showMessageDialog(this.blueScreen_, "" + throwable, VAGlobals.i18n("UI_Error"), 0);
        super.showFatalError(throwable);
    }

    public void showError(Throwable throwable) {
        JOptionPane.showMessageDialog(this.blueScreen_, "" + throwable.getMessage(), VAGlobals.i18n("UI_Message"), 2);
        super.showError(throwable);
    }

    public void uiSleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public VAStep createSetupLanguageStep() {
        VALanguagePanel vALanguagePanel = new VALanguagePanel();
        vALanguagePanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(vALanguagePanel);
        return vALanguagePanel;
    }

    public VAStep createWelcomeStep() {
        if (this.blueScreen_ != null) {
            this.blueScreen_.repaint();
        }
        VAWelcomePanel vAWelcomePanel = new VAWelcomePanel();
        vAWelcomePanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(vAWelcomePanel);
        return vAWelcomePanel;
    }

    public VAStep createLicenseStep() {
        VALicensePanel vALicensePanel = new VALicensePanel();
        vALicensePanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(vALicensePanel);
        return vALicensePanel;
    }

    public VAStep createReadmeStep() {
        VAReadmePanel vAReadmePanel = new VAReadmePanel();
        vAReadmePanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(vAReadmePanel);
        return vAReadmePanel;
    }

    public VAStep createLicenseKeyStep() {
        VALicenseKeyPanel vALicenseKeyPanel = new VALicenseKeyPanel();
        vALicenseKeyPanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(vALicenseKeyPanel);
        return vALicenseKeyPanel;
    }

    public VAStep createUpgradeStep() {
        VAUpgradePanel vAUpgradePanel = new VAUpgradePanel();
        vAUpgradePanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(vAUpgradePanel);
        return vAUpgradePanel;
    }

    public VAStep createDirectoryStep() {
        VADirectoryPanel vADirectoryPanel = new VADirectoryPanel();
        vADirectoryPanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(vADirectoryPanel);
        return vADirectoryPanel;
    }

    public VAStep createInstallStep() {
        VAInstallPanel vAInstallPanel = new VAInstallPanel();
        vAInstallPanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(vAInstallPanel);
        return vAInstallPanel;
    }

    public VAStep createShortcutStep() {
        VAShortcutPanel vAShortcutPanel = new VAShortcutPanel();
        vAShortcutPanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(vAShortcutPanel);
        return vAShortcutPanel;
    }

    public VAStep createEndStep() {
        VAEndPanel vAEndPanel = new VAEndPanel();
        vAEndPanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(vAEndPanel);
        return vAEndPanel;
    }
}

