/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall.gui;

import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.VALanguageStep;
import com.memoire.vainstall.VAStep;
import com.memoire.vainstall.VAWelcomeStep;
import com.memoire.vainstall.VAWizardInterface;
import com.memoire.vainstall.gui.VAImagePanel;
import com.memoire.vainstall.gui.VAPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class VAWizard
extends JDialog
implements VAWizardInterface,
ActionListener {
    private static VAWizard UNIQUE_WIZARD = null;
    JButton btNext_;
    JButton btBack_;
    JButton btCancel_;
    VAPanel panel_;
    JPanel pnNav_;

    protected VAWizard() {
        this.init();
    }

    protected void init() {
        super.setTitle(VAGlobals.i18n("UI_Title"));
        super.setDefaultCloseOperation(1);
        this.setModal(true);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.setBackground(Color.red);
        this.pnNav_ = new JPanel();
        this.pnNav_.setLayout(new FlowLayout(2));
        this.pnNav_.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.btNext_ = new JButton(VAGlobals.i18n("UI_Next"));
        this.btBack_ = new JButton(VAGlobals.i18n("UI_Back"));
        this.btCancel_ = new JButton(VAGlobals.i18n("UI_Cancel"));
        this.pnNav_.add(this.btCancel_);
        this.pnNav_.add(this.btBack_);
        this.pnNav_.add(this.btNext_);
        this.btNext_.addActionListener(this);
        this.btBack_.addActionListener(this);
        this.btCancel_.addActionListener(this);
        this.panel_ = new VAPanel();
        Dimension dimension = VAImagePanel.IMAGE_PANEL.getPreferredSize();
        this.panel_.setPreferredSize(new Dimension(dimension.width + 400, dimension.height));
        container.add("Center", this.panel_);
        container.add("South", this.pnNav_);
        this.pack();
        this.setResizable(false);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension2.width - this.getSize().width) / 2, (dimension2.height - this.getSize().height) / 2);
    }

    public static VAWizardInterface createWizard() {
        if (UNIQUE_WIZARD == null) {
            UNIQUE_WIZARD = new VAWizard();
        } else {
            UNIQUE_WIZARD.init();
        }
        return UNIQUE_WIZARD;
    }

    public void setStep(VAStep vAStep) {
        this.panel_ = (VAPanel)vAStep;
        Container container = this.getContentPane();
        container.removeAll();
        this.panel_.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 5, 5, 5))));
        container.add("Center", this.panel_);
        if (vAStep instanceof VAWelcomeStep || vAStep instanceof VALanguageStep) {
            this.btNext_.setText(VAGlobals.i18n("UI_Next"));
            this.btBack_.setText(VAGlobals.i18n("UI_Back"));
            this.btCancel_.setText(VAGlobals.i18n("UI_Cancel"));
            this.doLayout();
            this.validate();
        }
        container.add("South", this.pnNav_);
        container.doLayout();
        this.invalidate();
        container.validate();
        Dimension dimension = this.getSize();
    }

    public VAPanel getPanel() {
        return this.panel_;
    }

    public void setActionEnabled(int n) {
        this.btCancel_.setEnabled((n & 1) == 1);
        this.btBack_.setEnabled((n & 2) == 2);
        this.btNext_.setEnabled((n & 4) == 4 || (n & 8) == 8);
        if ((n & 8) == 8) {
            this.btNext_.setText(VAGlobals.i18n("UI_Finish"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btCancel_) {
            this.dispose(true);
        } else if (object == this.btBack_) {
            this.panel_.backAction();
        } else if (object == this.btNext_) {
            Runnable runnable = new Runnable(){

                public void run() {
                    VAWizard.this.panel_.nextAction();
                }
            };
            new Thread(runnable).start();
        }
    }

    public void hide(boolean bl) {
        if (bl) {
            int n = JOptionPane.showConfirmDialog(this, VAGlobals.i18n("UI_AbortQuestion"), VAGlobals.i18n("UI_Finish"), 0, 3);
            if (n == 0) {
                this.panel_.cancelAction();
            }
        } else {
            super.hide();
        }
    }

    public void dispose() {
        this.hide(true);
    }

    public void dispose(boolean bl) {
        this.hide(bl);
    }

    public void show() {
        super.show();
    }

    public void hide() {
        this.hide(true);
    }
}

