/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall.tui;

import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.VAStep;
import com.memoire.vainstall.VAWizardInterface;
import com.memoire.vainstall.tui.TuiDefaultStep;
import java.io.File;
import java.io.IOException;

public class TuiWizard
implements VAWizardInterface {
    private static TuiWizard UNIQUE_WIZARD = null;
    private VAStep step_;
    private int actions_;
    public static boolean ansi = System.getProperty("ANSI") != null;
    public static boolean skip = System.getProperty("SKIP") != null;

    protected TuiWizard() {
        this.init();
    }

    protected void init() {
    }

    public static int key() {
        int n = 0;
        boolean bl = true;
        while (bl) {
            bl = false;
            try {
                System.in.skip(System.in.available());
                n = System.in.read();
                if (n == 13) {
                    n = 10;
                }
                if (n == 27 && System.in.available() > 0 && (n = System.in.read()) == 91 && System.in.available() > 0) {
                    n = System.in.read();
                    if (n == 67) {
                        n = 6;
                    }
                    if (n == 68) {
                        n = 2;
                    }
                }
                System.in.skip(System.in.available());
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        return n;
    }

    public static void enter() {
        TuiWizard.println("");
        TuiWizard.separator();
        TuiWizard.title();
        TuiWizard.print(VAGlobals.i18n("TuiWizard_Enter"));
        TuiWizard.user();
        while (TuiWizard.key() != 10) {
            TuiWizard.print("\u0007");
            if (!ansi) continue;
            TuiWizard.print("\u001b[24;11H\u001b[K");
        }
    }

    public static String input() {
        String string = "";
        try {
            System.in.skip(System.in.available());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (true) {
            try {
                int n;
                while ((n = System.in.read()) != 10 && n != 13) {
                    if (n == 128 || n == 8) {
                        string = string.length() == 0 ? "" : string.substring(0, string.length() - 1);
                    } else if (Character.isLetter((char)n) || Character.isDigit((char)n) || n == 95 || n == 45 || n == 46 || n == 58 || n == File.separatorChar) {
                        string = string + (char)n;
                    } else {
                        TuiWizard.print("\u0007");
                    }
                    if (!ansi) continue;
                    TuiWizard.print("\u001b[24;3H\u001b[K" + string);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        return string;
    }

    public static void print(String string) {
        String string2;
        if (!ansi) {
            boolean bl = true;
            string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\u001b') {
                    bl = false;
                }
                if (bl) {
                    string2 = string2 + c;
                    continue;
                }
                if (!Character.isLetterOrDigit(c) && c != File.separatorChar && c != ':' && c != '-') continue;
                bl = true;
            }
        } else {
            string2 = string;
        }
        System.out.print(string2);
        System.out.flush();
    }

    public static void clear() {
        if (ansi) {
            TuiWizard.print("\u001b[34m\u001b[2J\r");
        } else {
            TuiWizard.println("");
        }
    }

    public static void normal() {
        if (ansi) {
            TuiWizard.print("\u001b[34m");
        }
    }

    public static void info() {
        if (ansi) {
            TuiWizard.print("\u001b[31m");
        }
    }

    public static void title() {
        if (ansi) {
            TuiWizard.print("\u001b[35m");
        }
    }

    public static void user() {
        TuiWizard.print("> ");
        if (ansi) {
            TuiWizard.print("\u001b[00m");
        }
    }

    public static void println(String string) {
        TuiWizard.print(string + System.getProperty("line.separator"));
    }

    public static void separator() {
        if (ansi) {
            TuiWizard.print("\u001b[33m\u001b[K");
        }
        TuiWizard.print("................................................................................");
        if (ansi) {
            TuiWizard.println("\u001b[34m");
        } else {
            TuiWizard.println("");
        }
    }

    public static VAWizardInterface createWizard() {
        if (UNIQUE_WIZARD == null) {
            UNIQUE_WIZARD = new TuiWizard();
        } else {
            UNIQUE_WIZARD.init();
        }
        return UNIQUE_WIZARD;
    }

    public void setActionEnabled(int n) {
        this.actions_ = n;
    }

    public void setStep(VAStep vAStep) {
        this.step_ = vAStep;
    }

    public void show() {
        TuiWizard.separator();
        String string = "";
        if ((this.actions_ & 8) != 8) {
            string = string + VAGlobals.i18n("TuiWizard_Again");
        }
        if ((this.actions_ & 1) == 1) {
            string = string + VAGlobals.i18n("TuiWizard_Cancel");
        }
        if ((this.actions_ & 2) == 2) {
            string = string + VAGlobals.i18n("TuiWizard_Back");
        }
        if ((this.actions_ & 4) == 4) {
            string = string + VAGlobals.i18n("TuiWizard_Next");
        }
        if ((this.actions_ & 8) == 8) {
            string = string + VAGlobals.i18n("TuiWizard_Finish");
        }
        TuiWizard.title();
        TuiWizard.print(string);
        TuiWizard.user();
        while (true) {
            int n = TuiWizard.key();
            n = Character.toLowerCase((char)n);
            if ((this.actions_ & 1) == 1 && (n == VAGlobals.getResourceInt("com.memoire.vainstall.tui.Language", "TuiWizard_KeyCancel") || n == 27)) {
                this.step_.cancelAction();
                break;
            }
            if ((this.actions_ & 2) == 2 && (n == VAGlobals.getResourceInt("com.memoire.vainstall.tui.Language", "TuiWizard_KeyBack") || n == 2)) {
                this.step_.backAction();
                break;
            }
            if ((this.actions_ & 4) == 4 && (n == VAGlobals.getResourceInt("com.memoire.vainstall.tui.Language", "TuiWizard_KeyNext") || n == 6)) {
                this.step_.nextAction();
                break;
            }
            if ((this.actions_ & 8) == 8 && (n == VAGlobals.getResourceInt("com.memoire.vainstall.tui.Language", "TuiWizard_KeyFinish") || n == 6)) {
                this.step_.nextAction();
                break;
            }
            if ((this.actions_ & 8) != 8 && n == VAGlobals.getResourceInt("com.memoire.vainstall.tui.Language", "TuiWizard_KeyAgain")) {
                ((TuiDefaultStep)this.step_).againAction();
                break;
            }
            TuiWizard.print("\u0007");
            if (!ansi) continue;
            TuiWizard.print("\u001b[24;" + (string.length() + 3) + "H\u001b[K");
        }
    }

    public void dispose(boolean bl) {
        if (bl) {
            TuiWizard.println(VAGlobals.i18n("TuiWizard_WantAbort"));
            TuiWizard.confirm();
        }
    }

    public static boolean confirm() {
        TuiWizard.title();
        TuiWizard.print(VAGlobals.i18n("TuiWizard_YesNo"));
        TuiWizard.user();
        while (true) {
            int n = TuiWizard.key();
            if ((n = (int)Character.toLowerCase((char)n)) == VAGlobals.getResourceInt("com.memoire.vainstall.tui.Language", "TuiWizard_KeyYes")) {
                TuiWizard.println("");
                return true;
            }
            if (n == VAGlobals.getResourceInt("com.memoire.vainstall.tui.Language", "TuiWizard_KeyNo")) {
                TuiWizard.println("");
                return false;
            }
            TuiWizard.print("\u0007");
            if (!ansi) continue;
            TuiWizard.print("\u001b[24;14H\u001b[K");
        }
    }

    public static void error(String string) {
        TuiWizard.clear();
        TuiWizard.title();
        TuiWizard.println(VAGlobals.i18n("TuiWizard_Error"));
        TuiWizard.separator();
        TuiWizard.println("");
        TuiWizard.println(string);
        TuiWizard.println("");
        for (int i = 6; i <= 21; ++i) {
            TuiWizard.println("");
        }
        TuiWizard.enter();
    }
}

