/*
 * Decompiled with CFR 0.152.
 */
package com.memoire.vainstall.xui;

import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.VAStep;
import com.memoire.vainstall.VAStepFactory;
import com.memoire.vainstall.xui.XuiBlueScreen;
import com.memoire.vainstall.xui.XuiDirectoryPanel;
import com.memoire.vainstall.xui.XuiEndPanel;
import com.memoire.vainstall.xui.XuiInstallPanel;
import com.memoire.vainstall.xui.XuiLanguagePanel;
import com.memoire.vainstall.xui.XuiLicenseKeyPanel;
import com.memoire.vainstall.xui.XuiLicensePanel;
import com.memoire.vainstall.xui.XuiOptionPane;
import com.memoire.vainstall.xui.XuiReadmePanel;
import com.memoire.vainstall.xui.XuiShortcutPanel;
import com.memoire.vainstall.xui.XuiUpgradePanel;
import com.memoire.vainstall.xui.XuiWelcomePanel;
import com.memoire.vainstall.xui.XuiWizard;

public class VAXtraUI
extends VAStepFactory {
    XuiBlueScreen blueScreen_;

    public void initUI() {
        if (!VAGlobals.UI_BLUESCREEN) {
            VAGlobals.printDebug("no blue screen");
        } else {
            this.blueScreen_ = new XuiBlueScreen();
            this.blueScreen_.show();
        }
        this.setWizard(XuiWizard.createWizard());
    }

    public void activateUI() {
        if (VAGlobals.UI_BLUESCREEN) {
            ((XuiWizard)this.getWizard()).setLocationRelativeTo(this.blueScreen_);
            ((XuiWizard)this.getWizard()).toFront();
            this.blueScreen_.toBack();
        }
        super.activateUI();
    }

    public void quitUI() {
        super.quitUI();
        this.uiSleep(2000L);
        if (VAGlobals.UI_BLUESCREEN) {
            this.blueScreen_.dispose();
        }
    }

    public void showFatalError(Throwable throwable) {
        XuiOptionPane.showErrorDialog((XuiWizard)this.getWizard(), "" + throwable.getMessage(), VAGlobals.i18n("UI_Error"));
        super.showFatalError(throwable);
    }

    public void showError(Throwable throwable) {
        XuiOptionPane.showErrorDialog((XuiWizard)this.getWizard(), "" + throwable.getMessage(), VAGlobals.i18n("UI_Message"));
        super.showError(throwable);
    }

    public void uiSleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l / 3L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public VAStep createSetupLanguageStep() {
        XuiLanguagePanel xuiLanguagePanel = new XuiLanguagePanel();
        xuiLanguagePanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(xuiLanguagePanel);
        return xuiLanguagePanel;
    }

    public VAStep createWelcomeStep() {
        XuiWelcomePanel xuiWelcomePanel = new XuiWelcomePanel();
        xuiWelcomePanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(xuiWelcomePanel);
        return xuiWelcomePanel;
    }

    public VAStep createLicenseStep() {
        XuiLicensePanel xuiLicensePanel = new XuiLicensePanel();
        xuiLicensePanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(xuiLicensePanel);
        return xuiLicensePanel;
    }

    public VAStep createReadmeStep() {
        XuiReadmePanel xuiReadmePanel = new XuiReadmePanel();
        xuiReadmePanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(xuiReadmePanel);
        return xuiReadmePanel;
    }

    public VAStep createLicenseKeyStep() {
        XuiLicenseKeyPanel xuiLicenseKeyPanel = new XuiLicenseKeyPanel();
        xuiLicenseKeyPanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(xuiLicenseKeyPanel);
        return xuiLicenseKeyPanel;
    }

    public VAStep createUpgradeStep() {
        XuiUpgradePanel xuiUpgradePanel = new XuiUpgradePanel();
        xuiUpgradePanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(xuiUpgradePanel);
        return xuiUpgradePanel;
    }

    public VAStep createDirectoryStep() {
        XuiDirectoryPanel xuiDirectoryPanel = new XuiDirectoryPanel();
        xuiDirectoryPanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(xuiDirectoryPanel);
        return xuiDirectoryPanel;
    }

    public VAStep createInstallStep() {
        XuiInstallPanel xuiInstallPanel = new XuiInstallPanel();
        xuiInstallPanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(xuiInstallPanel);
        return xuiInstallPanel;
    }

    public VAStep createShortcutStep() {
        XuiShortcutPanel xuiShortcutPanel = new XuiShortcutPanel();
        xuiShortcutPanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(xuiShortcutPanel);
        return xuiShortcutPanel;
    }

    public VAStep createEndStep() {
        XuiEndPanel xuiEndPanel = new XuiEndPanel();
        xuiEndPanel.setInstaller(this.getInstaller());
        this.getWizard().setStep(xuiEndPanel);
        return xuiEndPanel;
    }
}

